@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property s3BucketName Name of the S3 Bucket.
 * The following arguments are optional:
 * @property s3KeyPrefix Prefix to use for S3 logs. Defaults to `/`.
 */
public data class InfrastructureConfigurationLoggingS3Logs(
    public val s3BucketName: String,
    public val s3KeyPrefix: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.InfrastructureConfigurationLoggingS3Logs): InfrastructureConfigurationLoggingS3Logs = InfrastructureConfigurationLoggingS3Logs(
            s3BucketName = javaType.s3BucketName(),
            s3KeyPrefix = javaType.s3KeyPrefix().map({ args0 -> args0 }).orElse(null),
        )
    }
}
