@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.inspector.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AssessmentTarget].
 */
@PulumiTagMarker
public class AssessmentTargetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AssessmentTargetArgs = AssessmentTargetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AssessmentTargetArgsBuilder.() -> Unit) {
        val builder = AssessmentTargetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AssessmentTarget {
        val builtJavaResource = com.pulumi.aws.inspector.AssessmentTarget(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AssessmentTarget(builtJavaResource)
    }
}

/**
 * Provides an Inspector Classic Assessment Target
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const bar = new aws.inspector.ResourceGroup("bar", {tags: {
 *     Name: "foo",
 *     Env: "bar",
 * }});
 * const foo = new aws.inspector.AssessmentTarget("foo", {
 *     name: "assessment target",
 *     resourceGroupArn: bar.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * bar = aws.inspector.ResourceGroup("bar", tags={
 *     "Name": "foo",
 *     "Env": "bar",
 * })
 * foo = aws.inspector.AssessmentTarget("foo",
 *     name="assessment target",
 *     resource_group_arn=bar.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bar = new Aws.Inspector.ResourceGroup("bar", new()
 *     {
 *         Tags =
 *         {
 *             { "Name", "foo" },
 *             { "Env", "bar" },
 *         },
 *     });
 *     var foo = new Aws.Inspector.AssessmentTarget("foo", new()
 *     {
 *         Name = "assessment target",
 *         ResourceGroupArn = bar.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/inspector"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		bar, err := inspector.NewResourceGroup(ctx, "bar", &inspector.ResourceGroupArgs{
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("foo"),
 * 				"Env":  pulumi.String("bar"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = inspector.NewAssessmentTarget(ctx, "foo", &inspector.AssessmentTargetArgs{
 * 			Name:             pulumi.String("assessment target"),
 * 			ResourceGroupArn: bar.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.inspector.ResourceGroup;
 * import com.pulumi.aws.inspector.ResourceGroupArgs;
 * import com.pulumi.aws.inspector.AssessmentTarget;
 * import com.pulumi.aws.inspector.AssessmentTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bar = new ResourceGroup("bar", ResourceGroupArgs.builder()
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "foo"),
 *                 Map.entry("Env", "bar")
 *             ))
 *             .build());
 *         var foo = new AssessmentTarget("foo", AssessmentTargetArgs.builder()
 *             .name("assessment target")
 *             .resourceGroupArn(bar.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   bar:
 *     type: aws:inspector:ResourceGroup
 *     properties:
 *       tags:
 *         Name: foo
 *         Env: bar
 *   foo:
 *     type: aws:inspector:AssessmentTarget
 *     properties:
 *       name: assessment target
 *       resourceGroupArn: ${bar.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Inspector Classic Assessment Targets using their Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:inspector/assessmentTarget:AssessmentTarget example arn:aws:inspector:us-east-1:123456789012:target/0-xxxxxxx
 * ```
 */
public class AssessmentTarget internal constructor(
    override val javaResource: com.pulumi.aws.inspector.AssessmentTarget,
) : KotlinCustomResource(javaResource, AssessmentTargetMapper) {
    /**
     * The target assessment ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the assessment target.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Inspector Resource Group Amazon Resource Name (ARN) stating tags for instance matching. If not specified, all EC2 instances in the current AWS account and region are included in the assessment target.
     */
    public val resourceGroupArn: Output<String>?
        get() = javaResource.resourceGroupArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object AssessmentTargetMapper : ResourceMapper<AssessmentTarget> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.inspector.AssessmentTarget::class == javaResource::class

    override fun map(javaResource: Resource): AssessmentTarget = AssessmentTarget(
        javaResource as
            com.pulumi.aws.inspector.AssessmentTarget,
    )
}

/**
 * @see [AssessmentTarget].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AssessmentTarget].
 */
public suspend fun assessmentTarget(
    name: String,
    block: suspend AssessmentTargetResourceBuilder.() -> Unit,
): AssessmentTarget {
    val builder = AssessmentTargetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AssessmentTarget].
 * @param name The _unique_ name of the resulting resource.
 */
public fun assessmentTarget(name: String): AssessmentTarget {
    val builder = AssessmentTargetResourceBuilder()
    builder.name(name)
    return builder.build()
}
