@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.inspector.kotlin

import com.pulumi.aws.inspector.kotlin.outputs.AssessmentTemplateEventSubscription
import com.pulumi.aws.inspector.kotlin.outputs.AssessmentTemplateEventSubscription.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [AssessmentTemplate].
 */
@PulumiTagMarker
public class AssessmentTemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AssessmentTemplateArgs = AssessmentTemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AssessmentTemplateArgsBuilder.() -> Unit) {
        val builder = AssessmentTemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AssessmentTemplate {
        val builtJavaResource = com.pulumi.aws.inspector.AssessmentTemplate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AssessmentTemplate(builtJavaResource)
    }
}

/**
 * Provides an Inspector Classic Assessment Template
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.inspector.AssessmentTemplate("example", {
 *     name: "example",
 *     targetArn: exampleAwsInspectorAssessmentTarget.arn,
 *     duration: 3600,
 *     rulesPackageArns: [
 *         "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-9hgA516p",
 *         "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-H5hpSawc",
 *         "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-JJOtZiqQ",
 *         "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-vg5GGHSD",
 *     ],
 *     eventSubscriptions: [{
 *         event: "ASSESSMENT_RUN_COMPLETED",
 *         topicArn: exampleAwsSnsTopic.arn,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.inspector.AssessmentTemplate("example",
 *     name="example",
 *     target_arn=example_aws_inspector_assessment_target["arn"],
 *     duration=3600,
 *     rules_package_arns=[
 *         "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-9hgA516p",
 *         "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-H5hpSawc",
 *         "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-JJOtZiqQ",
 *         "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-vg5GGHSD",
 *     ],
 *     event_subscriptions=[{
 *         "event": "ASSESSMENT_RUN_COMPLETED",
 *         "topic_arn": example_aws_sns_topic["arn"],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Inspector.AssessmentTemplate("example", new()
 *     {
 *         Name = "example",
 *         TargetArn = exampleAwsInspectorAssessmentTarget.Arn,
 *         Duration = 3600,
 *         RulesPackageArns = new[]
 *         {
 *             "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-9hgA516p",
 *             "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-H5hpSawc",
 *             "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-JJOtZiqQ",
 *             "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-vg5GGHSD",
 *         },
 *         EventSubscriptions = new[]
 *         {
 *             new Aws.Inspector.Inputs.AssessmentTemplateEventSubscriptionArgs
 *             {
 *                 Event = "ASSESSMENT_RUN_COMPLETED",
 *                 TopicArn = exampleAwsSnsTopic.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/inspector"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := inspector.NewAssessmentTemplate(ctx, "example", &inspector.AssessmentTemplateArgs{
 * 			Name:      pulumi.String("example"),
 * 			TargetArn: pulumi.Any(exampleAwsInspectorAssessmentTarget.Arn),
 * 			Duration:  pulumi.Int(3600),
 * 			RulesPackageArns: pulumi.StringArray{
 * 				pulumi.String("arn:aws:inspector:us-west-2:758058086616:rulespackage/0-9hgA516p"),
 * 				pulumi.String("arn:aws:inspector:us-west-2:758058086616:rulespackage/0-H5hpSawc"),
 * 				pulumi.String("arn:aws:inspector:us-west-2:758058086616:rulespackage/0-JJOtZiqQ"),
 * 				pulumi.String("arn:aws:inspector:us-west-2:758058086616:rulespackage/0-vg5GGHSD"),
 * 			},
 * 			EventSubscriptions: inspector.AssessmentTemplateEventSubscriptionArray{
 * 				&inspector.AssessmentTemplateEventSubscriptionArgs{
 * 					Event:    pulumi.String("ASSESSMENT_RUN_COMPLETED"),
 * 					TopicArn: pulumi.Any(exampleAwsSnsTopic.Arn),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.inspector.AssessmentTemplate;
 * import com.pulumi.aws.inspector.AssessmentTemplateArgs;
 * import com.pulumi.aws.inspector.inputs.AssessmentTemplateEventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AssessmentTemplate("example", AssessmentTemplateArgs.builder()
 *             .name("example")
 *             .targetArn(exampleAwsInspectorAssessmentTarget.arn())
 *             .duration(3600)
 *             .rulesPackageArns(
 *                 "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-9hgA516p",
 *                 "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-H5hpSawc",
 *                 "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-JJOtZiqQ",
 *                 "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-vg5GGHSD")
 *             .eventSubscriptions(AssessmentTemplateEventSubscriptionArgs.builder()
 *                 .event("ASSESSMENT_RUN_COMPLETED")
 *                 .topicArn(exampleAwsSnsTopic.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:inspector:AssessmentTemplate
 *     properties:
 *       name: example
 *       targetArn: ${exampleAwsInspectorAssessmentTarget.arn}
 *       duration: 3600
 *       rulesPackageArns:
 *         - arn:aws:inspector:us-west-2:758058086616:rulespackage/0-9hgA516p
 *         - arn:aws:inspector:us-west-2:758058086616:rulespackage/0-H5hpSawc
 *         - arn:aws:inspector:us-west-2:758058086616:rulespackage/0-JJOtZiqQ
 *         - arn:aws:inspector:us-west-2:758058086616:rulespackage/0-vg5GGHSD
 *       eventSubscriptions:
 *         - event: ASSESSMENT_RUN_COMPLETED
 *           topicArn: ${exampleAwsSnsTopic.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_inspector_assessment_template` using the template assessment ARN. For example:
 * ```sh
 * $ pulumi import aws:inspector/assessmentTemplate:AssessmentTemplate example arn:aws:inspector:us-west-2:123456789012:target/0-9IaAzhGR/template/0-WEcjR8CH
 * ```
 */
public class AssessmentTemplate internal constructor(
    override val javaResource: com.pulumi.aws.inspector.AssessmentTemplate,
) : KotlinCustomResource(javaResource, AssessmentTemplateMapper) {
    /**
     * The template assessment ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The duration of the inspector run.
     */
    public val duration: Output<Int>
        get() = javaResource.duration().applyValue({ args0 -> args0 })

    /**
     * A block that enables sending notifications about a specified assessment template event to a designated SNS topic. See Event Subscriptions for details.
     */
    public val eventSubscriptions: Output<List<AssessmentTemplateEventSubscription>>?
        get() = javaResource.eventSubscriptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The name of the assessment template.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The rules to be used during the run.
     */
    public val rulesPackageArns: Output<List<String>>
        get() = javaResource.rulesPackageArns().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Key-value map of tags for the Inspector assessment template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The assessment target ARN to attach the template to.
     */
    public val targetArn: Output<String>
        get() = javaResource.targetArn().applyValue({ args0 -> args0 })
}

public object AssessmentTemplateMapper : ResourceMapper<AssessmentTemplate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.inspector.AssessmentTemplate::class == javaResource::class

    override fun map(javaResource: Resource): AssessmentTemplate = AssessmentTemplate(
        javaResource as
            com.pulumi.aws.inspector.AssessmentTemplate,
    )
}

/**
 * @see [AssessmentTemplate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AssessmentTemplate].
 */
public suspend fun assessmentTemplate(
    name: String,
    block: suspend AssessmentTemplateResourceBuilder.() -> Unit,
): AssessmentTemplate {
    val builder = AssessmentTemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AssessmentTemplate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun assessmentTemplate(name: String): AssessmentTemplate {
    val builder = AssessmentTemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
