@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.inspector.kotlin

import com.pulumi.aws.inspector.AssessmentTemplateArgs.builder
import com.pulumi.aws.inspector.kotlin.inputs.AssessmentTemplateEventSubscriptionArgs
import com.pulumi.aws.inspector.kotlin.inputs.AssessmentTemplateEventSubscriptionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Inspector Classic Assessment Template
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.inspector.AssessmentTemplate("example", {
 *     name: "example",
 *     targetArn: exampleAwsInspectorAssessmentTarget.arn,
 *     duration: 3600,
 *     rulesPackageArns: [
 *         "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-9hgA516p",
 *         "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-H5hpSawc",
 *         "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-JJOtZiqQ",
 *         "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-vg5GGHSD",
 *     ],
 *     eventSubscriptions: [{
 *         event: "ASSESSMENT_RUN_COMPLETED",
 *         topicArn: exampleAwsSnsTopic.arn,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.inspector.AssessmentTemplate("example",
 *     name="example",
 *     target_arn=example_aws_inspector_assessment_target["arn"],
 *     duration=3600,
 *     rules_package_arns=[
 *         "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-9hgA516p",
 *         "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-H5hpSawc",
 *         "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-JJOtZiqQ",
 *         "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-vg5GGHSD",
 *     ],
 *     event_subscriptions=[{
 *         "event": "ASSESSMENT_RUN_COMPLETED",
 *         "topic_arn": example_aws_sns_topic["arn"],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Inspector.AssessmentTemplate("example", new()
 *     {
 *         Name = "example",
 *         TargetArn = exampleAwsInspectorAssessmentTarget.Arn,
 *         Duration = 3600,
 *         RulesPackageArns = new[]
 *         {
 *             "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-9hgA516p",
 *             "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-H5hpSawc",
 *             "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-JJOtZiqQ",
 *             "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-vg5GGHSD",
 *         },
 *         EventSubscriptions = new[]
 *         {
 *             new Aws.Inspector.Inputs.AssessmentTemplateEventSubscriptionArgs
 *             {
 *                 Event = "ASSESSMENT_RUN_COMPLETED",
 *                 TopicArn = exampleAwsSnsTopic.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/inspector"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := inspector.NewAssessmentTemplate(ctx, "example", &inspector.AssessmentTemplateArgs{
 * 			Name:      pulumi.String("example"),
 * 			TargetArn: pulumi.Any(exampleAwsInspectorAssessmentTarget.Arn),
 * 			Duration:  pulumi.Int(3600),
 * 			RulesPackageArns: pulumi.StringArray{
 * 				pulumi.String("arn:aws:inspector:us-west-2:758058086616:rulespackage/0-9hgA516p"),
 * 				pulumi.String("arn:aws:inspector:us-west-2:758058086616:rulespackage/0-H5hpSawc"),
 * 				pulumi.String("arn:aws:inspector:us-west-2:758058086616:rulespackage/0-JJOtZiqQ"),
 * 				pulumi.String("arn:aws:inspector:us-west-2:758058086616:rulespackage/0-vg5GGHSD"),
 * 			},
 * 			EventSubscriptions: inspector.AssessmentTemplateEventSubscriptionArray{
 * 				&inspector.AssessmentTemplateEventSubscriptionArgs{
 * 					Event:    pulumi.String("ASSESSMENT_RUN_COMPLETED"),
 * 					TopicArn: pulumi.Any(exampleAwsSnsTopic.Arn),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.inspector.AssessmentTemplate;
 * import com.pulumi.aws.inspector.AssessmentTemplateArgs;
 * import com.pulumi.aws.inspector.inputs.AssessmentTemplateEventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AssessmentTemplate("example", AssessmentTemplateArgs.builder()
 *             .name("example")
 *             .targetArn(exampleAwsInspectorAssessmentTarget.arn())
 *             .duration(3600)
 *             .rulesPackageArns(
 *                 "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-9hgA516p",
 *                 "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-H5hpSawc",
 *                 "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-JJOtZiqQ",
 *                 "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-vg5GGHSD")
 *             .eventSubscriptions(AssessmentTemplateEventSubscriptionArgs.builder()
 *                 .event("ASSESSMENT_RUN_COMPLETED")
 *                 .topicArn(exampleAwsSnsTopic.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:inspector:AssessmentTemplate
 *     properties:
 *       name: example
 *       targetArn: ${exampleAwsInspectorAssessmentTarget.arn}
 *       duration: 3600
 *       rulesPackageArns:
 *         - arn:aws:inspector:us-west-2:758058086616:rulespackage/0-9hgA516p
 *         - arn:aws:inspector:us-west-2:758058086616:rulespackage/0-H5hpSawc
 *         - arn:aws:inspector:us-west-2:758058086616:rulespackage/0-JJOtZiqQ
 *         - arn:aws:inspector:us-west-2:758058086616:rulespackage/0-vg5GGHSD
 *       eventSubscriptions:
 *         - event: ASSESSMENT_RUN_COMPLETED
 *           topicArn: ${exampleAwsSnsTopic.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_inspector_assessment_template` using the template assessment ARN. For example:
 * ```sh
 * $ pulumi import aws:inspector/assessmentTemplate:AssessmentTemplate example arn:aws:inspector:us-west-2:123456789012:target/0-9IaAzhGR/template/0-WEcjR8CH
 * ```
 * @property duration The duration of the inspector run.
 * @property eventSubscriptions A block that enables sending notifications about a specified assessment template event to a designated SNS topic. See Event Subscriptions for details.
 * @property name The name of the assessment template.
 * @property rulesPackageArns The rules to be used during the run.
 * @property tags Key-value map of tags for the Inspector assessment template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targetArn The assessment target ARN to attach the template to.
 */
public data class AssessmentTemplateArgs(
    public val duration: Output<Int>? = null,
    public val eventSubscriptions: Output<List<AssessmentTemplateEventSubscriptionArgs>>? = null,
    public val name: Output<String>? = null,
    public val rulesPackageArns: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.inspector.AssessmentTemplateArgs> {
    override fun toJava(): com.pulumi.aws.inspector.AssessmentTemplateArgs =
        com.pulumi.aws.inspector.AssessmentTemplateArgs.builder()
            .duration(duration?.applyValue({ args0 -> args0 }))
            .eventSubscriptions(
                eventSubscriptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .rulesPackageArns(rulesPackageArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetArn(targetArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssessmentTemplateArgs].
 */
@PulumiTagMarker
public class AssessmentTemplateArgsBuilder internal constructor() {
    private var duration: Output<Int>? = null

    private var eventSubscriptions: Output<List<AssessmentTemplateEventSubscriptionArgs>>? = null

    private var name: Output<String>? = null

    private var rulesPackageArns: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetArn: Output<String>? = null

    /**
     * @param value The duration of the inspector run.
     */
    @JvmName("sldmkjfywrcaeekb")
    public suspend fun duration(`value`: Output<Int>) {
        this.duration = value
    }

    /**
     * @param value A block that enables sending notifications about a specified assessment template event to a designated SNS topic. See Event Subscriptions for details.
     */
    @JvmName("vtunbdutubqqdble")
    public suspend fun eventSubscriptions(`value`: Output<List<AssessmentTemplateEventSubscriptionArgs>>) {
        this.eventSubscriptions = value
    }

    @JvmName("lufskhrmiurxuiek")
    public suspend fun eventSubscriptions(vararg values: Output<AssessmentTemplateEventSubscriptionArgs>) {
        this.eventSubscriptions = Output.all(values.asList())
    }

    /**
     * @param values A block that enables sending notifications about a specified assessment template event to a designated SNS topic. See Event Subscriptions for details.
     */
    @JvmName("dovhpfnqgrnanaor")
    public suspend fun eventSubscriptions(values: List<Output<AssessmentTemplateEventSubscriptionArgs>>) {
        this.eventSubscriptions = Output.all(values)
    }

    /**
     * @param value The name of the assessment template.
     */
    @JvmName("sumrtqukfwvwvpvw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The rules to be used during the run.
     */
    @JvmName("qowrepqqdpewdsgb")
    public suspend fun rulesPackageArns(`value`: Output<List<String>>) {
        this.rulesPackageArns = value
    }

    @JvmName("jwwqmkxakcegpsvp")
    public suspend fun rulesPackageArns(vararg values: Output<String>) {
        this.rulesPackageArns = Output.all(values.asList())
    }

    /**
     * @param values The rules to be used during the run.
     */
    @JvmName("akwjduxllvjpmekm")
    public suspend fun rulesPackageArns(values: List<Output<String>>) {
        this.rulesPackageArns = Output.all(values)
    }

    /**
     * @param value Key-value map of tags for the Inspector assessment template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ssqydgjhjkalaqjf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The assessment target ARN to attach the template to.
     */
    @JvmName("mpskowflhnmolhgu")
    public suspend fun targetArn(`value`: Output<String>) {
        this.targetArn = value
    }

    /**
     * @param value The duration of the inspector run.
     */
    @JvmName("cjsxymllrdxrbbgb")
    public suspend fun duration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value A block that enables sending notifications about a specified assessment template event to a designated SNS topic. See Event Subscriptions for details.
     */
    @JvmName("agawakrcvgoaraco")
    public suspend fun eventSubscriptions(`value`: List<AssessmentTemplateEventSubscriptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventSubscriptions = mapped
    }

    /**
     * @param argument A block that enables sending notifications about a specified assessment template event to a designated SNS topic. See Event Subscriptions for details.
     */
    @JvmName("nwsjwdabcxxceyed")
    public suspend fun eventSubscriptions(argument: List<suspend AssessmentTemplateEventSubscriptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AssessmentTemplateEventSubscriptionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.eventSubscriptions = mapped
    }

    /**
     * @param argument A block that enables sending notifications about a specified assessment template event to a designated SNS topic. See Event Subscriptions for details.
     */
    @JvmName("ldfpbrkqixlrosxq")
    public suspend fun eventSubscriptions(vararg argument: suspend AssessmentTemplateEventSubscriptionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AssessmentTemplateEventSubscriptionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.eventSubscriptions = mapped
    }

    /**
     * @param argument A block that enables sending notifications about a specified assessment template event to a designated SNS topic. See Event Subscriptions for details.
     */
    @JvmName("irbayskhpcgqxaqq")
    public suspend fun eventSubscriptions(argument: suspend AssessmentTemplateEventSubscriptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AssessmentTemplateEventSubscriptionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.eventSubscriptions = mapped
    }

    /**
     * @param values A block that enables sending notifications about a specified assessment template event to a designated SNS topic. See Event Subscriptions for details.
     */
    @JvmName("tqbsjjbrwrbynfqk")
    public suspend fun eventSubscriptions(vararg values: AssessmentTemplateEventSubscriptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventSubscriptions = mapped
    }

    /**
     * @param value The name of the assessment template.
     */
    @JvmName("nrcamkfxqagvcxee")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The rules to be used during the run.
     */
    @JvmName("mvpoafngqbwnlxga")
    public suspend fun rulesPackageArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rulesPackageArns = mapped
    }

    /**
     * @param values The rules to be used during the run.
     */
    @JvmName("tnswmpmuqmouwpnc")
    public suspend fun rulesPackageArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rulesPackageArns = mapped
    }

    /**
     * @param value Key-value map of tags for the Inspector assessment template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eeoggldmktrpyttg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of tags for the Inspector assessment template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("renultebjmreawxm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The assessment target ARN to attach the template to.
     */
    @JvmName("vkanqyrsoswmbjwa")
    public suspend fun targetArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetArn = mapped
    }

    internal fun build(): AssessmentTemplateArgs = AssessmentTemplateArgs(
        duration = duration,
        eventSubscriptions = eventSubscriptions,
        name = name,
        rulesPackageArns = rulesPackageArns,
        tags = tags,
        targetArn = targetArn,
    )
}
