@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.inspector.kotlin

import com.pulumi.aws.inspector.InspectorFunctions.getRulesPackagesPlain
import com.pulumi.aws.inspector.kotlin.outputs.GetRulesPackagesResult
import com.pulumi.aws.inspector.kotlin.outputs.GetRulesPackagesResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.Suppress

public object InspectorFunctions {
    /**
     * The Amazon Inspector Classic Rules Packages data source allows access to the list of AWS
     * Inspector Rules Packages which can be used by Amazon Inspector Classic within the region
     * configured in the provider.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * // Declare the data source
     * const rules = aws.inspector.getRulesPackages({});
     * // e.g., Use in aws_inspector_assessment_template
     * const group = new aws.inspector.ResourceGroup("group", {tags: {
     *     test: "test",
     * }});
     * const assessment = new aws.inspector.AssessmentTarget("assessment", {
     *     name: "test",
     *     resourceGroupArn: group.arn,
     * });
     * const assessmentAssessmentTemplate = new aws.inspector.AssessmentTemplate("assessment", {
     *     name: "Test",
     *     targetArn: assessment.arn,
     *     duration: 60,
     *     rulesPackageArns: rules.then(rules => rules.arns),
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * # Declare the data source
     * rules = aws.inspector.get_rules_packages()
     * # e.g., Use in aws_inspector_assessment_template
     * group = aws.inspector.ResourceGroup("group", tags={
     *     "test": "test",
     * })
     * assessment = aws.inspector.AssessmentTarget("assessment",
     *     name="test",
     *     resource_group_arn=group.arn)
     * assessment_assessment_template = aws.inspector.AssessmentTemplate("assessment",
     *     name="Test",
     *     target_arn=assessment.arn,
     *     duration=60,
     *     rules_package_arns=rules.arns)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var rules = Aws.Inspector.GetRulesPackages.Invoke();
     *     // e.g., Use in aws_inspector_assessment_template
     *     var @group = new Aws.Inspector.ResourceGroup("group", new()
     *     {
     *         Tags =
     *         {
     *             { "test", "test" },
     *         },
     *     });
     *     var assessment = new Aws.Inspector.AssessmentTarget("assessment", new()
     *     {
     *         Name = "test",
     *         ResourceGroupArn = @group.Arn,
     *     });
     *     var assessmentAssessmentTemplate = new Aws.Inspector.AssessmentTemplate("assessment", new()
     *     {
     *         Name = "Test",
     *         TargetArn = assessment.Arn,
     *         Duration = 60,
     *         RulesPackageArns = rules.Apply(getRulesPackagesResult => getRulesPackagesResult.Arns),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/inspector"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		rules, err := inspector.GetRulesPackages(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// e.g., Use in aws_inspector_assessment_template
     * 		group, err := inspector.NewResourceGroup(ctx, "group", &inspector.ResourceGroupArgs{
     * 			Tags: pulumi.StringMap{
     * 				"test": pulumi.String("test"),
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		assessment, err := inspector.NewAssessmentTarget(ctx, "assessment", &inspector.AssessmentTargetArgs{
     * 			Name:             pulumi.String("test"),
     * 			ResourceGroupArn: group.Arn,
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = inspector.NewAssessmentTemplate(ctx, "assessment", &inspector.AssessmentTemplateArgs{
     * 			Name:             pulumi.String("Test"),
     * 			TargetArn:        assessment.Arn,
     * 			Duration:         pulumi.Int(60),
     * 			RulesPackageArns: interface{}(rules.Arns),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.inspector.InspectorFunctions;
     * import com.pulumi.aws.inspector.ResourceGroup;
     * import com.pulumi.aws.inspector.ResourceGroupArgs;
     * import com.pulumi.aws.inspector.AssessmentTarget;
     * import com.pulumi.aws.inspector.AssessmentTargetArgs;
     * import com.pulumi.aws.inspector.AssessmentTemplate;
     * import com.pulumi.aws.inspector.AssessmentTemplateArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var rules = InspectorFunctions.getRulesPackages();
     *         // e.g., Use in aws_inspector_assessment_template
     *         var group = new ResourceGroup("group", ResourceGroupArgs.builder()
     *             .tags(Map.of("test", "test"))
     *             .build());
     *         var assessment = new AssessmentTarget("assessment", AssessmentTargetArgs.builder()
     *             .name("test")
     *             .resourceGroupArn(group.arn())
     *             .build());
     *         var assessmentAssessmentTemplate = new AssessmentTemplate("assessmentAssessmentTemplate", AssessmentTemplateArgs.builder()
     *             .name("Test")
     *             .targetArn(assessment.arn())
     *             .duration("60")
     *             .rulesPackageArns(rules.applyValue(getRulesPackagesResult -> getRulesPackagesResult.arns()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   # e.g., Use in aws_inspector_assessment_template
     *   group:
     *     type: aws:inspector:ResourceGroup
     *     properties:
     *       tags:
     *         test: test
     *   assessment:
     *     type: aws:inspector:AssessmentTarget
     *     properties:
     *       name: test
     *       resourceGroupArn: ${group.arn}
     *   assessmentAssessmentTemplate:
     *     type: aws:inspector:AssessmentTemplate
     *     name: assessment
     *     properties:
     *       name: Test
     *       targetArn: ${assessment.arn}
     *       duration: '60'
     *       rulesPackageArns: ${rules.arns}
     * variables:
     *   # Declare the data source
     *   rules:
     *     fn::invoke:
     *       Function: aws:inspector:getRulesPackages
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument The Amazon Inspector Classic Rules Packages data source allows access to the list of AWS
     * Inspector Rules Packages which can be used by Amazon Inspector Classic within the region
     * configured in the provider.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * // Declare the data source
     * const rules = aws.inspector.getRulesPackages({});
     * // e.g., Use in aws_inspector_assessment_template
     * const group = new aws.inspector.ResourceGroup("group", {tags: {
     *     test: "test",
     * }});
     * const assessment = new aws.inspector.AssessmentTarget("assessment", {
     *     name: "test",
     *     resourceGroupArn: group.arn,
     * });
     * const assessmentAssessmentTemplate = new aws.inspector.AssessmentTemplate("assessment", {
     *     name: "Test",
     *     targetArn: assessment.arn,
     *     duration: 60,
     *     rulesPackageArns: rules.then(rules => rules.arns),
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * # Declare the data source
     * rules = aws.inspector.get_rules_packages()
     * # e.g., Use in aws_inspector_assessment_template
     * group = aws.inspector.ResourceGroup("group", tags={
     *     "test": "test",
     * })
     * assessment = aws.inspector.AssessmentTarget("assessment",
     *     name="test",
     *     resource_group_arn=group.arn)
     * assessment_assessment_template = aws.inspector.AssessmentTemplate("assessment",
     *     name="Test",
     *     target_arn=assessment.arn,
     *     duration=60,
     *     rules_package_arns=rules.arns)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var rules = Aws.Inspector.GetRulesPackages.Invoke();
     *     // e.g., Use in aws_inspector_assessment_template
     *     var @group = new Aws.Inspector.ResourceGroup("group", new()
     *     {
     *         Tags =
     *         {
     *             { "test", "test" },
     *         },
     *     });
     *     var assessment = new Aws.Inspector.AssessmentTarget("assessment", new()
     *     {
     *         Name = "test",
     *         ResourceGroupArn = @group.Arn,
     *     });
     *     var assessmentAssessmentTemplate = new Aws.Inspector.AssessmentTemplate("assessment", new()
     *     {
     *         Name = "Test",
     *         TargetArn = assessment.Arn,
     *         Duration = 60,
     *         RulesPackageArns = rules.Apply(getRulesPackagesResult => getRulesPackagesResult.Arns),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/inspector"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		rules, err := inspector.GetRulesPackages(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// e.g., Use in aws_inspector_assessment_template
     * 		group, err := inspector.NewResourceGroup(ctx, "group", &inspector.ResourceGroupArgs{
     * 			Tags: pulumi.StringMap{
     * 				"test": pulumi.String("test"),
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		assessment, err := inspector.NewAssessmentTarget(ctx, "assessment", &inspector.AssessmentTargetArgs{
     * 			Name:             pulumi.String("test"),
     * 			ResourceGroupArn: group.Arn,
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = inspector.NewAssessmentTemplate(ctx, "assessment", &inspector.AssessmentTemplateArgs{
     * 			Name:             pulumi.String("Test"),
     * 			TargetArn:        assessment.Arn,
     * 			Duration:         pulumi.Int(60),
     * 			RulesPackageArns: interface{}(rules.Arns),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.inspector.InspectorFunctions;
     * import com.pulumi.aws.inspector.ResourceGroup;
     * import com.pulumi.aws.inspector.ResourceGroupArgs;
     * import com.pulumi.aws.inspector.AssessmentTarget;
     * import com.pulumi.aws.inspector.AssessmentTargetArgs;
     * import com.pulumi.aws.inspector.AssessmentTemplate;
     * import com.pulumi.aws.inspector.AssessmentTemplateArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var rules = InspectorFunctions.getRulesPackages();
     *         // e.g., Use in aws_inspector_assessment_template
     *         var group = new ResourceGroup("group", ResourceGroupArgs.builder()
     *             .tags(Map.of("test", "test"))
     *             .build());
     *         var assessment = new AssessmentTarget("assessment", AssessmentTargetArgs.builder()
     *             .name("test")
     *             .resourceGroupArn(group.arn())
     *             .build());
     *         var assessmentAssessmentTemplate = new AssessmentTemplate("assessmentAssessmentTemplate", AssessmentTemplateArgs.builder()
     *             .name("Test")
     *             .targetArn(assessment.arn())
     *             .duration("60")
     *             .rulesPackageArns(rules.applyValue(getRulesPackagesResult -> getRulesPackagesResult.arns()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   # e.g., Use in aws_inspector_assessment_template
     *   group:
     *     type: aws:inspector:ResourceGroup
     *     properties:
     *       tags:
     *         test: test
     *   assessment:
     *     type: aws:inspector:AssessmentTarget
     *     properties:
     *       name: test
     *       resourceGroupArn: ${group.arn}
     *   assessmentAssessmentTemplate:
     *     type: aws:inspector:AssessmentTemplate
     *     name: assessment
     *     properties:
     *       name: Test
     *       targetArn: ${assessment.arn}
     *       duration: '60'
     *       rulesPackageArns: ${rules.arns}
     * variables:
     *   # Declare the data source
     *   rules:
     *     fn::invoke:
     *       Function: aws:inspector:getRulesPackages
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @return A collection of values returned by getRulesPackages.
     */
    public suspend fun getRulesPackages(): GetRulesPackagesResult =
        toKotlin(getRulesPackagesPlain().await())
}
