@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.inspector.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ResourceGroup].
 */
@PulumiTagMarker
public class ResourceGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourceGroupArgs = ResourceGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourceGroupArgsBuilder.() -> Unit) {
        val builder = ResourceGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ResourceGroup {
        val builtJavaResource = com.pulumi.aws.inspector.ResourceGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ResourceGroup(builtJavaResource)
    }
}

/**
 * Provides an Amazon Inspector Classic Resource Group.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.inspector.ResourceGroup("example", {tags: {
 *     Name: "foo",
 *     Env: "bar",
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.inspector.ResourceGroup("example", tags={
 *     "Name": "foo",
 *     "Env": "bar",
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Inspector.ResourceGroup("example", new()
 *     {
 *         Tags =
 *         {
 *             { "Name", "foo" },
 *             { "Env", "bar" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/inspector"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := inspector.NewResourceGroup(ctx, "example", &inspector.ResourceGroupArgs{
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("foo"),
 * 				"Env":  pulumi.String("bar"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.inspector.ResourceGroup;
 * import com.pulumi.aws.inspector.ResourceGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourceGroup("example", ResourceGroupArgs.builder()
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "foo"),
 *                 Map.entry("Env", "bar")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:inspector:ResourceGroup
 *     properties:
 *       tags:
 *         Name: foo
 *         Env: bar
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class ResourceGroup internal constructor(
    override val javaResource: com.pulumi.aws.inspector.ResourceGroup,
) : KotlinCustomResource(javaResource, ResourceGroupMapper) {
    /**
     * The resource group ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Key-value map of tags that are used to select the EC2 instances to be included in an Amazon Inspector assessment target.
     */
    public val tags: Output<Map<String, String>>
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ResourceGroupMapper : ResourceMapper<ResourceGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.inspector.ResourceGroup::class == javaResource::class

    override fun map(javaResource: Resource): ResourceGroup = ResourceGroup(
        javaResource as
            com.pulumi.aws.inspector.ResourceGroup,
    )
}

/**
 * @see [ResourceGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResourceGroup].
 */
public suspend fun resourceGroup(
    name: String,
    block: suspend ResourceGroupResourceBuilder.() -> Unit,
): ResourceGroup {
    val builder = ResourceGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResourceGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resourceGroup(name: String): ResourceGroup {
    val builder = ResourceGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
