@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.inspector.kotlin

import com.pulumi.aws.inspector.ResourceGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Inspector Classic Resource Group.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.inspector.ResourceGroup("example", {tags: {
 *     Name: "foo",
 *     Env: "bar",
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.inspector.ResourceGroup("example", tags={
 *     "Name": "foo",
 *     "Env": "bar",
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Inspector.ResourceGroup("example", new()
 *     {
 *         Tags =
 *         {
 *             { "Name", "foo" },
 *             { "Env", "bar" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/inspector"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := inspector.NewResourceGroup(ctx, "example", &inspector.ResourceGroupArgs{
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("foo"),
 * 				"Env":  pulumi.String("bar"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.inspector.ResourceGroup;
 * import com.pulumi.aws.inspector.ResourceGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourceGroup("example", ResourceGroupArgs.builder()
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "foo"),
 *                 Map.entry("Env", "bar")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:inspector:ResourceGroup
 *     properties:
 *       tags:
 *         Name: foo
 *         Env: bar
 * ```
 * <!--End PulumiCodeChooser -->
 * @property tags Key-value map of tags that are used to select the EC2 instances to be included in an Amazon Inspector assessment target.
 */
public data class ResourceGroupArgs(
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.inspector.ResourceGroupArgs> {
    override fun toJava(): com.pulumi.aws.inspector.ResourceGroupArgs =
        com.pulumi.aws.inspector.ResourceGroupArgs.builder()
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ResourceGroupArgs].
 */
@PulumiTagMarker
public class ResourceGroupArgsBuilder internal constructor() {
    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Key-value map of tags that are used to select the EC2 instances to be included in an Amazon Inspector assessment target.
     */
    @JvmName("oxonhylndiagfqfl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Key-value map of tags that are used to select the EC2 instances to be included in an Amazon Inspector assessment target.
     */
    @JvmName("slqyvahflfesyyhl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of tags that are used to select the EC2 instances to be included in an Amazon Inspector assessment target.
     */
    @JvmName("gqcqlulcsuejflcc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ResourceGroupArgs = ResourceGroupArgs(
        tags = tags,
    )
}
