@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.inspector.kotlin.inputs

import com.pulumi.aws.inspector.inputs.AssessmentTemplateEventSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property event The event for which you want to receive SNS notifications. Valid values are `ASSESSMENT_RUN_STARTED`, `ASSESSMENT_RUN_COMPLETED`, `ASSESSMENT_RUN_STATE_CHANGED`, and `FINDING_REPORTED`.
 * @property topicArn The ARN of the SNS topic to which notifications are sent.
 */
public data class AssessmentTemplateEventSubscriptionArgs(
    public val event: Output<String>,
    public val topicArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.inspector.inputs.AssessmentTemplateEventSubscriptionArgs> {
    override fun toJava(): com.pulumi.aws.inspector.inputs.AssessmentTemplateEventSubscriptionArgs =
        com.pulumi.aws.inspector.inputs.AssessmentTemplateEventSubscriptionArgs.builder()
            .event(event.applyValue({ args0 -> args0 }))
            .topicArn(topicArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssessmentTemplateEventSubscriptionArgs].
 */
@PulumiTagMarker
public class AssessmentTemplateEventSubscriptionArgsBuilder internal constructor() {
    private var event: Output<String>? = null

    private var topicArn: Output<String>? = null

    /**
     * @param value The event for which you want to receive SNS notifications. Valid values are `ASSESSMENT_RUN_STARTED`, `ASSESSMENT_RUN_COMPLETED`, `ASSESSMENT_RUN_STATE_CHANGED`, and `FINDING_REPORTED`.
     */
    @JvmName("fqcaasckjcfifjae")
    public suspend fun event(`value`: Output<String>) {
        this.event = value
    }

    /**
     * @param value The ARN of the SNS topic to which notifications are sent.
     */
    @JvmName("rpchwkxffmnvchog")
    public suspend fun topicArn(`value`: Output<String>) {
        this.topicArn = value
    }

    /**
     * @param value The event for which you want to receive SNS notifications. Valid values are `ASSESSMENT_RUN_STARTED`, `ASSESSMENT_RUN_COMPLETED`, `ASSESSMENT_RUN_STATE_CHANGED`, and `FINDING_REPORTED`.
     */
    @JvmName("lxnmudhnehyqdupm")
    public suspend fun event(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.event = mapped
    }

    /**
     * @param value The ARN of the SNS topic to which notifications are sent.
     */
    @JvmName("kuqidcoifxqiqkeg")
    public suspend fun topicArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topicArn = mapped
    }

    internal fun build(): AssessmentTemplateEventSubscriptionArgs =
        AssessmentTemplateEventSubscriptionArgs(
            event = event ?: throw PulumiNullFieldException("event"),
            topicArn = topicArn ?: throw PulumiNullFieldException("topicArn"),
        )
}
