@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.inspector.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property event The event for which you want to receive SNS notifications. Valid values are `ASSESSMENT_RUN_STARTED`, `ASSESSMENT_RUN_COMPLETED`, `ASSESSMENT_RUN_STATE_CHANGED`, and `FINDING_REPORTED`.
 * @property topicArn The ARN of the SNS topic to which notifications are sent.
 */
public data class AssessmentTemplateEventSubscription(
    public val event: String,
    public val topicArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.inspector.outputs.AssessmentTemplateEventSubscription): AssessmentTemplateEventSubscription = AssessmentTemplateEventSubscription(
            event = javaType.event(),
            topicArn = javaType.topicArn(),
        )
    }
}
