@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.inspector2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Enabler].
 */
@PulumiTagMarker
public class EnablerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnablerArgs = EnablerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnablerArgsBuilder.() -> Unit) {
        val builder = EnablerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Enabler {
        val builtJavaResource = com.pulumi.aws.inspector2.Enabler(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Enabler(builtJavaResource)
    }
}

/**
 * Resource for enabling Amazon Inspector resource scans.
 * This resource must be created in the Organization's Administrator Account.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.inspector2.Enabler("example", {
 *     accountIds: ["123456789012"],
 *     resourceTypes: ["EC2"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.inspector2.Enabler("example",
 *     account_ids=["123456789012"],
 *     resource_types=["EC2"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Inspector2.Enabler("example", new()
 *     {
 *         AccountIds = new[]
 *         {
 *             "123456789012",
 *         },
 *         ResourceTypes = new[]
 *         {
 *             "EC2",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/inspector2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := inspector2.NewEnabler(ctx, "example", &inspector2.EnablerArgs{
 * 			AccountIds: pulumi.StringArray{
 * 				pulumi.String("123456789012"),
 * 			},
 * 			ResourceTypes: pulumi.StringArray{
 * 				pulumi.String("EC2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.inspector2.Enabler;
 * import com.pulumi.aws.inspector2.EnablerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Enabler("example", EnablerArgs.builder()
 *             .accountIds("123456789012")
 *             .resourceTypes("EC2")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:inspector2:Enabler
 *     properties:
 *       accountIds:
 *         - '123456789012'
 *       resourceTypes:
 *         - EC2
 * ```
 * <!--End PulumiCodeChooser -->
 * ### For the Calling Account
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getCallerIdentity({});
 * const test = new aws.inspector2.Enabler("test", {
 *     accountIds: [current&#46;then(current => current&#46;accountId)],
 *     resourceTypes: [
 *         "ECR",
 *         "EC2",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_caller_identity()
 * test = aws.inspector2.Enabler("test",
 *     account_ids=[current&#46;account_id],
 *     resource_types=[
 *         "ECR",
 *         "EC2",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetCallerIdentity.Invoke();
 *     var test = new Aws.Inspector2.Enabler("test", new()
 *     {
 *         AccountIds = new[]
 *         {
 *             current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId),
 *         },
 *         ResourceTypes = new[]
 *         {
 *             "ECR",
 *             "EC2",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/inspector2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = inspector2.NewEnabler(ctx, "test", &inspector2.EnablerArgs{
 * 			AccountIds: pulumi.StringArray{
 * 				pulumi.String(current.AccountId),
 * 			},
 * 			ResourceTypes: pulumi.StringArray{
 * 				pulumi.String("ECR"),
 * 				pulumi.String("EC2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inspector2.Enabler;
 * import com.pulumi.aws.inspector2.EnablerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var test = new Enabler("test", EnablerArgs.builder()
 *             .accountIds(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *             .resourceTypes(
 *                 "ECR",
 *                 "EC2")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:inspector2:Enabler
 *     properties:
 *       accountIds:
 *         - ${current.accountId}
 *       resourceTypes:
 *         - ECR
 *         - EC2
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class Enabler internal constructor(
    override val javaResource: com.pulumi.aws.inspector2.Enabler,
) : KotlinCustomResource(javaResource, EnablerMapper) {
    /**
     * Set of account IDs.
     * Can contain one of: the Organization's Administrator Account, or one or more Member Accounts.
     */
    public val accountIds: Output<List<String>>
        get() = javaResource.accountIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Type of resources to scan.
     * Valid values are `EC2`, `ECR`, `LAMBDA` and `LAMBDA_CODE`.
     * At least one item is required.
     */
    public val resourceTypes: Output<List<String>>
        get() = javaResource.resourceTypes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object EnablerMapper : ResourceMapper<Enabler> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.inspector2.Enabler::class == javaResource::class

    override fun map(javaResource: Resource): Enabler = Enabler(
        javaResource as
            com.pulumi.aws.inspector2.Enabler,
    )
}

/**
 * @see [Enabler].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Enabler].
 */
public suspend fun enabler(name: String, block: suspend EnablerResourceBuilder.() -> Unit): Enabler {
    val builder = EnablerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Enabler].
 * @param name The _unique_ name of the resulting resource.
 */
public fun enabler(name: String): Enabler {
    val builder = EnablerResourceBuilder()
    builder.name(name)
    return builder.build()
}
