@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.inspector2.kotlin

import com.pulumi.aws.inspector2.EnablerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Resource for enabling Amazon Inspector resource scans.
 * This resource must be created in the Organization's Administrator Account.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.inspector2.Enabler("example", {
 *     accountIds: ["123456789012"],
 *     resourceTypes: ["EC2"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.inspector2.Enabler("example",
 *     account_ids=["123456789012"],
 *     resource_types=["EC2"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Inspector2.Enabler("example", new()
 *     {
 *         AccountIds = new[]
 *         {
 *             "123456789012",
 *         },
 *         ResourceTypes = new[]
 *         {
 *             "EC2",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/inspector2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := inspector2.NewEnabler(ctx, "example", &inspector2.EnablerArgs{
 * 			AccountIds: pulumi.StringArray{
 * 				pulumi.String("123456789012"),
 * 			},
 * 			ResourceTypes: pulumi.StringArray{
 * 				pulumi.String("EC2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.inspector2.Enabler;
 * import com.pulumi.aws.inspector2.EnablerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Enabler("example", EnablerArgs.builder()
 *             .accountIds("123456789012")
 *             .resourceTypes("EC2")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:inspector2:Enabler
 *     properties:
 *       accountIds:
 *         - '123456789012'
 *       resourceTypes:
 *         - EC2
 * ```
 * <!--End PulumiCodeChooser -->
 * ### For the Calling Account
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getCallerIdentity({});
 * const test = new aws.inspector2.Enabler("test", {
 *     accountIds: [current&#46;then(current => current&#46;accountId)],
 *     resourceTypes: [
 *         "ECR",
 *         "EC2",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_caller_identity()
 * test = aws.inspector2.Enabler("test",
 *     account_ids=[current&#46;account_id],
 *     resource_types=[
 *         "ECR",
 *         "EC2",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetCallerIdentity.Invoke();
 *     var test = new Aws.Inspector2.Enabler("test", new()
 *     {
 *         AccountIds = new[]
 *         {
 *             current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId),
 *         },
 *         ResourceTypes = new[]
 *         {
 *             "ECR",
 *             "EC2",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/inspector2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = inspector2.NewEnabler(ctx, "test", &inspector2.EnablerArgs{
 * 			AccountIds: pulumi.StringArray{
 * 				pulumi.String(current.AccountId),
 * 			},
 * 			ResourceTypes: pulumi.StringArray{
 * 				pulumi.String("ECR"),
 * 				pulumi.String("EC2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inspector2.Enabler;
 * import com.pulumi.aws.inspector2.EnablerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var test = new Enabler("test", EnablerArgs.builder()
 *             .accountIds(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *             .resourceTypes(
 *                 "ECR",
 *                 "EC2")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:inspector2:Enabler
 *     properties:
 *       accountIds:
 *         - ${current.accountId}
 *       resourceTypes:
 *         - ECR
 *         - EC2
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * @property accountIds Set of account IDs.
 * Can contain one of: the Organization's Administrator Account, or one or more Member Accounts.
 * @property resourceTypes Type of resources to scan.
 * Valid values are `EC2`, `ECR`, `LAMBDA` and `LAMBDA_CODE`.
 * At least one item is required.
 */
public data class EnablerArgs(
    public val accountIds: Output<List<String>>? = null,
    public val resourceTypes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.inspector2.EnablerArgs> {
    override fun toJava(): com.pulumi.aws.inspector2.EnablerArgs =
        com.pulumi.aws.inspector2.EnablerArgs.builder()
            .accountIds(accountIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceTypes(resourceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [EnablerArgs].
 */
@PulumiTagMarker
public class EnablerArgsBuilder internal constructor() {
    private var accountIds: Output<List<String>>? = null

    private var resourceTypes: Output<List<String>>? = null

    /**
     * @param value Set of account IDs.
     * Can contain one of: the Organization's Administrator Account, or one or more Member Accounts.
     */
    @JvmName("agaxcolepgwdetxk")
    public suspend fun accountIds(`value`: Output<List<String>>) {
        this.accountIds = value
    }

    @JvmName("iiwreevnxacahdss")
    public suspend fun accountIds(vararg values: Output<String>) {
        this.accountIds = Output.all(values.asList())
    }

    /**
     * @param values Set of account IDs.
     * Can contain one of: the Organization's Administrator Account, or one or more Member Accounts.
     */
    @JvmName("yetoofyembxsrcoa")
    public suspend fun accountIds(values: List<Output<String>>) {
        this.accountIds = Output.all(values)
    }

    /**
     * @param value Type of resources to scan.
     * Valid values are `EC2`, `ECR`, `LAMBDA` and `LAMBDA_CODE`.
     * At least one item is required.
     */
    @JvmName("cfvmmnnxawcfrsul")
    public suspend fun resourceTypes(`value`: Output<List<String>>) {
        this.resourceTypes = value
    }

    @JvmName("iuwvpvaijsmifpaf")
    public suspend fun resourceTypes(vararg values: Output<String>) {
        this.resourceTypes = Output.all(values.asList())
    }

    /**
     * @param values Type of resources to scan.
     * Valid values are `EC2`, `ECR`, `LAMBDA` and `LAMBDA_CODE`.
     * At least one item is required.
     */
    @JvmName("tgactoflkddwuqhd")
    public suspend fun resourceTypes(values: List<Output<String>>) {
        this.resourceTypes = Output.all(values)
    }

    /**
     * @param value Set of account IDs.
     * Can contain one of: the Organization's Administrator Account, or one or more Member Accounts.
     */
    @JvmName("pjrrnfcmdlkgcpuj")
    public suspend fun accountIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountIds = mapped
    }

    /**
     * @param values Set of account IDs.
     * Can contain one of: the Organization's Administrator Account, or one or more Member Accounts.
     */
    @JvmName("cwdulikbxubsswhx")
    public suspend fun accountIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountIds = mapped
    }

    /**
     * @param value Type of resources to scan.
     * Valid values are `EC2`, `ECR`, `LAMBDA` and `LAMBDA_CODE`.
     * At least one item is required.
     */
    @JvmName("crreascxfjbuogwt")
    public suspend fun resourceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    /**
     * @param values Type of resources to scan.
     * Valid values are `EC2`, `ECR`, `LAMBDA` and `LAMBDA_CODE`.
     * At least one item is required.
     */
    @JvmName("vyqadabubmrlrhei")
    public suspend fun resourceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    internal fun build(): EnablerArgs = EnablerArgs(
        accountIds = accountIds,
        resourceTypes = resourceTypes,
    )
}
