@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.inspector2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [MemberAssociation].
 */
@PulumiTagMarker
public class MemberAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MemberAssociationArgs = MemberAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MemberAssociationArgsBuilder.() -> Unit) {
        val builder = MemberAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MemberAssociation {
        val builtJavaResource = com.pulumi.aws.inspector2.MemberAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MemberAssociation(builtJavaResource)
    }
}

/**
 * Resource for associating accounts to existing Inspector instances.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.inspector2.MemberAssociation("example", {accountId: "123456789012"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.inspector2.MemberAssociation("example", account_id="123456789012")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Inspector2.MemberAssociation("example", new()
 *     {
 *         AccountId = "123456789012",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/inspector2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := inspector2.NewMemberAssociation(ctx, "example", &inspector2.MemberAssociationArgs{
 * 			AccountId: pulumi.String("123456789012"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.inspector2.MemberAssociation;
 * import com.pulumi.aws.inspector2.MemberAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MemberAssociation("example", MemberAssociationArgs.builder()
 *             .accountId("123456789012")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:inspector2:MemberAssociation
 *     properties:
 *       accountId: '123456789012'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amazon Inspector Member Association using the `account_id`. For example:
 * ```sh
 * $ pulumi import aws:inspector2/memberAssociation:MemberAssociation example 123456789012
 * ```
 */
public class MemberAssociation internal constructor(
    override val javaResource: com.pulumi.aws.inspector2.MemberAssociation,
) : KotlinCustomResource(javaResource, MemberAssociationMapper) {
    /**
     * ID of the account to associate
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * Account ID of the delegated administrator account
     */
    public val delegatedAdminAccountId: Output<String>
        get() = javaResource.delegatedAdminAccountId().applyValue({ args0 -> args0 })

    /**
     * Status of the member relationship
     */
    public val relationshipStatus: Output<String>
        get() = javaResource.relationshipStatus().applyValue({ args0 -> args0 })

    /**
     * Date and time of the last update of the relationship
     */
    public val updatedAt: Output<String>
        get() = javaResource.updatedAt().applyValue({ args0 -> args0 })
}

public object MemberAssociationMapper : ResourceMapper<MemberAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.inspector2.MemberAssociation::class == javaResource::class

    override fun map(javaResource: Resource): MemberAssociation = MemberAssociation(
        javaResource as
            com.pulumi.aws.inspector2.MemberAssociation,
    )
}

/**
 * @see [MemberAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MemberAssociation].
 */
public suspend fun memberAssociation(
    name: String,
    block: suspend MemberAssociationResourceBuilder.() -> Unit,
): MemberAssociation {
    val builder = MemberAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MemberAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun memberAssociation(name: String): MemberAssociation {
    val builder = MemberAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
