@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.inspector2.kotlin.inputs

import com.pulumi.aws.inspector2.inputs.OrganizationConfigurationAutoEnableArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ec2 Whether Amazon EC2 scans are automatically enabled for new members of your Amazon Inspector organization.
 * @property ecr Whether Amazon ECR scans are automatically enabled for new members of your Amazon Inspector organization.
 * @property lambda Whether Lambda Function scans are automatically enabled for new members of your Amazon Inspector organization.
 * @property lambdaCode Whether AWS Lambda code scans are automatically enabled for new members of your Amazon Inspector organization. **Note:** Lambda code scanning requires Lambda standard scanning to be activated. Consequently, if you are setting this argument to `true`, you must also set the `lambda` argument to `true`. See [Scanning AWS Lambda functions with Amazon Inspector](https://docs.aws.amazon.com/inspector/latest/user/scanning-lambda.html#lambda-code-scans) for more information.
 */
public data class OrganizationConfigurationAutoEnableArgs(
    public val ec2: Output<Boolean>,
    public val ecr: Output<Boolean>,
    public val lambda: Output<Boolean>? = null,
    public val lambdaCode: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.inspector2.inputs.OrganizationConfigurationAutoEnableArgs> {
    override fun toJava(): com.pulumi.aws.inspector2.inputs.OrganizationConfigurationAutoEnableArgs =
        com.pulumi.aws.inspector2.inputs.OrganizationConfigurationAutoEnableArgs.builder()
            .ec2(ec2.applyValue({ args0 -> args0 }))
            .ecr(ecr.applyValue({ args0 -> args0 }))
            .lambda(lambda?.applyValue({ args0 -> args0 }))
            .lambdaCode(lambdaCode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OrganizationConfigurationAutoEnableArgs].
 */
@PulumiTagMarker
public class OrganizationConfigurationAutoEnableArgsBuilder internal constructor() {
    private var ec2: Output<Boolean>? = null

    private var ecr: Output<Boolean>? = null

    private var lambda: Output<Boolean>? = null

    private var lambdaCode: Output<Boolean>? = null

    /**
     * @param value Whether Amazon EC2 scans are automatically enabled for new members of your Amazon Inspector organization.
     */
    @JvmName("mywkuqdwsubifesv")
    public suspend fun ec2(`value`: Output<Boolean>) {
        this.ec2 = value
    }

    /**
     * @param value Whether Amazon ECR scans are automatically enabled for new members of your Amazon Inspector organization.
     */
    @JvmName("yjkmvmhgbiewfqur")
    public suspend fun ecr(`value`: Output<Boolean>) {
        this.ecr = value
    }

    /**
     * @param value Whether Lambda Function scans are automatically enabled for new members of your Amazon Inspector organization.
     */
    @JvmName("irsjigpitmmuukfh")
    public suspend fun lambda(`value`: Output<Boolean>) {
        this.lambda = value
    }

    /**
     * @param value Whether AWS Lambda code scans are automatically enabled for new members of your Amazon Inspector organization. **Note:** Lambda code scanning requires Lambda standard scanning to be activated. Consequently, if you are setting this argument to `true`, you must also set the `lambda` argument to `true`. See [Scanning AWS Lambda functions with Amazon Inspector](https://docs.aws.amazon.com/inspector/latest/user/scanning-lambda.html#lambda-code-scans) for more information.
     */
    @JvmName("xkodfumymohlbsmt")
    public suspend fun lambdaCode(`value`: Output<Boolean>) {
        this.lambdaCode = value
    }

    /**
     * @param value Whether Amazon EC2 scans are automatically enabled for new members of your Amazon Inspector organization.
     */
    @JvmName("liuvsymgqjeamnrh")
    public suspend fun ec2(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ec2 = mapped
    }

    /**
     * @param value Whether Amazon ECR scans are automatically enabled for new members of your Amazon Inspector organization.
     */
    @JvmName("afgpmtlsfyojpnwo")
    public suspend fun ecr(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ecr = mapped
    }

    /**
     * @param value Whether Lambda Function scans are automatically enabled for new members of your Amazon Inspector organization.
     */
    @JvmName("rccmpvqvcswbxdkb")
    public suspend fun lambda(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambda = mapped
    }

    /**
     * @param value Whether AWS Lambda code scans are automatically enabled for new members of your Amazon Inspector organization. **Note:** Lambda code scanning requires Lambda standard scanning to be activated. Consequently, if you are setting this argument to `true`, you must also set the `lambda` argument to `true`. See [Scanning AWS Lambda functions with Amazon Inspector](https://docs.aws.amazon.com/inspector/latest/user/scanning-lambda.html#lambda-code-scans) for more information.
     */
    @JvmName("okoqjwrjvhylyqks")
    public suspend fun lambdaCode(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaCode = mapped
    }

    internal fun build(): OrganizationConfigurationAutoEnableArgs =
        OrganizationConfigurationAutoEnableArgs(
            ec2 = ec2 ?: throw PulumiNullFieldException("ec2"),
            ecr = ecr ?: throw PulumiNullFieldException("ecr"),
            lambda = lambda,
            lambdaCode = lambdaCode,
        )
}
