@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.inspector2.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property ec2 Whether Amazon EC2 scans are automatically enabled for new members of your Amazon Inspector organization.
 * @property ecr Whether Amazon ECR scans are automatically enabled for new members of your Amazon Inspector organization.
 * @property lambda Whether Lambda Function scans are automatically enabled for new members of your Amazon Inspector organization.
 * @property lambdaCode Whether AWS Lambda code scans are automatically enabled for new members of your Amazon Inspector organization. **Note:** Lambda code scanning requires Lambda standard scanning to be activated. Consequently, if you are setting this argument to `true`, you must also set the `lambda` argument to `true`. See [Scanning AWS Lambda functions with Amazon Inspector](https://docs.aws.amazon.com/inspector/latest/user/scanning-lambda.html#lambda-code-scans) for more information.
 */
public data class OrganizationConfigurationAutoEnable(
    public val ec2: Boolean,
    public val ecr: Boolean,
    public val lambda: Boolean? = null,
    public val lambdaCode: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.inspector2.outputs.OrganizationConfigurationAutoEnable): OrganizationConfigurationAutoEnable = OrganizationConfigurationAutoEnable(
            ec2 = javaType.ec2(),
            ecr = javaType.ecr(),
            lambda = javaType.lambda().map({ args0 -> args0 }).orElse(null),
            lambdaCode = javaType.lambdaCode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
