@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.AuthorizerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates and manages an AWS IoT Authorizer.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = new aws.iot.Authorizer("example", {
 *     name: "example",
 *     authorizerFunctionArn: exampleAwsLambdaFunction.arn,
 *     signingDisabled: false,
 *     status: "ACTIVE",
 *     tokenKeyName: "Token-Header",
 *     tokenSigningPublicKeys: {
 *         Key1: std.file({
 *             input: "test-fixtures/iot-authorizer-signing-key.pem",
 *         }).then(invoke => invoke.result),
 *     },
 *     tags: {
 *         Name: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.iot.Authorizer("example",
 *     name="example",
 *     authorizer_function_arn=example_aws_lambda_function["arn"],
 *     signing_disabled=False,
 *     status="ACTIVE",
 *     token_key_name="Token-Header",
 *     token_signing_public_keys={
 *         "Key1": std.file(input="test-fixtures/iot-authorizer-signing-key.pem").result,
 *     },
 *     tags={
 *         "Name": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Iot.Authorizer("example", new()
 *     {
 *         Name = "example",
 *         AuthorizerFunctionArn = exampleAwsLambdaFunction.Arn,
 *         SigningDisabled = false,
 *         Status = "ACTIVE",
 *         TokenKeyName = "Token-Header",
 *         TokenSigningPublicKeys =
 *         {
 *             { "Key1", Std.File.Invoke(new()
 *             {
 *                 Input = "test-fixtures/iot-authorizer-signing-key.pem",
 *             }).Apply(invoke => invoke.Result) },
 *         },
 *         Tags =
 *         {
 *             { "Name", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "test-fixtures/iot-authorizer-signing-key.pem",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iot.NewAuthorizer(ctx, "example", &iot.AuthorizerArgs{
 * 			Name:                  pulumi.String("example"),
 * 			AuthorizerFunctionArn: pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 			SigningDisabled:       pulumi.Bool(false),
 * 			Status:                pulumi.String("ACTIVE"),
 * 			TokenKeyName:          pulumi.String("Token-Header"),
 * 			TokenSigningPublicKeys: pulumi.StringMap{
 * 				"Key1": pulumi.String(invokeFile.Result),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.Authorizer;
 * import com.pulumi.aws.iot.AuthorizerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Authorizer("example", AuthorizerArgs.builder()
 *             .name("example")
 *             .authorizerFunctionArn(exampleAwsLambdaFunction.arn())
 *             .signingDisabled(false)
 *             .status("ACTIVE")
 *             .tokenKeyName("Token-Header")
 *             .tokenSigningPublicKeys(Map.of("Key1", StdFunctions.file(FileArgs.builder()
 *                 .input("test-fixtures/iot-authorizer-signing-key.pem")
 *                 .build()).result()))
 *             .tags(Map.of("Name", "example"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iot:Authorizer
 *     properties:
 *       name: example
 *       authorizerFunctionArn: ${exampleAwsLambdaFunction.arn}
 *       signingDisabled: false
 *       status: ACTIVE
 *       tokenKeyName: Token-Header
 *       tokenSigningPublicKeys:
 *         Key1:
 *           fn::invoke:
 *             Function: std:file
 *             Arguments:
 *               input: test-fixtures/iot-authorizer-signing-key.pem
 *             Return: result
 *       tags:
 *         Name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IOT Authorizers using the name. For example:
 * ```sh
 * $ pulumi import aws:iot/authorizer:Authorizer example example
 * ```
 * @property authorizerFunctionArn The ARN of the authorizer's Lambda function.
 * @property enableCachingForHttp Specifies whether the HTTP caching is enabled or not. Default: `false`.
 * @property name The name of the authorizer.
 * @property signingDisabled Specifies whether AWS IoT validates the token signature in an authorization request. Default: `false`.
 * @property status The status of Authorizer request at creation. Valid values: `ACTIVE`, `INACTIVE`. Default: `ACTIVE`.
 * @property tags Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property tokenKeyName The name of the token key used to extract the token from the HTTP headers. This value is required if signing is enabled in your authorizer.
 * @property tokenSigningPublicKeys The public keys used to verify the digital signature returned by your custom authentication service. This value is required if signing is enabled in your authorizer.
 */
public data class AuthorizerArgs(
    public val authorizerFunctionArn: Output<String>? = null,
    public val enableCachingForHttp: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val signingDisabled: Output<Boolean>? = null,
    public val status: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tokenKeyName: Output<String>? = null,
    public val tokenSigningPublicKeys: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.AuthorizerArgs> {
    override fun toJava(): com.pulumi.aws.iot.AuthorizerArgs =
        com.pulumi.aws.iot.AuthorizerArgs.builder()
            .authorizerFunctionArn(authorizerFunctionArn?.applyValue({ args0 -> args0 }))
            .enableCachingForHttp(enableCachingForHttp?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .signingDisabled(signingDisabled?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tokenKeyName(tokenKeyName?.applyValue({ args0 -> args0 }))
            .tokenSigningPublicKeys(
                tokenSigningPublicKeys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AuthorizerArgs].
 */
@PulumiTagMarker
public class AuthorizerArgsBuilder internal constructor() {
    private var authorizerFunctionArn: Output<String>? = null

    private var enableCachingForHttp: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var signingDisabled: Output<Boolean>? = null

    private var status: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tokenKeyName: Output<String>? = null

    private var tokenSigningPublicKeys: Output<Map<String, String>>? = null

    /**
     * @param value The ARN of the authorizer's Lambda function.
     */
    @JvmName("wpsajhqdnvnmjcdv")
    public suspend fun authorizerFunctionArn(`value`: Output<String>) {
        this.authorizerFunctionArn = value
    }

    /**
     * @param value Specifies whether the HTTP caching is enabled or not. Default: `false`.
     */
    @JvmName("qgrklfyubrwecjns")
    public suspend fun enableCachingForHttp(`value`: Output<Boolean>) {
        this.enableCachingForHttp = value
    }

    /**
     * @param value The name of the authorizer.
     */
    @JvmName("gaxtxkwmvoyosrwr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies whether AWS IoT validates the token signature in an authorization request. Default: `false`.
     */
    @JvmName("vfothmoevblmsvbu")
    public suspend fun signingDisabled(`value`: Output<Boolean>) {
        this.signingDisabled = value
    }

    /**
     * @param value The status of Authorizer request at creation. Valid values: `ACTIVE`, `INACTIVE`. Default: `ACTIVE`.
     */
    @JvmName("lgjtoguiluvcdfyx")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ghvyedivjmuimpkk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the token key used to extract the token from the HTTP headers. This value is required if signing is enabled in your authorizer.
     */
    @JvmName("hvqcwpifepfblais")
    public suspend fun tokenKeyName(`value`: Output<String>) {
        this.tokenKeyName = value
    }

    /**
     * @param value The public keys used to verify the digital signature returned by your custom authentication service. This value is required if signing is enabled in your authorizer.
     */
    @JvmName("xryaspdolpqfpgbs")
    public suspend fun tokenSigningPublicKeys(`value`: Output<Map<String, String>>) {
        this.tokenSigningPublicKeys = value
    }

    /**
     * @param value The ARN of the authorizer's Lambda function.
     */
    @JvmName("mihxpxlmveqlowtb")
    public suspend fun authorizerFunctionArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizerFunctionArn = mapped
    }

    /**
     * @param value Specifies whether the HTTP caching is enabled or not. Default: `false`.
     */
    @JvmName("poctkbkwgbusgseq")
    public suspend fun enableCachingForHttp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableCachingForHttp = mapped
    }

    /**
     * @param value The name of the authorizer.
     */
    @JvmName("hujjrdctwfuudtmp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies whether AWS IoT validates the token signature in an authorization request. Default: `false`.
     */
    @JvmName("gsbvewhsmyutuolu")
    public suspend fun signingDisabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signingDisabled = mapped
    }

    /**
     * @param value The status of Authorizer request at creation. Valid values: `ACTIVE`, `INACTIVE`. Default: `ACTIVE`.
     */
    @JvmName("linvdbnitxongdjk")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rhqnhqetsddwwtvf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yjufuuojysnmaldg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the token key used to extract the token from the HTTP headers. This value is required if signing is enabled in your authorizer.
     */
    @JvmName("jhljcnukiepktgmb")
    public suspend fun tokenKeyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokenKeyName = mapped
    }

    /**
     * @param value The public keys used to verify the digital signature returned by your custom authentication service. This value is required if signing is enabled in your authorizer.
     */
    @JvmName("rqrdddehbqdbhsyr")
    public suspend fun tokenSigningPublicKeys(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokenSigningPublicKeys = mapped
    }

    /**
     * @param values The public keys used to verify the digital signature returned by your custom authentication service. This value is required if signing is enabled in your authorizer.
     */
    @JvmName("quyukjldjhcbtvpy")
    public fun tokenSigningPublicKeys(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tokenSigningPublicKeys = mapped
    }

    internal fun build(): AuthorizerArgs = AuthorizerArgs(
        authorizerFunctionArn = authorizerFunctionArn,
        enableCachingForHttp = enableCachingForHttp,
        name = name,
        signingDisabled = signingDisabled,
        status = status,
        tags = tags,
        tokenKeyName = tokenKeyName,
        tokenSigningPublicKeys = tokenSigningPublicKeys,
    )
}
