@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.kotlin.outputs.BillingGroupMetadata
import com.pulumi.aws.iot.kotlin.outputs.BillingGroupProperties
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.iot.kotlin.outputs.BillingGroupMetadata.Companion.toKotlin as billingGroupMetadataToKotlin
import com.pulumi.aws.iot.kotlin.outputs.BillingGroupProperties.Companion.toKotlin as billingGroupPropertiesToKotlin

/**
 * Builder for [BillingGroup].
 */
@PulumiTagMarker
public class BillingGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BillingGroupArgs = BillingGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BillingGroupArgsBuilder.() -> Unit) {
        val builder = BillingGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BillingGroup {
        val builtJavaResource = com.pulumi.aws.iot.BillingGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BillingGroup(builtJavaResource)
    }
}

/**
 * Manages an AWS IoT Billing Group.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.iot.BillingGroup("example", {
 *     name: "example",
 *     properties: {
 *         description: "This is my billing group",
 *     },
 *     tags: {
 *         terraform: "true",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.iot.BillingGroup("example",
 *     name="example",
 *     properties={
 *         "description": "This is my billing group",
 *     },
 *     tags={
 *         "terraform": "true",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Iot.BillingGroup("example", new()
 *     {
 *         Name = "example",
 *         Properties = new Aws.Iot.Inputs.BillingGroupPropertiesArgs
 *         {
 *             Description = "This is my billing group",
 *         },
 *         Tags =
 *         {
 *             { "terraform", "true" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iot.NewBillingGroup(ctx, "example", &iot.BillingGroupArgs{
 * 			Name: pulumi.String("example"),
 * 			Properties: &iot.BillingGroupPropertiesArgs{
 * 				Description: pulumi.String("This is my billing group"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"terraform": pulumi.String("true"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.BillingGroup;
 * import com.pulumi.aws.iot.BillingGroupArgs;
 * import com.pulumi.aws.iot.inputs.BillingGroupPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BillingGroup("example", BillingGroupArgs.builder()
 *             .name("example")
 *             .properties(BillingGroupPropertiesArgs.builder()
 *                 .description("This is my billing group")
 *                 .build())
 *             .tags(Map.of("terraform", "true"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iot:BillingGroup
 *     properties:
 *       name: example
 *       properties:
 *         description: This is my billing group
 *       tags:
 *         terraform: 'true'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IoT Billing Groups using the name. For example:
 * ```sh
 * $ pulumi import aws:iot/billingGroup:BillingGroup example example
 * ```
 */
public class BillingGroup internal constructor(
    override val javaResource: com.pulumi.aws.iot.BillingGroup,
) : KotlinCustomResource(javaResource, BillingGroupMapper) {
    /**
     * The ARN of the Billing Group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    public val metadatas: Output<List<BillingGroupMetadata>>
        get() = javaResource.metadatas().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    billingGroupMetadataToKotlin(args0)
                })
            })
        })

    /**
     * The name of the Billing Group.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Billing Group properties. Defined below.
     */
    public val properties: Output<BillingGroupProperties>?
        get() = javaResource.properties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    billingGroupPropertiesToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Key-value mapping of resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The current version of the Billing Group record in the registry.
     */
    public val version: Output<Int>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object BillingGroupMapper : ResourceMapper<BillingGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iot.BillingGroup::class == javaResource::class

    override fun map(javaResource: Resource): BillingGroup = BillingGroup(
        javaResource as
            com.pulumi.aws.iot.BillingGroup,
    )
}

/**
 * @see [BillingGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BillingGroup].
 */
public suspend fun billingGroup(
    name: String,
    block: suspend BillingGroupResourceBuilder.() -> Unit,
): BillingGroup {
    val builder = BillingGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BillingGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun billingGroup(name: String): BillingGroup {
    val builder = BillingGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
