@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.BillingGroupArgs.builder
import com.pulumi.aws.iot.kotlin.inputs.BillingGroupPropertiesArgs
import com.pulumi.aws.iot.kotlin.inputs.BillingGroupPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an AWS IoT Billing Group.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.iot.BillingGroup("example", {
 *     name: "example",
 *     properties: {
 *         description: "This is my billing group",
 *     },
 *     tags: {
 *         terraform: "true",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.iot.BillingGroup("example",
 *     name="example",
 *     properties={
 *         "description": "This is my billing group",
 *     },
 *     tags={
 *         "terraform": "true",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Iot.BillingGroup("example", new()
 *     {
 *         Name = "example",
 *         Properties = new Aws.Iot.Inputs.BillingGroupPropertiesArgs
 *         {
 *             Description = "This is my billing group",
 *         },
 *         Tags =
 *         {
 *             { "terraform", "true" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iot.NewBillingGroup(ctx, "example", &iot.BillingGroupArgs{
 * 			Name: pulumi.String("example"),
 * 			Properties: &iot.BillingGroupPropertiesArgs{
 * 				Description: pulumi.String("This is my billing group"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"terraform": pulumi.String("true"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.BillingGroup;
 * import com.pulumi.aws.iot.BillingGroupArgs;
 * import com.pulumi.aws.iot.inputs.BillingGroupPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BillingGroup("example", BillingGroupArgs.builder()
 *             .name("example")
 *             .properties(BillingGroupPropertiesArgs.builder()
 *                 .description("This is my billing group")
 *                 .build())
 *             .tags(Map.of("terraform", "true"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iot:BillingGroup
 *     properties:
 *       name: example
 *       properties:
 *         description: This is my billing group
 *       tags:
 *         terraform: 'true'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IoT Billing Groups using the name. For example:
 * ```sh
 * $ pulumi import aws:iot/billingGroup:BillingGroup example example
 * ```
 * @property name The name of the Billing Group.
 * @property properties The Billing Group properties. Defined below.
 * @property tags Key-value mapping of resource tags
 */
public data class BillingGroupArgs(
    public val name: Output<String>? = null,
    public val properties: Output<BillingGroupPropertiesArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.BillingGroupArgs> {
    override fun toJava(): com.pulumi.aws.iot.BillingGroupArgs =
        com.pulumi.aws.iot.BillingGroupArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [BillingGroupArgs].
 */
@PulumiTagMarker
public class BillingGroupArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var properties: Output<BillingGroupPropertiesArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the Billing Group.
     */
    @JvmName("ptymnlobvqfxcrxv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Billing Group properties. Defined below.
     */
    @JvmName("ldcoekqkiafbcykn")
    public suspend fun properties(`value`: Output<BillingGroupPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Key-value mapping of resource tags
     */
    @JvmName("aieauagnxcjrhxeb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the Billing Group.
     */
    @JvmName("aymfgvppvxsdsxgr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The Billing Group properties. Defined below.
     */
    @JvmName("omxrewdyomfrmyyg")
    public suspend fun properties(`value`: BillingGroupPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The Billing Group properties. Defined below.
     */
    @JvmName("pirkfddgtjctkgph")
    public suspend fun properties(argument: suspend BillingGroupPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = BillingGroupPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Key-value mapping of resource tags
     */
    @JvmName("knwokchgydxsboar")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags
     */
    @JvmName("dmnvxdcvunbosjfu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): BillingGroupArgs = BillingGroupArgs(
        name = name,
        properties = properties,
        tags = tags,
    )
}
