@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.kotlin.outputs.CaCertificateRegistrationConfig
import com.pulumi.aws.iot.kotlin.outputs.CaCertificateValidity
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.iot.kotlin.outputs.CaCertificateRegistrationConfig.Companion.toKotlin as caCertificateRegistrationConfigToKotlin
import com.pulumi.aws.iot.kotlin.outputs.CaCertificateValidity.Companion.toKotlin as caCertificateValidityToKotlin

/**
 * Builder for [CaCertificate].
 */
@PulumiTagMarker
public class CaCertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CaCertificateArgs = CaCertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CaCertificateArgsBuilder.() -> Unit) {
        val builder = CaCertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CaCertificate {
        val builtJavaResource = com.pulumi.aws.iot.CaCertificate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CaCertificate(builtJavaResource)
    }
}

/**
 * Creates and manages an AWS IoT CA Certificate.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as tls from "@pulumi/tls";
 * const caPrivateKey = new tls.PrivateKey("ca", {algorithm: "RSA"});
 * const ca = new tls.SelfSignedCert("ca", {
 *     privateKeyPem: caPrivateKey.privateKeyPem,
 *     subject: {
 *         commonName: "example.com",
 *         organization: "ACME Examples, Inc",
 *     },
 *     validityPeriodHours: 12,
 *     allowedUses: [
 *         "key_encipherment",
 *         "digital_signature",
 *         "server_auth",
 *     ],
 *     isCaCertificate: true,
 * });
 * const verificationPrivateKey = new tls.PrivateKey("verification", {algorithm: "RSA"});
 * const example = aws.iot.getRegistrationCode({});
 * const verification = new tls.CertRequest("verification", {
 *     privateKeyPem: verificationPrivateKey.privateKeyPem,
 *     subject: {
 *         commonName: example.then(example => example.registrationCode),
 *     },
 * });
 * const verificationLocallySignedCert = new tls.LocallySignedCert("verification", {
 *     certRequestPem: verification.certRequestPem,
 *     caPrivateKeyPem: caPrivateKey.privateKeyPem,
 *     caCertPem: ca.certPem,
 *     validityPeriodHours: 12,
 *     allowedUses: [
 *         "key_encipherment",
 *         "digital_signature",
 *         "server_auth",
 *     ],
 * });
 * const exampleCaCertificate = new aws.iot.CaCertificate("example", {
 *     active: true,
 *     caCertificatePem: ca.certPem,
 *     verificationCertificatePem: verificationLocallySignedCert.certPem,
 *     allowAutoRegistration: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_tls as tls
 * ca_private_key = tls.PrivateKey("ca", algorithm="RSA")
 * ca = tls.SelfSignedCert("ca",
 *     private_key_pem=ca_private_key.private_key_pem,
 *     subject={
 *         "common_name": "example.com",
 *         "organization": "ACME Examples, Inc",
 *     },
 *     validity_period_hours=12,
 *     allowed_uses=[
 *         "key_encipherment",
 *         "digital_signature",
 *         "server_auth",
 *     ],
 *     is_ca_certificate=True)
 * verification_private_key = tls.PrivateKey("verification", algorithm="RSA")
 * example = aws.iot.get_registration_code()
 * verification = tls.CertRequest("verification",
 *     private_key_pem=verification_private_key.private_key_pem,
 *     subject={
 *         "common_name": example.registration_code,
 *     })
 * verification_locally_signed_cert = tls.LocallySignedCert("verification",
 *     cert_request_pem=verification.cert_request_pem,
 *     ca_private_key_pem=ca_private_key.private_key_pem,
 *     ca_cert_pem=ca.cert_pem,
 *     validity_period_hours=12,
 *     allowed_uses=[
 *         "key_encipherment",
 *         "digital_signature",
 *         "server_auth",
 *     ])
 * example_ca_certificate = aws.iot.CaCertificate("example",
 *     active=True,
 *     ca_certificate_pem=ca.cert_pem,
 *     verification_certificate_pem=verification_locally_signed_cert.cert_pem,
 *     allow_auto_registration=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Tls = Pulumi.Tls;
 * return await Deployment.RunAsync(() =>
 * {
 *     var caPrivateKey = new Tls.PrivateKey("ca", new()
 *     {
 *         Algorithm = "RSA",
 *     });
 *     var ca = new Tls.SelfSignedCert("ca", new()
 *     {
 *         PrivateKeyPem = caPrivateKey.PrivateKeyPem,
 *         Subject = new Tls.Inputs.SelfSignedCertSubjectArgs
 *         {
 *             CommonName = "example.com",
 *             Organization = "ACME Examples, Inc",
 *         },
 *         ValidityPeriodHours = 12,
 *         AllowedUses = new[]
 *         {
 *             "key_encipherment",
 *             "digital_signature",
 *             "server_auth",
 *         },
 *         IsCaCertificate = true,
 *     });
 *     var verificationPrivateKey = new Tls.PrivateKey("verification", new()
 *     {
 *         Algorithm = "RSA",
 *     });
 *     var example = Aws.Iot.GetRegistrationCode.Invoke();
 *     var verification = new Tls.CertRequest("verification", new()
 *     {
 *         PrivateKeyPem = verificationPrivateKey.PrivateKeyPem,
 *         Subject = new Tls.Inputs.CertRequestSubjectArgs
 *         {
 *             CommonName = example.Apply(getRegistrationCodeResult => getRegistrationCodeResult.RegistrationCode),
 *         },
 *     });
 *     var verificationLocallySignedCert = new Tls.LocallySignedCert("verification", new()
 *     {
 *         CertRequestPem = verification.CertRequestPem,
 *         CaPrivateKeyPem = caPrivateKey.PrivateKeyPem,
 *         CaCertPem = ca.CertPem,
 *         ValidityPeriodHours = 12,
 *         AllowedUses = new[]
 *         {
 *             "key_encipherment",
 *             "digital_signature",
 *             "server_auth",
 *         },
 *     });
 *     var exampleCaCertificate = new Aws.Iot.CaCertificate("example", new()
 *     {
 *         Active = true,
 *         CaCertificatePem = ca.CertPem,
 *         VerificationCertificatePem = verificationLocallySignedCert.CertPem,
 *         AllowAutoRegistration = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
 * 	"github.com/pulumi/pulumi-tls/sdk/v4/go/tls"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		caPrivateKey, err := tls.NewPrivateKey(ctx, "ca", &tls.PrivateKeyArgs{
 * 			Algorithm: pulumi.String("RSA"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		ca, err := tls.NewSelfSignedCert(ctx, "ca", &tls.SelfSignedCertArgs{
 * 			PrivateKeyPem: caPrivateKey.PrivateKeyPem,
 * 			Subject: &tls.SelfSignedCertSubjectArgs{
 * 				CommonName:   pulumi.String("example.com"),
 * 				Organization: pulumi.String("ACME Examples, Inc"),
 * 			},
 * 			ValidityPeriodHours: pulumi.Int(12),
 * 			AllowedUses: pulumi.StringArray{
 * 				pulumi.String("key_encipherment"),
 * 				pulumi.String("digital_signature"),
 * 				pulumi.String("server_auth"),
 * 			},
 * 			IsCaCertificate: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		verificationPrivateKey, err := tls.NewPrivateKey(ctx, "verification", &tls.PrivateKeyArgs{
 * 			Algorithm: pulumi.String("RSA"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := iot.GetRegistrationCode(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		verification, err := tls.NewCertRequest(ctx, "verification", &tls.CertRequestArgs{
 * 			PrivateKeyPem: verificationPrivateKey.PrivateKeyPem,
 * 			Subject: &tls.CertRequestSubjectArgs{
 * 				CommonName: pulumi.String(example.RegistrationCode),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		verificationLocallySignedCert, err := tls.NewLocallySignedCert(ctx, "verification", &tls.LocallySignedCertArgs{
 * 			CertRequestPem:      verification.CertRequestPem,
 * 			CaPrivateKeyPem:     caPrivateKey.PrivateKeyPem,
 * 			CaCertPem:           ca.CertPem,
 * 			ValidityPeriodHours: pulumi.Int(12),
 * 			AllowedUses: pulumi.StringArray{
 * 				pulumi.String("key_encipherment"),
 * 				pulumi.String("digital_signature"),
 * 				pulumi.String("server_auth"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iot.NewCaCertificate(ctx, "example", &iot.CaCertificateArgs{
 * 			Active:                     pulumi.Bool(true),
 * 			CaCertificatePem:           ca.CertPem,
 * 			VerificationCertificatePem: verificationLocallySignedCert.CertPem,
 * 			AllowAutoRegistration:      pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.tls.PrivateKey;
 * import com.pulumi.tls.PrivateKeyArgs;
 * import com.pulumi.tls.SelfSignedCert;
 * import com.pulumi.tls.SelfSignedCertArgs;
 * import com.pulumi.tls.inputs.SelfSignedCertSubjectArgs;
 * import com.pulumi.aws.iot.IotFunctions;
 * import com.pulumi.tls.CertRequest;
 * import com.pulumi.tls.CertRequestArgs;
 * import com.pulumi.tls.inputs.CertRequestSubjectArgs;
 * import com.pulumi.tls.LocallySignedCert;
 * import com.pulumi.tls.LocallySignedCertArgs;
 * import com.pulumi.aws.iot.CaCertificate;
 * import com.pulumi.aws.iot.CaCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var caPrivateKey = new PrivateKey("caPrivateKey", PrivateKeyArgs.builder()
 *             .algorithm("RSA")
 *             .build());
 *         var ca = new SelfSignedCert("ca", SelfSignedCertArgs.builder()
 *             .privateKeyPem(caPrivateKey.privateKeyPem())
 *             .subject(SelfSignedCertSubjectArgs.builder()
 *                 .commonName("example.com")
 *                 .organization("ACME Examples, Inc")
 *                 .build())
 *             .validityPeriodHours(12)
 *             .allowedUses(
 *                 "key_encipherment",
 *                 "digital_signature",
 *                 "server_auth")
 *             .isCaCertificate(true)
 *             .build());
 *         var verificationPrivateKey = new PrivateKey("verificationPrivateKey", PrivateKeyArgs.builder()
 *             .algorithm("RSA")
 *             .build());
 *         final var example = IotFunctions.getRegistrationCode();
 *         var verification = new CertRequest("verification", CertRequestArgs.builder()
 *             .privateKeyPem(verificationPrivateKey.privateKeyPem())
 *             .subject(CertRequestSubjectArgs.builder()
 *                 .commonName(example.applyValue(getRegistrationCodeResult -> getRegistrationCodeResult.registrationCode()))
 *                 .build())
 *             .build());
 *         var verificationLocallySignedCert = new LocallySignedCert("verificationLocallySignedCert", LocallySignedCertArgs.builder()
 *             .certRequestPem(verification.certRequestPem())
 *             .caPrivateKeyPem(caPrivateKey.privateKeyPem())
 *             .caCertPem(ca.certPem())
 *             .validityPeriodHours(12)
 *             .allowedUses(
 *                 "key_encipherment",
 *                 "digital_signature",
 *                 "server_auth")
 *             .build());
 *         var exampleCaCertificate = new CaCertificate("exampleCaCertificate", CaCertificateArgs.builder()
 *             .active(true)
 *             .caCertificatePem(ca.certPem())
 *             .verificationCertificatePem(verificationLocallySignedCert.certPem())
 *             .allowAutoRegistration(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   ca:
 *     type: tls:SelfSignedCert
 *     properties:
 *       privateKeyPem: ${caPrivateKey.privateKeyPem}
 *       subject:
 *         commonName: example.com
 *         organization: ACME Examples, Inc
 *       validityPeriodHours: 12
 *       allowedUses:
 *         - key_encipherment
 *         - digital_signature
 *         - server_auth
 *       isCaCertificate: true
 *   caPrivateKey:
 *     type: tls:PrivateKey
 *     name: ca
 *     properties:
 *       algorithm: RSA
 *   verification:
 *     type: tls:CertRequest
 *     properties:
 *       privateKeyPem: ${verificationPrivateKey.privateKeyPem}
 *       subject:
 *         commonName: ${example.registrationCode}
 *   verificationPrivateKey:
 *     type: tls:PrivateKey
 *     name: verification
 *     properties:
 *       algorithm: RSA
 *   verificationLocallySignedCert:
 *     type: tls:LocallySignedCert
 *     name: verification
 *     properties:
 *       certRequestPem: ${verification.certRequestPem}
 *       caPrivateKeyPem: ${caPrivateKey.privateKeyPem}
 *       caCertPem: ${ca.certPem}
 *       validityPeriodHours: 12
 *       allowedUses:
 *         - key_encipherment
 *         - digital_signature
 *         - server_auth
 *   exampleCaCertificate:
 *     type: aws:iot:CaCertificate
 *     name: example
 *     properties:
 *       active: true
 *       caCertificatePem: ${ca.certPem}
 *       verificationCertificatePem: ${verificationLocallySignedCert.certPem}
 *       allowAutoRegistration: true
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:iot:getRegistrationCode
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class CaCertificate internal constructor(
    override val javaResource: com.pulumi.aws.iot.CaCertificate,
) : KotlinCustomResource(javaResource, CaCertificateMapper) {
    /**
     * Boolean flag to indicate if the certificate should be active for device authentication.
     */
    public val active: Output<Boolean>
        get() = javaResource.active().applyValue({ args0 -> args0 })

    /**
     * Boolean flag to indicate if the certificate should be active for device regisration.
     */
    public val allowAutoRegistration: Output<Boolean>
        get() = javaResource.allowAutoRegistration().applyValue({ args0 -> args0 })

    /**
     * The ARN of the created CA certificate.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * PEM encoded CA certificate.
     */
    public val caCertificatePem: Output<String>
        get() = javaResource.caCertificatePem().applyValue({ args0 -> args0 })

    /**
     * The certificate mode in which the CA will be registered. Valida values: `DEFAULT` and `SNI_ONLY`. Default: `DEFAULT`.
     */
    public val certificateMode: Output<String>?
        get() = javaResource.certificateMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The customer version of the CA certificate.
     */
    public val customerVersion: Output<Int>
        get() = javaResource.customerVersion().applyValue({ args0 -> args0 })

    /**
     * The generation ID of the CA certificate.
     */
    public val generationId: Output<String>
        get() = javaResource.generationId().applyValue({ args0 -> args0 })

    /**
     * Information about the registration configuration. See below.
     */
    public val registrationConfig: Output<CaCertificateRegistrationConfig>?
        get() = javaResource.registrationConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> caCertificateRegistrationConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * When the CA certificate is valid.
     */
    public val validities: Output<List<CaCertificateValidity>>
        get() = javaResource.validities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    caCertificateValidityToKotlin(args0)
                })
            })
        })

    /**
     * PEM encoded verification certificate containing the common name of a registration code. Review
     * [CreateVerificationCSR](https://docs.aws.amazon.com/iot/latest/developerguide/register-CA-cert.html). Reuired if `certificate_mode` is `DEFAULT`.
     */
    public val verificationCertificatePem: Output<String>?
        get() = javaResource.verificationCertificatePem().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object CaCertificateMapper : ResourceMapper<CaCertificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iot.CaCertificate::class == javaResource::class

    override fun map(javaResource: Resource): CaCertificate = CaCertificate(
        javaResource as
            com.pulumi.aws.iot.CaCertificate,
    )
}

/**
 * @see [CaCertificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CaCertificate].
 */
public suspend fun caCertificate(
    name: String,
    block: suspend CaCertificateResourceBuilder.() -> Unit,
): CaCertificate {
    val builder = CaCertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CaCertificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun caCertificate(name: String): CaCertificate {
    val builder = CaCertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
