@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.CaCertificateArgs.builder
import com.pulumi.aws.iot.kotlin.inputs.CaCertificateRegistrationConfigArgs
import com.pulumi.aws.iot.kotlin.inputs.CaCertificateRegistrationConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates and manages an AWS IoT CA Certificate.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as tls from "@pulumi/tls";
 * const caPrivateKey = new tls.PrivateKey("ca", {algorithm: "RSA"});
 * const ca = new tls.SelfSignedCert("ca", {
 *     privateKeyPem: caPrivateKey.privateKeyPem,
 *     subject: {
 *         commonName: "example.com",
 *         organization: "ACME Examples, Inc",
 *     },
 *     validityPeriodHours: 12,
 *     allowedUses: [
 *         "key_encipherment",
 *         "digital_signature",
 *         "server_auth",
 *     ],
 *     isCaCertificate: true,
 * });
 * const verificationPrivateKey = new tls.PrivateKey("verification", {algorithm: "RSA"});
 * const example = aws.iot.getRegistrationCode({});
 * const verification = new tls.CertRequest("verification", {
 *     privateKeyPem: verificationPrivateKey.privateKeyPem,
 *     subject: {
 *         commonName: example.then(example => example.registrationCode),
 *     },
 * });
 * const verificationLocallySignedCert = new tls.LocallySignedCert("verification", {
 *     certRequestPem: verification.certRequestPem,
 *     caPrivateKeyPem: caPrivateKey.privateKeyPem,
 *     caCertPem: ca.certPem,
 *     validityPeriodHours: 12,
 *     allowedUses: [
 *         "key_encipherment",
 *         "digital_signature",
 *         "server_auth",
 *     ],
 * });
 * const exampleCaCertificate = new aws.iot.CaCertificate("example", {
 *     active: true,
 *     caCertificatePem: ca.certPem,
 *     verificationCertificatePem: verificationLocallySignedCert.certPem,
 *     allowAutoRegistration: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_tls as tls
 * ca_private_key = tls.PrivateKey("ca", algorithm="RSA")
 * ca = tls.SelfSignedCert("ca",
 *     private_key_pem=ca_private_key.private_key_pem,
 *     subject={
 *         "common_name": "example.com",
 *         "organization": "ACME Examples, Inc",
 *     },
 *     validity_period_hours=12,
 *     allowed_uses=[
 *         "key_encipherment",
 *         "digital_signature",
 *         "server_auth",
 *     ],
 *     is_ca_certificate=True)
 * verification_private_key = tls.PrivateKey("verification", algorithm="RSA")
 * example = aws.iot.get_registration_code()
 * verification = tls.CertRequest("verification",
 *     private_key_pem=verification_private_key.private_key_pem,
 *     subject={
 *         "common_name": example.registration_code,
 *     })
 * verification_locally_signed_cert = tls.LocallySignedCert("verification",
 *     cert_request_pem=verification.cert_request_pem,
 *     ca_private_key_pem=ca_private_key.private_key_pem,
 *     ca_cert_pem=ca.cert_pem,
 *     validity_period_hours=12,
 *     allowed_uses=[
 *         "key_encipherment",
 *         "digital_signature",
 *         "server_auth",
 *     ])
 * example_ca_certificate = aws.iot.CaCertificate("example",
 *     active=True,
 *     ca_certificate_pem=ca.cert_pem,
 *     verification_certificate_pem=verification_locally_signed_cert.cert_pem,
 *     allow_auto_registration=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Tls = Pulumi.Tls;
 * return await Deployment.RunAsync(() =>
 * {
 *     var caPrivateKey = new Tls.PrivateKey("ca", new()
 *     {
 *         Algorithm = "RSA",
 *     });
 *     var ca = new Tls.SelfSignedCert("ca", new()
 *     {
 *         PrivateKeyPem = caPrivateKey.PrivateKeyPem,
 *         Subject = new Tls.Inputs.SelfSignedCertSubjectArgs
 *         {
 *             CommonName = "example.com",
 *             Organization = "ACME Examples, Inc",
 *         },
 *         ValidityPeriodHours = 12,
 *         AllowedUses = new[]
 *         {
 *             "key_encipherment",
 *             "digital_signature",
 *             "server_auth",
 *         },
 *         IsCaCertificate = true,
 *     });
 *     var verificationPrivateKey = new Tls.PrivateKey("verification", new()
 *     {
 *         Algorithm = "RSA",
 *     });
 *     var example = Aws.Iot.GetRegistrationCode.Invoke();
 *     var verification = new Tls.CertRequest("verification", new()
 *     {
 *         PrivateKeyPem = verificationPrivateKey.PrivateKeyPem,
 *         Subject = new Tls.Inputs.CertRequestSubjectArgs
 *         {
 *             CommonName = example.Apply(getRegistrationCodeResult => getRegistrationCodeResult.RegistrationCode),
 *         },
 *     });
 *     var verificationLocallySignedCert = new Tls.LocallySignedCert("verification", new()
 *     {
 *         CertRequestPem = verification.CertRequestPem,
 *         CaPrivateKeyPem = caPrivateKey.PrivateKeyPem,
 *         CaCertPem = ca.CertPem,
 *         ValidityPeriodHours = 12,
 *         AllowedUses = new[]
 *         {
 *             "key_encipherment",
 *             "digital_signature",
 *             "server_auth",
 *         },
 *     });
 *     var exampleCaCertificate = new Aws.Iot.CaCertificate("example", new()
 *     {
 *         Active = true,
 *         CaCertificatePem = ca.CertPem,
 *         VerificationCertificatePem = verificationLocallySignedCert.CertPem,
 *         AllowAutoRegistration = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
 * 	"github.com/pulumi/pulumi-tls/sdk/v4/go/tls"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		caPrivateKey, err := tls.NewPrivateKey(ctx, "ca", &tls.PrivateKeyArgs{
 * 			Algorithm: pulumi.String("RSA"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		ca, err := tls.NewSelfSignedCert(ctx, "ca", &tls.SelfSignedCertArgs{
 * 			PrivateKeyPem: caPrivateKey.PrivateKeyPem,
 * 			Subject: &tls.SelfSignedCertSubjectArgs{
 * 				CommonName:   pulumi.String("example.com"),
 * 				Organization: pulumi.String("ACME Examples, Inc"),
 * 			},
 * 			ValidityPeriodHours: pulumi.Int(12),
 * 			AllowedUses: pulumi.StringArray{
 * 				pulumi.String("key_encipherment"),
 * 				pulumi.String("digital_signature"),
 * 				pulumi.String("server_auth"),
 * 			},
 * 			IsCaCertificate: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		verificationPrivateKey, err := tls.NewPrivateKey(ctx, "verification", &tls.PrivateKeyArgs{
 * 			Algorithm: pulumi.String("RSA"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := iot.GetRegistrationCode(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		verification, err := tls.NewCertRequest(ctx, "verification", &tls.CertRequestArgs{
 * 			PrivateKeyPem: verificationPrivateKey.PrivateKeyPem,
 * 			Subject: &tls.CertRequestSubjectArgs{
 * 				CommonName: pulumi.String(example.RegistrationCode),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		verificationLocallySignedCert, err := tls.NewLocallySignedCert(ctx, "verification", &tls.LocallySignedCertArgs{
 * 			CertRequestPem:      verification.CertRequestPem,
 * 			CaPrivateKeyPem:     caPrivateKey.PrivateKeyPem,
 * 			CaCertPem:           ca.CertPem,
 * 			ValidityPeriodHours: pulumi.Int(12),
 * 			AllowedUses: pulumi.StringArray{
 * 				pulumi.String("key_encipherment"),
 * 				pulumi.String("digital_signature"),
 * 				pulumi.String("server_auth"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iot.NewCaCertificate(ctx, "example", &iot.CaCertificateArgs{
 * 			Active:                     pulumi.Bool(true),
 * 			CaCertificatePem:           ca.CertPem,
 * 			VerificationCertificatePem: verificationLocallySignedCert.CertPem,
 * 			AllowAutoRegistration:      pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.tls.PrivateKey;
 * import com.pulumi.tls.PrivateKeyArgs;
 * import com.pulumi.tls.SelfSignedCert;
 * import com.pulumi.tls.SelfSignedCertArgs;
 * import com.pulumi.tls.inputs.SelfSignedCertSubjectArgs;
 * import com.pulumi.aws.iot.IotFunctions;
 * import com.pulumi.tls.CertRequest;
 * import com.pulumi.tls.CertRequestArgs;
 * import com.pulumi.tls.inputs.CertRequestSubjectArgs;
 * import com.pulumi.tls.LocallySignedCert;
 * import com.pulumi.tls.LocallySignedCertArgs;
 * import com.pulumi.aws.iot.CaCertificate;
 * import com.pulumi.aws.iot.CaCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var caPrivateKey = new PrivateKey("caPrivateKey", PrivateKeyArgs.builder()
 *             .algorithm("RSA")
 *             .build());
 *         var ca = new SelfSignedCert("ca", SelfSignedCertArgs.builder()
 *             .privateKeyPem(caPrivateKey.privateKeyPem())
 *             .subject(SelfSignedCertSubjectArgs.builder()
 *                 .commonName("example.com")
 *                 .organization("ACME Examples, Inc")
 *                 .build())
 *             .validityPeriodHours(12)
 *             .allowedUses(
 *                 "key_encipherment",
 *                 "digital_signature",
 *                 "server_auth")
 *             .isCaCertificate(true)
 *             .build());
 *         var verificationPrivateKey = new PrivateKey("verificationPrivateKey", PrivateKeyArgs.builder()
 *             .algorithm("RSA")
 *             .build());
 *         final var example = IotFunctions.getRegistrationCode();
 *         var verification = new CertRequest("verification", CertRequestArgs.builder()
 *             .privateKeyPem(verificationPrivateKey.privateKeyPem())
 *             .subject(CertRequestSubjectArgs.builder()
 *                 .commonName(example.applyValue(getRegistrationCodeResult -> getRegistrationCodeResult.registrationCode()))
 *                 .build())
 *             .build());
 *         var verificationLocallySignedCert = new LocallySignedCert("verificationLocallySignedCert", LocallySignedCertArgs.builder()
 *             .certRequestPem(verification.certRequestPem())
 *             .caPrivateKeyPem(caPrivateKey.privateKeyPem())
 *             .caCertPem(ca.certPem())
 *             .validityPeriodHours(12)
 *             .allowedUses(
 *                 "key_encipherment",
 *                 "digital_signature",
 *                 "server_auth")
 *             .build());
 *         var exampleCaCertificate = new CaCertificate("exampleCaCertificate", CaCertificateArgs.builder()
 *             .active(true)
 *             .caCertificatePem(ca.certPem())
 *             .verificationCertificatePem(verificationLocallySignedCert.certPem())
 *             .allowAutoRegistration(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   ca:
 *     type: tls:SelfSignedCert
 *     properties:
 *       privateKeyPem: ${caPrivateKey.privateKeyPem}
 *       subject:
 *         commonName: example.com
 *         organization: ACME Examples, Inc
 *       validityPeriodHours: 12
 *       allowedUses:
 *         - key_encipherment
 *         - digital_signature
 *         - server_auth
 *       isCaCertificate: true
 *   caPrivateKey:
 *     type: tls:PrivateKey
 *     name: ca
 *     properties:
 *       algorithm: RSA
 *   verification:
 *     type: tls:CertRequest
 *     properties:
 *       privateKeyPem: ${verificationPrivateKey.privateKeyPem}
 *       subject:
 *         commonName: ${example.registrationCode}
 *   verificationPrivateKey:
 *     type: tls:PrivateKey
 *     name: verification
 *     properties:
 *       algorithm: RSA
 *   verificationLocallySignedCert:
 *     type: tls:LocallySignedCert
 *     name: verification
 *     properties:
 *       certRequestPem: ${verification.certRequestPem}
 *       caPrivateKeyPem: ${caPrivateKey.privateKeyPem}
 *       caCertPem: ${ca.certPem}
 *       validityPeriodHours: 12
 *       allowedUses:
 *         - key_encipherment
 *         - digital_signature
 *         - server_auth
 *   exampleCaCertificate:
 *     type: aws:iot:CaCertificate
 *     name: example
 *     properties:
 *       active: true
 *       caCertificatePem: ${ca.certPem}
 *       verificationCertificatePem: ${verificationLocallySignedCert.certPem}
 *       allowAutoRegistration: true
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:iot:getRegistrationCode
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * @property active Boolean flag to indicate if the certificate should be active for device authentication.
 * @property allowAutoRegistration Boolean flag to indicate if the certificate should be active for device regisration.
 * @property caCertificatePem PEM encoded CA certificate.
 * @property certificateMode The certificate mode in which the CA will be registered. Valida values: `DEFAULT` and `SNI_ONLY`. Default: `DEFAULT`.
 * @property registrationConfig Information about the registration configuration. See below.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property verificationCertificatePem PEM encoded verification certificate containing the common name of a registration code. Review
 * [CreateVerificationCSR](https://docs.aws.amazon.com/iot/latest/developerguide/register-CA-cert.html). Reuired if `certificate_mode` is `DEFAULT`.
 */
public data class CaCertificateArgs(
    public val active: Output<Boolean>? = null,
    public val allowAutoRegistration: Output<Boolean>? = null,
    public val caCertificatePem: Output<String>? = null,
    public val certificateMode: Output<String>? = null,
    public val registrationConfig: Output<CaCertificateRegistrationConfigArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val verificationCertificatePem: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.CaCertificateArgs> {
    override fun toJava(): com.pulumi.aws.iot.CaCertificateArgs =
        com.pulumi.aws.iot.CaCertificateArgs.builder()
            .active(active?.applyValue({ args0 -> args0 }))
            .allowAutoRegistration(allowAutoRegistration?.applyValue({ args0 -> args0 }))
            .caCertificatePem(caCertificatePem?.applyValue({ args0 -> args0 }))
            .certificateMode(certificateMode?.applyValue({ args0 -> args0 }))
            .registrationConfig(
                registrationConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .verificationCertificatePem(verificationCertificatePem?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CaCertificateArgs].
 */
@PulumiTagMarker
public class CaCertificateArgsBuilder internal constructor() {
    private var active: Output<Boolean>? = null

    private var allowAutoRegistration: Output<Boolean>? = null

    private var caCertificatePem: Output<String>? = null

    private var certificateMode: Output<String>? = null

    private var registrationConfig: Output<CaCertificateRegistrationConfigArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var verificationCertificatePem: Output<String>? = null

    /**
     * @param value Boolean flag to indicate if the certificate should be active for device authentication.
     */
    @JvmName("sntljywmjoiqmkre")
    public suspend fun active(`value`: Output<Boolean>) {
        this.active = value
    }

    /**
     * @param value Boolean flag to indicate if the certificate should be active for device regisration.
     */
    @JvmName("uambtrbfrbtdosdq")
    public suspend fun allowAutoRegistration(`value`: Output<Boolean>) {
        this.allowAutoRegistration = value
    }

    /**
     * @param value PEM encoded CA certificate.
     */
    @JvmName("hiptdovetltwcbgc")
    public suspend fun caCertificatePem(`value`: Output<String>) {
        this.caCertificatePem = value
    }

    /**
     * @param value The certificate mode in which the CA will be registered. Valida values: `DEFAULT` and `SNI_ONLY`. Default: `DEFAULT`.
     */
    @JvmName("eecliccndbgeevja")
    public suspend fun certificateMode(`value`: Output<String>) {
        this.certificateMode = value
    }

    /**
     * @param value Information about the registration configuration. See below.
     */
    @JvmName("buwswsacldgsdjmq")
    public suspend fun registrationConfig(`value`: Output<CaCertificateRegistrationConfigArgs>) {
        this.registrationConfig = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("htuqtyhinvvcqbpx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value PEM encoded verification certificate containing the common name of a registration code. Review
     * [CreateVerificationCSR](https://docs.aws.amazon.com/iot/latest/developerguide/register-CA-cert.html). Reuired if `certificate_mode` is `DEFAULT`.
     */
    @JvmName("yehbjberjawvkadl")
    public suspend fun verificationCertificatePem(`value`: Output<String>) {
        this.verificationCertificatePem = value
    }

    /**
     * @param value Boolean flag to indicate if the certificate should be active for device authentication.
     */
    @JvmName("hggqvmymwrdanbwv")
    public suspend fun active(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.active = mapped
    }

    /**
     * @param value Boolean flag to indicate if the certificate should be active for device regisration.
     */
    @JvmName("afseklwemhtmikmu")
    public suspend fun allowAutoRegistration(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowAutoRegistration = mapped
    }

    /**
     * @param value PEM encoded CA certificate.
     */
    @JvmName("rwxnrvagubumklyy")
    public suspend fun caCertificatePem(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caCertificatePem = mapped
    }

    /**
     * @param value The certificate mode in which the CA will be registered. Valida values: `DEFAULT` and `SNI_ONLY`. Default: `DEFAULT`.
     */
    @JvmName("ppmvxfwuvxurxbuc")
    public suspend fun certificateMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateMode = mapped
    }

    /**
     * @param value Information about the registration configuration. See below.
     */
    @JvmName("qjqsotwesneropvr")
    public suspend fun registrationConfig(`value`: CaCertificateRegistrationConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registrationConfig = mapped
    }

    /**
     * @param argument Information about the registration configuration. See below.
     */
    @JvmName("aqhjrhmlcskfdbmm")
    public suspend fun registrationConfig(argument: suspend CaCertificateRegistrationConfigArgsBuilder.() -> Unit) {
        val toBeMapped = CaCertificateRegistrationConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.registrationConfig = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("queojtcbrbwmhhik")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gqakyqskcomljjmw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value PEM encoded verification certificate containing the common name of a registration code. Review
     * [CreateVerificationCSR](https://docs.aws.amazon.com/iot/latest/developerguide/register-CA-cert.html). Reuired if `certificate_mode` is `DEFAULT`.
     */
    @JvmName("miqpkbxnhnkeldds")
    public suspend fun verificationCertificatePem(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verificationCertificatePem = mapped
    }

    internal fun build(): CaCertificateArgs = CaCertificateArgs(
        active = active,
        allowAutoRegistration = allowAutoRegistration,
        caCertificatePem = caCertificatePem,
        certificateMode = certificateMode,
        registrationConfig = registrationConfig,
        tags = tags,
        verificationCertificatePem = verificationCertificatePem,
    )
}
