@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.kotlin.outputs.DomainConfigurationAuthorizerConfig
import com.pulumi.aws.iot.kotlin.outputs.DomainConfigurationTlsConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.iot.kotlin.outputs.DomainConfigurationAuthorizerConfig.Companion.toKotlin as domainConfigurationAuthorizerConfigToKotlin
import com.pulumi.aws.iot.kotlin.outputs.DomainConfigurationTlsConfig.Companion.toKotlin as domainConfigurationTlsConfigToKotlin

/**
 * Builder for [DomainConfiguration].
 */
@PulumiTagMarker
public class DomainConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainConfigurationArgs = DomainConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainConfigurationArgsBuilder.() -> Unit) {
        val builder = DomainConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DomainConfiguration {
        val builtJavaResource = com.pulumi.aws.iot.DomainConfiguration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DomainConfiguration(builtJavaResource)
    }
}

/**
 * Creates and manages an AWS IoT domain configuration.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const iot = new aws.iot.DomainConfiguration("iot", {
 *     name: "iot-",
 *     domainName: "iot.example.com",
 *     serviceType: "DATA",
 *     serverCertificateArns: [cert&#46;arn],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * iot = aws.iot.DomainConfiguration("iot",
 *     name="iot-",
 *     domain_name="iot.example.com",
 *     service_type="DATA",
 *     server_certificate_arns=[cert["arn"]])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iot = new Aws.Iot.DomainConfiguration("iot", new()
 *     {
 *         Name = "iot-",
 *         DomainName = "iot.example.com",
 *         ServiceType = "DATA",
 *         ServerCertificateArns = new[]
 *         {
 *             cert.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iot.NewDomainConfiguration(ctx, "iot", &iot.DomainConfigurationArgs{
 * 			Name:        pulumi.String("iot-"),
 * 			DomainName:  pulumi.String("iot.example.com"),
 * 			ServiceType: pulumi.String("DATA"),
 * 			ServerCertificateArns: pulumi.StringArray{
 * 				cert.Arn,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.DomainConfiguration;
 * import com.pulumi.aws.iot.DomainConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iot = new DomainConfiguration("iot", DomainConfigurationArgs.builder()
 *             .name("iot-")
 *             .domainName("iot.example.com")
 *             .serviceType("DATA")
 *             .serverCertificateArns(cert.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   iot:
 *     type: aws:iot:DomainConfiguration
 *     properties:
 *       name: iot-
 *       domainName: iot.example.com
 *       serviceType: DATA
 *       serverCertificateArns:
 *         - ${cert.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import domain configurations using the name. For example:
 * ```sh
 * $ pulumi import aws:iot/domainConfiguration:DomainConfiguration example example
 * ```
 */
public class DomainConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.iot.DomainConfiguration,
) : KotlinCustomResource(javaResource, DomainConfigurationMapper) {
    /**
     * The ARN of the domain configuration.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * An object that specifies the authorization service for a domain. See the `authorizer_config` Block below for details.
     */
    public val authorizerConfig: Output<DomainConfigurationAuthorizerConfig>?
        get() = javaResource.authorizerConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> domainConfigurationAuthorizerConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Fully-qualified domain name.
     */
    public val domainName: Output<String>?
        get() = javaResource.domainName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the domain.
     */
    public val domainType: Output<String>
        get() = javaResource.domainType().applyValue({ args0 -> args0 })

    /**
     * The name of the domain configuration. This value must be unique to a region.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ARNs of the certificates that IoT passes to the device during the TLS handshake. Currently you can specify only one certificate ARN. This value is not required for Amazon Web Services-managed domains. When using a custom `domain_name`, the cert must include it.
     */
    public val serverCertificateArns: Output<List<String>>?
        get() = javaResource.serverCertificateArns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The type of service delivered by the endpoint. Note: Amazon Web Services IoT Core currently supports only the `DATA` service type.
     */
    public val serviceType: Output<String>?
        get() = javaResource.serviceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status to which the domain configuration should be set. Valid values are `ENABLED` and `DISABLED`.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * An object that specifies the TLS configuration for a domain. See the `tls_config` Block below for details.
     */
    public val tlsConfig: Output<DomainConfigurationTlsConfig>
        get() = javaResource.tlsConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                domainConfigurationTlsConfigToKotlin(args0)
            })
        })

    /**
     * The certificate used to validate the server certificate and prove domain name ownership. This certificate must be signed by a public certificate authority. This value is not required for Amazon Web Services-managed domains.
     */
    public val validationCertificateArn: Output<String>?
        get() = javaResource.validationCertificateArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object DomainConfigurationMapper : ResourceMapper<DomainConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iot.DomainConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): DomainConfiguration = DomainConfiguration(
        javaResource
            as com.pulumi.aws.iot.DomainConfiguration,
    )
}

/**
 * @see [DomainConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DomainConfiguration].
 */
public suspend fun domainConfiguration(
    name: String,
    block: suspend DomainConfigurationResourceBuilder.() -> Unit,
): DomainConfiguration {
    val builder = DomainConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DomainConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domainConfiguration(name: String): DomainConfiguration {
    val builder = DomainConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
