@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.EventConfigurationsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages IoT event configurations.
 * > **NOTE:** Deleting this resource does not disable the event configurations, the resource in simply removed from state instead.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.iot.EventConfigurations("example", {eventConfigurations: {
 *     THING: true,
 *     THING_GROUP: false,
 *     THING_TYPE: false,
 *     THING_GROUP_MEMBERSHIP: false,
 *     THING_GROUP_HIERARCHY: false,
 *     THING_TYPE_ASSOCIATION: false,
 *     JOB: false,
 *     JOB_EXECUTION: false,
 *     POLICY: false,
 *     CERTIFICATE: true,
 *     CA_CERTIFICATE: false,
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.iot.EventConfigurations("example", event_configurations={
 *     "THING": True,
 *     "THING_GROUP": False,
 *     "THING_TYPE": False,
 *     "THING_GROUP_MEMBERSHIP": False,
 *     "THING_GROUP_HIERARCHY": False,
 *     "THING_TYPE_ASSOCIATION": False,
 *     "JOB": False,
 *     "JOB_EXECUTION": False,
 *     "POLICY": False,
 *     "CERTIFICATE": True,
 *     "CA_CERTIFICATE": False,
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Iot.EventConfigurations("example", new()
 *     {
 *         Configurations =
 *         {
 *             { "THING", true },
 *             { "THING_GROUP", false },
 *             { "THING_TYPE", false },
 *             { "THING_GROUP_MEMBERSHIP", false },
 *             { "THING_GROUP_HIERARCHY", false },
 *             { "THING_TYPE_ASSOCIATION", false },
 *             { "JOB", false },
 *             { "JOB_EXECUTION", false },
 *             { "POLICY", false },
 *             { "CERTIFICATE", true },
 *             { "CA_CERTIFICATE", false },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iot.NewEventConfigurations(ctx, "example", &iot.EventConfigurationsArgs{
 * 			EventConfigurations: pulumi.BoolMap{
 * 				"THING":                  pulumi.Bool(true),
 * 				"THING_GROUP":            pulumi.Bool(false),
 * 				"THING_TYPE":             pulumi.Bool(false),
 * 				"THING_GROUP_MEMBERSHIP": pulumi.Bool(false),
 * 				"THING_GROUP_HIERARCHY":  pulumi.Bool(false),
 * 				"THING_TYPE_ASSOCIATION": pulumi.Bool(false),
 * 				"JOB":                    pulumi.Bool(false),
 * 				"JOB_EXECUTION":          pulumi.Bool(false),
 * 				"POLICY":                 pulumi.Bool(false),
 * 				"CERTIFICATE":            pulumi.Bool(true),
 * 				"CA_CERTIFICATE":         pulumi.Bool(false),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.EventConfigurations;
 * import com.pulumi.aws.iot.EventConfigurationsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventConfigurations("example", EventConfigurationsArgs.builder()
 *             .eventConfigurations(Map.ofEntries(
 *                 Map.entry("THING", true),
 *                 Map.entry("THING_GROUP", false),
 *                 Map.entry("THING_TYPE", false),
 *                 Map.entry("THING_GROUP_MEMBERSHIP", false),
 *                 Map.entry("THING_GROUP_HIERARCHY", false),
 *                 Map.entry("THING_TYPE_ASSOCIATION", false),
 *                 Map.entry("JOB", false),
 *                 Map.entry("JOB_EXECUTION", false),
 *                 Map.entry("POLICY", false),
 *                 Map.entry("CERTIFICATE", true),
 *                 Map.entry("CA_CERTIFICATE", false)
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iot:EventConfigurations
 *     properties:
 *       eventConfigurations:
 *         THING: true
 *         THING_GROUP: false
 *         THING_TYPE: false
 *         THING_GROUP_MEMBERSHIP: false
 *         THING_GROUP_HIERARCHY: false
 *         THING_TYPE_ASSOCIATION: false
 *         JOB: false
 *         JOB_EXECUTION: false
 *         POLICY: false
 *         CERTIFICATE: true
 *         CA_CERTIFICATE: false
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IoT Event Configurations using the AWS Region. For example:
 * ```sh
 * $ pulumi import aws:iot/eventConfigurations:EventConfigurations example us-west-2
 * ```
 * @property eventConfigurations Map. The new event configuration values. You can use only these strings as keys: `THING_GROUP_HIERARCHY`, `THING_GROUP_MEMBERSHIP`, `THING_TYPE`, `THING_TYPE_ASSOCIATION`, `THING_GROUP`, `THING`, `POLICY`, `CA_CERTIFICATE`, `JOB_EXECUTION`, `CERTIFICATE`, `JOB`. Use boolean for values of mapping.
 */
public data class EventConfigurationsArgs(
    public val eventConfigurations: Output<Map<String, Boolean>>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.EventConfigurationsArgs> {
    override fun toJava(): com.pulumi.aws.iot.EventConfigurationsArgs =
        com.pulumi.aws.iot.EventConfigurationsArgs.builder()
            .eventConfigurations(
                eventConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EventConfigurationsArgs].
 */
@PulumiTagMarker
public class EventConfigurationsArgsBuilder internal constructor() {
    private var eventConfigurations: Output<Map<String, Boolean>>? = null

    /**
     * @param value Map. The new event configuration values. You can use only these strings as keys: `THING_GROUP_HIERARCHY`, `THING_GROUP_MEMBERSHIP`, `THING_TYPE`, `THING_TYPE_ASSOCIATION`, `THING_GROUP`, `THING`, `POLICY`, `CA_CERTIFICATE`, `JOB_EXECUTION`, `CERTIFICATE`, `JOB`. Use boolean for values of mapping.
     */
    @JvmName("joiteogxpqsssjeu")
    public suspend fun eventConfigurations(`value`: Output<Map<String, Boolean>>) {
        this.eventConfigurations = value
    }

    /**
     * @param value Map. The new event configuration values. You can use only these strings as keys: `THING_GROUP_HIERARCHY`, `THING_GROUP_MEMBERSHIP`, `THING_TYPE`, `THING_TYPE_ASSOCIATION`, `THING_GROUP`, `THING`, `POLICY`, `CA_CERTIFICATE`, `JOB_EXECUTION`, `CERTIFICATE`, `JOB`. Use boolean for values of mapping.
     */
    @JvmName("coxmccehlwgtiwgf")
    public suspend fun eventConfigurations(`value`: Map<String, Boolean>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventConfigurations = mapped
    }

    /**
     * @param values Map. The new event configuration values. You can use only these strings as keys: `THING_GROUP_HIERARCHY`, `THING_GROUP_MEMBERSHIP`, `THING_TYPE`, `THING_TYPE_ASSOCIATION`, `THING_GROUP`, `THING`, `POLICY`, `CA_CERTIFICATE`, `JOB_EXECUTION`, `CERTIFICATE`, `JOB`. Use boolean for values of mapping.
     */
    @JvmName("sofflprkhrjmjdsj")
    public fun eventConfigurations(vararg values: Pair<String, Boolean>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventConfigurations = mapped
    }

    internal fun build(): EventConfigurationsArgs = EventConfigurationsArgs(
        eventConfigurations = eventConfigurations,
    )
}
