@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.kotlin.outputs.IndexingConfigurationThingGroupIndexingConfiguration
import com.pulumi.aws.iot.kotlin.outputs.IndexingConfigurationThingIndexingConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.iot.kotlin.outputs.IndexingConfigurationThingGroupIndexingConfiguration.Companion.toKotlin as indexingConfigurationThingGroupIndexingConfigurationToKotlin
import com.pulumi.aws.iot.kotlin.outputs.IndexingConfigurationThingIndexingConfiguration.Companion.toKotlin as indexingConfigurationThingIndexingConfigurationToKotlin

/**
 * Builder for [IndexingConfiguration].
 */
@PulumiTagMarker
public class IndexingConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IndexingConfigurationArgs = IndexingConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IndexingConfigurationArgsBuilder.() -> Unit) {
        val builder = IndexingConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IndexingConfiguration {
        val builtJavaResource = com.pulumi.aws.iot.IndexingConfiguration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IndexingConfiguration(builtJavaResource)
    }
}

/**
 * Managing [IoT Thing indexing](https://docs.aws.amazon.com/iot/latest/developerguide/managing-index.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.iot.IndexingConfiguration("example", {thingIndexingConfiguration: {
 *     thingIndexingMode: "REGISTRY_AND_SHADOW",
 *     thingConnectivityIndexingMode: "STATUS",
 *     deviceDefenderIndexingMode: "VIOLATIONS",
 *     namedShadowIndexingMode: "ON",
 *     filter: {
 *         namedShadowNames: ["thing1shadow"],
 *     },
 *     customFields: [
 *         {
 *             name: "shadow.desired.power",
 *             type: "Boolean",
 *         },
 *         {
 *             name: "attributes.version",
 *             type: "Number",
 *         },
 *         {
 *             name: "shadow.name.thing1shadow.desired.DefaultDesired",
 *             type: "String",
 *         },
 *         {
 *             name: "deviceDefender.securityProfile1.NUMBER_VALUE_BEHAVIOR.lastViolationValue.number",
 *             type: "Number",
 *         },
 *     ],
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.iot.IndexingConfiguration("example", thing_indexing_configuration={
 *     "thing_indexing_mode": "REGISTRY_AND_SHADOW",
 *     "thing_connectivity_indexing_mode": "STATUS",
 *     "device_defender_indexing_mode": "VIOLATIONS",
 *     "named_shadow_indexing_mode": "ON",
 *     "filter": {
 *         "named_shadow_names": ["thing1shadow"],
 *     },
 *     "custom_fields": [
 *         {
 *             "name": "shadow.desired.power",
 *             "type": "Boolean",
 *         },
 *         {
 *             "name": "attributes.version",
 *             "type": "Number",
 *         },
 *         {
 *             "name": "shadow.name.thing1shadow.desired.DefaultDesired",
 *             "type": "String",
 *         },
 *         {
 *             "name": "deviceDefender.securityProfile1.NUMBER_VALUE_BEHAVIOR.lastViolationValue.number",
 *             "type": "Number",
 *         },
 *     ],
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Iot.IndexingConfiguration("example", new()
 *     {
 *         ThingIndexingConfiguration = new Aws.Iot.Inputs.IndexingConfigurationThingIndexingConfigurationArgs
 *         {
 *             ThingIndexingMode = "REGISTRY_AND_SHADOW",
 *             ThingConnectivityIndexingMode = "STATUS",
 *             DeviceDefenderIndexingMode = "VIOLATIONS",
 *             NamedShadowIndexingMode = "ON",
 *             Filter = new Aws.Iot.Inputs.IndexingConfigurationThingIndexingConfigurationFilterArgs
 *             {
 *                 NamedShadowNames = new[]
 *                 {
 *                     "thing1shadow",
 *                 },
 *             },
 *             CustomFields = new[]
 *             {
 *                 new Aws.Iot.Inputs.IndexingConfigurationThingIndexingConfigurationCustomFieldArgs
 *                 {
 *                     Name = "shadow.desired.power",
 *                     Type = "Boolean",
 *                 },
 *                 new Aws.Iot.Inputs.IndexingConfigurationThingIndexingConfigurationCustomFieldArgs
 *                 {
 *                     Name = "attributes.version",
 *                     Type = "Number",
 *                 },
 *                 new Aws.Iot.Inputs.IndexingConfigurationThingIndexingConfigurationCustomFieldArgs
 *                 {
 *                     Name = "shadow.name.thing1shadow.desired.DefaultDesired",
 *                     Type = "String",
 *                 },
 *                 new Aws.Iot.Inputs.IndexingConfigurationThingIndexingConfigurationCustomFieldArgs
 *                 {
 *                     Name = "deviceDefender.securityProfile1.NUMBER_VALUE_BEHAVIOR.lastViolationValue.number",
 *                     Type = "Number",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iot.NewIndexingConfiguration(ctx, "example", &iot.IndexingConfigurationArgs{
 * 			ThingIndexingConfiguration: &iot.IndexingConfigurationThingIndexingConfigurationArgs{
 * 				ThingIndexingMode:             pulumi.String("REGISTRY_AND_SHADOW"),
 * 				ThingConnectivityIndexingMode: pulumi.String("STATUS"),
 * 				DeviceDefenderIndexingMode:    pulumi.String("VIOLATIONS"),
 * 				NamedShadowIndexingMode:       pulumi.String("ON"),
 * 				Filter: &iot.IndexingConfigurationThingIndexingConfigurationFilterArgs{
 * 					NamedShadowNames: pulumi.StringArray{
 * 						pulumi.String("thing1shadow"),
 * 					},
 * 				},
 * 				CustomFields: iot.IndexingConfigurationThingIndexingConfigurationCustomFieldArray{
 * 					&iot.IndexingConfigurationThingIndexingConfigurationCustomFieldArgs{
 * 						Name: pulumi.String("shadow.desired.power"),
 * 						Type: pulumi.String("Boolean"),
 * 					},
 * 					&iot.IndexingConfigurationThingIndexingConfigurationCustomFieldArgs{
 * 						Name: pulumi.String("attributes.version"),
 * 						Type: pulumi.String("Number"),
 * 					},
 * 					&iot.IndexingConfigurationThingIndexingConfigurationCustomFieldArgs{
 * 						Name: pulumi.String("shadow.name.thing1shadow.desired.DefaultDesired"),
 * 						Type: pulumi.String("String"),
 * 					},
 * 					&iot.IndexingConfigurationThingIndexingConfigurationCustomFieldArgs{
 * 						Name: pulumi.String("deviceDefender.securityProfile1.NUMBER_VALUE_BEHAVIOR.lastViolationValue.number"),
 * 						Type: pulumi.String("Number"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.IndexingConfiguration;
 * import com.pulumi.aws.iot.IndexingConfigurationArgs;
 * import com.pulumi.aws.iot.inputs.IndexingConfigurationThingIndexingConfigurationArgs;
 * import com.pulumi.aws.iot.inputs.IndexingConfigurationThingIndexingConfigurationFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new IndexingConfiguration("example", IndexingConfigurationArgs.builder()
 *             .thingIndexingConfiguration(IndexingConfigurationThingIndexingConfigurationArgs.builder()
 *                 .thingIndexingMode("REGISTRY_AND_SHADOW")
 *                 .thingConnectivityIndexingMode("STATUS")
 *                 .deviceDefenderIndexingMode("VIOLATIONS")
 *                 .namedShadowIndexingMode("ON")
 *                 .filter(IndexingConfigurationThingIndexingConfigurationFilterArgs.builder()
 *                     .namedShadowNames("thing1shadow")
 *                     .build())
 *                 .customFields(
 *                     IndexingConfigurationThingIndexingConfigurationCustomFieldArgs.builder()
 *                         .name("shadow.desired.power")
 *                         .type("Boolean")
 *                         .build(),
 *                     IndexingConfigurationThingIndexingConfigurationCustomFieldArgs.builder()
 *                         .name("attributes.version")
 *                         .type("Number")
 *                         .build(),
 *                     IndexingConfigurationThingIndexingConfigurationCustomFieldArgs.builder()
 *                         .name("shadow.name.thing1shadow.desired.DefaultDesired")
 *                         .type("String")
 *                         .build(),
 *                     IndexingConfigurationThingIndexingConfigurationCustomFieldArgs.builder()
 *                         .name("deviceDefender.securityProfile1.NUMBER_VALUE_BEHAVIOR.lastViolationValue.number")
 *                         .type("Number")
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iot:IndexingConfiguration
 *     properties:
 *       thingIndexingConfiguration:
 *         thingIndexingMode: REGISTRY_AND_SHADOW
 *         thingConnectivityIndexingMode: STATUS
 *         deviceDefenderIndexingMode: VIOLATIONS
 *         namedShadowIndexingMode: ON
 *         filter:
 *           namedShadowNames:
 *             - thing1shadow
 *         customFields:
 *           - name: shadow.desired.power
 *             type: Boolean
 *           - name: attributes.version
 *             type: Number
 *           - name: shadow.name.thing1shadow.desired.DefaultDesired
 *             type: String
 *           - name: deviceDefender.securityProfile1.NUMBER_VALUE_BEHAVIOR.lastViolationValue.number
 *             type: Number
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class IndexingConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.iot.IndexingConfiguration,
) : KotlinCustomResource(javaResource, IndexingConfigurationMapper) {
    /**
     * Thing group indexing configuration. See below.
     */
    public val thingGroupIndexingConfiguration:
        Output<IndexingConfigurationThingGroupIndexingConfiguration>
        get() = javaResource.thingGroupIndexingConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                indexingConfigurationThingGroupIndexingConfigurationToKotlin(args0)
            })
        })

    /**
     * Thing indexing configuration. See below.
     */
    public val thingIndexingConfiguration: Output<IndexingConfigurationThingIndexingConfiguration>
        get() = javaResource.thingIndexingConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                indexingConfigurationThingIndexingConfigurationToKotlin(args0)
            })
        })
}

public object IndexingConfigurationMapper : ResourceMapper<IndexingConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iot.IndexingConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): IndexingConfiguration =
        IndexingConfiguration(javaResource as com.pulumi.aws.iot.IndexingConfiguration)
}

/**
 * @see [IndexingConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IndexingConfiguration].
 */
public suspend fun indexingConfiguration(
    name: String,
    block: suspend IndexingConfigurationResourceBuilder.() -> Unit,
): IndexingConfiguration {
    val builder = IndexingConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IndexingConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun indexingConfiguration(name: String): IndexingConfiguration {
    val builder = IndexingConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
