@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.IndexingConfigurationArgs.builder
import com.pulumi.aws.iot.kotlin.inputs.IndexingConfigurationThingGroupIndexingConfigurationArgs
import com.pulumi.aws.iot.kotlin.inputs.IndexingConfigurationThingGroupIndexingConfigurationArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.IndexingConfigurationThingIndexingConfigurationArgs
import com.pulumi.aws.iot.kotlin.inputs.IndexingConfigurationThingIndexingConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Managing [IoT Thing indexing](https://docs.aws.amazon.com/iot/latest/developerguide/managing-index.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.iot.IndexingConfiguration("example", {thingIndexingConfiguration: {
 *     thingIndexingMode: "REGISTRY_AND_SHADOW",
 *     thingConnectivityIndexingMode: "STATUS",
 *     deviceDefenderIndexingMode: "VIOLATIONS",
 *     namedShadowIndexingMode: "ON",
 *     filter: {
 *         namedShadowNames: ["thing1shadow"],
 *     },
 *     customFields: [
 *         {
 *             name: "shadow.desired.power",
 *             type: "Boolean",
 *         },
 *         {
 *             name: "attributes.version",
 *             type: "Number",
 *         },
 *         {
 *             name: "shadow.name.thing1shadow.desired.DefaultDesired",
 *             type: "String",
 *         },
 *         {
 *             name: "deviceDefender.securityProfile1.NUMBER_VALUE_BEHAVIOR.lastViolationValue.number",
 *             type: "Number",
 *         },
 *     ],
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.iot.IndexingConfiguration("example", thing_indexing_configuration={
 *     "thing_indexing_mode": "REGISTRY_AND_SHADOW",
 *     "thing_connectivity_indexing_mode": "STATUS",
 *     "device_defender_indexing_mode": "VIOLATIONS",
 *     "named_shadow_indexing_mode": "ON",
 *     "filter": {
 *         "named_shadow_names": ["thing1shadow"],
 *     },
 *     "custom_fields": [
 *         {
 *             "name": "shadow.desired.power",
 *             "type": "Boolean",
 *         },
 *         {
 *             "name": "attributes.version",
 *             "type": "Number",
 *         },
 *         {
 *             "name": "shadow.name.thing1shadow.desired.DefaultDesired",
 *             "type": "String",
 *         },
 *         {
 *             "name": "deviceDefender.securityProfile1.NUMBER_VALUE_BEHAVIOR.lastViolationValue.number",
 *             "type": "Number",
 *         },
 *     ],
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Iot.IndexingConfiguration("example", new()
 *     {
 *         ThingIndexingConfiguration = new Aws.Iot.Inputs.IndexingConfigurationThingIndexingConfigurationArgs
 *         {
 *             ThingIndexingMode = "REGISTRY_AND_SHADOW",
 *             ThingConnectivityIndexingMode = "STATUS",
 *             DeviceDefenderIndexingMode = "VIOLATIONS",
 *             NamedShadowIndexingMode = "ON",
 *             Filter = new Aws.Iot.Inputs.IndexingConfigurationThingIndexingConfigurationFilterArgs
 *             {
 *                 NamedShadowNames = new[]
 *                 {
 *                     "thing1shadow",
 *                 },
 *             },
 *             CustomFields = new[]
 *             {
 *                 new Aws.Iot.Inputs.IndexingConfigurationThingIndexingConfigurationCustomFieldArgs
 *                 {
 *                     Name = "shadow.desired.power",
 *                     Type = "Boolean",
 *                 },
 *                 new Aws.Iot.Inputs.IndexingConfigurationThingIndexingConfigurationCustomFieldArgs
 *                 {
 *                     Name = "attributes.version",
 *                     Type = "Number",
 *                 },
 *                 new Aws.Iot.Inputs.IndexingConfigurationThingIndexingConfigurationCustomFieldArgs
 *                 {
 *                     Name = "shadow.name.thing1shadow.desired.DefaultDesired",
 *                     Type = "String",
 *                 },
 *                 new Aws.Iot.Inputs.IndexingConfigurationThingIndexingConfigurationCustomFieldArgs
 *                 {
 *                     Name = "deviceDefender.securityProfile1.NUMBER_VALUE_BEHAVIOR.lastViolationValue.number",
 *                     Type = "Number",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iot.NewIndexingConfiguration(ctx, "example", &iot.IndexingConfigurationArgs{
 * 			ThingIndexingConfiguration: &iot.IndexingConfigurationThingIndexingConfigurationArgs{
 * 				ThingIndexingMode:             pulumi.String("REGISTRY_AND_SHADOW"),
 * 				ThingConnectivityIndexingMode: pulumi.String("STATUS"),
 * 				DeviceDefenderIndexingMode:    pulumi.String("VIOLATIONS"),
 * 				NamedShadowIndexingMode:       pulumi.String("ON"),
 * 				Filter: &iot.IndexingConfigurationThingIndexingConfigurationFilterArgs{
 * 					NamedShadowNames: pulumi.StringArray{
 * 						pulumi.String("thing1shadow"),
 * 					},
 * 				},
 * 				CustomFields: iot.IndexingConfigurationThingIndexingConfigurationCustomFieldArray{
 * 					&iot.IndexingConfigurationThingIndexingConfigurationCustomFieldArgs{
 * 						Name: pulumi.String("shadow.desired.power"),
 * 						Type: pulumi.String("Boolean"),
 * 					},
 * 					&iot.IndexingConfigurationThingIndexingConfigurationCustomFieldArgs{
 * 						Name: pulumi.String("attributes.version"),
 * 						Type: pulumi.String("Number"),
 * 					},
 * 					&iot.IndexingConfigurationThingIndexingConfigurationCustomFieldArgs{
 * 						Name: pulumi.String("shadow.name.thing1shadow.desired.DefaultDesired"),
 * 						Type: pulumi.String("String"),
 * 					},
 * 					&iot.IndexingConfigurationThingIndexingConfigurationCustomFieldArgs{
 * 						Name: pulumi.String("deviceDefender.securityProfile1.NUMBER_VALUE_BEHAVIOR.lastViolationValue.number"),
 * 						Type: pulumi.String("Number"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.IndexingConfiguration;
 * import com.pulumi.aws.iot.IndexingConfigurationArgs;
 * import com.pulumi.aws.iot.inputs.IndexingConfigurationThingIndexingConfigurationArgs;
 * import com.pulumi.aws.iot.inputs.IndexingConfigurationThingIndexingConfigurationFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new IndexingConfiguration("example", IndexingConfigurationArgs.builder()
 *             .thingIndexingConfiguration(IndexingConfigurationThingIndexingConfigurationArgs.builder()
 *                 .thingIndexingMode("REGISTRY_AND_SHADOW")
 *                 .thingConnectivityIndexingMode("STATUS")
 *                 .deviceDefenderIndexingMode("VIOLATIONS")
 *                 .namedShadowIndexingMode("ON")
 *                 .filter(IndexingConfigurationThingIndexingConfigurationFilterArgs.builder()
 *                     .namedShadowNames("thing1shadow")
 *                     .build())
 *                 .customFields(
 *                     IndexingConfigurationThingIndexingConfigurationCustomFieldArgs.builder()
 *                         .name("shadow.desired.power")
 *                         .type("Boolean")
 *                         .build(),
 *                     IndexingConfigurationThingIndexingConfigurationCustomFieldArgs.builder()
 *                         .name("attributes.version")
 *                         .type("Number")
 *                         .build(),
 *                     IndexingConfigurationThingIndexingConfigurationCustomFieldArgs.builder()
 *                         .name("shadow.name.thing1shadow.desired.DefaultDesired")
 *                         .type("String")
 *                         .build(),
 *                     IndexingConfigurationThingIndexingConfigurationCustomFieldArgs.builder()
 *                         .name("deviceDefender.securityProfile1.NUMBER_VALUE_BEHAVIOR.lastViolationValue.number")
 *                         .type("Number")
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iot:IndexingConfiguration
 *     properties:
 *       thingIndexingConfiguration:
 *         thingIndexingMode: REGISTRY_AND_SHADOW
 *         thingConnectivityIndexingMode: STATUS
 *         deviceDefenderIndexingMode: VIOLATIONS
 *         namedShadowIndexingMode: ON
 *         filter:
 *           namedShadowNames:
 *             - thing1shadow
 *         customFields:
 *           - name: shadow.desired.power
 *             type: Boolean
 *           - name: attributes.version
 *             type: Number
 *           - name: shadow.name.thing1shadow.desired.DefaultDesired
 *             type: String
 *           - name: deviceDefender.securityProfile1.NUMBER_VALUE_BEHAVIOR.lastViolationValue.number
 *             type: Number
 * ```
 * <!--End PulumiCodeChooser -->
 * @property thingGroupIndexingConfiguration Thing group indexing configuration. See below.
 * @property thingIndexingConfiguration Thing indexing configuration. See below.
 */
public data class IndexingConfigurationArgs(
    public val thingGroupIndexingConfiguration: Output<IndexingConfigurationThingGroupIndexingConfigurationArgs>? = null,
    public val thingIndexingConfiguration: Output<IndexingConfigurationThingIndexingConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.IndexingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.iot.IndexingConfigurationArgs =
        com.pulumi.aws.iot.IndexingConfigurationArgs.builder()
            .thingGroupIndexingConfiguration(
                thingGroupIndexingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .thingIndexingConfiguration(
                thingIndexingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [IndexingConfigurationArgs].
 */
@PulumiTagMarker
public class IndexingConfigurationArgsBuilder internal constructor() {
    private var thingGroupIndexingConfiguration:
        Output<IndexingConfigurationThingGroupIndexingConfigurationArgs>? = null

    private var thingIndexingConfiguration:
        Output<IndexingConfigurationThingIndexingConfigurationArgs>? = null

    /**
     * @param value Thing group indexing configuration. See below.
     */
    @JvmName("apbhyndmhianycwp")
    public suspend fun thingGroupIndexingConfiguration(`value`: Output<IndexingConfigurationThingGroupIndexingConfigurationArgs>) {
        this.thingGroupIndexingConfiguration = value
    }

    /**
     * @param value Thing indexing configuration. See below.
     */
    @JvmName("tkefguvppxqhdhss")
    public suspend fun thingIndexingConfiguration(`value`: Output<IndexingConfigurationThingIndexingConfigurationArgs>) {
        this.thingIndexingConfiguration = value
    }

    /**
     * @param value Thing group indexing configuration. See below.
     */
    @JvmName("jnnylxhyiatsrgak")
    public suspend fun thingGroupIndexingConfiguration(`value`: IndexingConfigurationThingGroupIndexingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thingGroupIndexingConfiguration = mapped
    }

    /**
     * @param argument Thing group indexing configuration. See below.
     */
    @JvmName("gjnyhclasnukokol")
    public suspend fun thingGroupIndexingConfiguration(argument: suspend IndexingConfigurationThingGroupIndexingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = IndexingConfigurationThingGroupIndexingConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.thingGroupIndexingConfiguration = mapped
    }

    /**
     * @param value Thing indexing configuration. See below.
     */
    @JvmName("wmqlbmgivxnbqkcy")
    public suspend fun thingIndexingConfiguration(`value`: IndexingConfigurationThingIndexingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thingIndexingConfiguration = mapped
    }

    /**
     * @param argument Thing indexing configuration. See below.
     */
    @JvmName("pmfbfoopmseebtff")
    public suspend fun thingIndexingConfiguration(argument: suspend IndexingConfigurationThingIndexingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = IndexingConfigurationThingIndexingConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.thingIndexingConfiguration = mapped
    }

    internal fun build(): IndexingConfigurationArgs = IndexingConfigurationArgs(
        thingGroupIndexingConfiguration = thingGroupIndexingConfiguration,
        thingIndexingConfiguration = thingIndexingConfiguration,
    )
}
