@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.IotFunctions.getEndpointPlain
import com.pulumi.aws.iot.IotFunctions.getRegistrationCodePlain
import com.pulumi.aws.iot.kotlin.inputs.GetEndpointPlainArgs
import com.pulumi.aws.iot.kotlin.inputs.GetEndpointPlainArgsBuilder
import com.pulumi.aws.iot.kotlin.outputs.GetEndpointResult
import com.pulumi.aws.iot.kotlin.outputs.GetRegistrationCodeResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.iot.kotlin.outputs.GetEndpointResult.Companion.toKotlin as getEndpointResultToKotlin
import com.pulumi.aws.iot.kotlin.outputs.GetRegistrationCodeResult.Companion.toKotlin as getRegistrationCodeResultToKotlin

public object IotFunctions {
    /**
     * Returns a unique endpoint specific to the AWS account making the call.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iot.IotFunctions;
     * import com.pulumi.aws.iot.inputs.GetEndpointArgs;
     * import com.pulumi.kubernetes.core_v1.Pod;
     * import com.pulumi.kubernetes.core_v1.PodArgs;
     * import com.pulumi.kubernetes.meta_v1.inputs.ObjectMetaArgs;
     * import com.pulumi.kubernetes.core_v1.inputs.PodSpecArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IotFunctions.getEndpoint();
     *         var agent = new Pod("agent", PodArgs.builder()
     *             .metadata(ObjectMetaArgs.builder()
     *                 .name("my-device")
     *                 .build())
     *             .spec(PodSpecArgs.builder()
     *                 .container(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   agent:
     *     type: kubernetes:core/v1:Pod
     *     properties:
     *       metadata:
     *         name: my-device
     *       spec:
     *         container:
     *           - image: gcr.io/my-project/image-name
     *             name: image-name
     *             env:
     *               - name: IOT_ENDPOINT
     *                 value: ${example.endpointAddress}
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:iot:getEndpoint
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEndpoint.
     * @return A collection of values returned by getEndpoint.
     */
    public suspend fun getEndpoint(argument: GetEndpointPlainArgs): GetEndpointResult =
        getEndpointResultToKotlin(getEndpointPlain(argument.toJava()).await())

    /**
     * @see [getEndpoint].
     * @param endpointType Endpoint type. Valid values: `iot:CredentialProvider`, `iot:Data`, `iot:Data-ATS`, `iot:Jobs`.
     * @return A collection of values returned by getEndpoint.
     */
    public suspend fun getEndpoint(endpointType: String? = null): GetEndpointResult {
        val argument = GetEndpointPlainArgs(
            endpointType = endpointType,
        )
        return getEndpointResultToKotlin(getEndpointPlain(argument.toJava()).await())
    }

    /**
     * @see [getEndpoint].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iot&#46;kotlin&#46;inputs&#46;GetEndpointPlainArgs].
     * @return A collection of values returned by getEndpoint.
     */
    public suspend fun getEndpoint(argument: suspend GetEndpointPlainArgsBuilder.() -> Unit): GetEndpointResult {
        val builder = GetEndpointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEndpointResultToKotlin(getEndpointPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a registration code used to register a CA certificate with AWS IoT.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * import * as tls from "@pulumi/tls";
     * const example = aws.iot.getRegistrationCode({});
     * const verification = new tls.PrivateKey("verification", {algorithm: "RSA"});
     * const verificationCertRequest = new tls.CertRequest("verification", {
     *     keyAlgorithm: "RSA",
     *     privateKeyPem: verification.privateKeyPem,
     *     subject: {
     *         commonName: example.then(example => example.registrationCode),
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * import pulumi_tls as tls
     * example = aws.iot.get_registration_code()
     * verification = tls.PrivateKey("verification", algorithm="RSA")
     * verification_cert_request = tls.CertRequest("verification",
     *     key_algorithm="RSA",
     *     private_key_pem=verification.private_key_pem,
     *     subject={
     *         "common_name": example.registration_code,
     *     })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * using Tls = Pulumi.Tls;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Iot.GetRegistrationCode.Invoke();
     *     var verification = new Tls.PrivateKey("verification", new()
     *     {
     *         Algorithm = "RSA",
     *     });
     *     var verificationCertRequest = new Tls.CertRequest("verification", new()
     *     {
     *         KeyAlgorithm = "RSA",
     *         PrivateKeyPem = verification.PrivateKeyPem,
     *         Subject = new Tls.Inputs.CertRequestSubjectArgs
     *         {
     *             CommonName = example.Apply(getRegistrationCodeResult => getRegistrationCodeResult.RegistrationCode),
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
     * 	"github.com/pulumi/pulumi-tls/sdk/v4/go/tls"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := iot.GetRegistrationCode(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		verification, err := tls.NewPrivateKey(ctx, "verification", &tls.PrivateKeyArgs{
     * 			Algorithm: pulumi.String("RSA"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = tls.NewCertRequest(ctx, "verification", &tls.CertRequestArgs{
     * 			KeyAlgorithm:  pulumi.String("RSA"),
     * 			PrivateKeyPem: verification.PrivateKeyPem,
     * 			Subject: &tls.CertRequestSubjectArgs{
     * 				CommonName: pulumi.String(example.RegistrationCode),
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iot.IotFunctions;
     * import com.pulumi.tls.PrivateKey;
     * import com.pulumi.tls.PrivateKeyArgs;
     * import com.pulumi.tls.CertRequest;
     * import com.pulumi.tls.CertRequestArgs;
     * import com.pulumi.tls.inputs.CertRequestSubjectArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IotFunctions.getRegistrationCode();
     *         var verification = new PrivateKey("verification", PrivateKeyArgs.builder()
     *             .algorithm("RSA")
     *             .build());
     *         var verificationCertRequest = new CertRequest("verificationCertRequest", CertRequestArgs.builder()
     *             .keyAlgorithm("RSA")
     *             .privateKeyPem(verification.privateKeyPem())
     *             .subject(CertRequestSubjectArgs.builder()
     *                 .commonName(example.applyValue(getRegistrationCodeResult -> getRegistrationCodeResult.registrationCode()))
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   verification:
     *     type: tls:PrivateKey
     *     properties:
     *       algorithm: RSA
     *   verificationCertRequest:
     *     type: tls:CertRequest
     *     name: verification
     *     properties:
     *       keyAlgorithm: RSA
     *       privateKeyPem: ${verification.privateKeyPem}
     *       subject:
     *         commonName: ${example.registrationCode}
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:iot:getRegistrationCode
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument Gets a registration code used to register a CA certificate with AWS IoT.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * import * as tls from "@pulumi/tls";
     * const example = aws.iot.getRegistrationCode({});
     * const verification = new tls.PrivateKey("verification", {algorithm: "RSA"});
     * const verificationCertRequest = new tls.CertRequest("verification", {
     *     keyAlgorithm: "RSA",
     *     privateKeyPem: verification.privateKeyPem,
     *     subject: {
     *         commonName: example.then(example => example.registrationCode),
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * import pulumi_tls as tls
     * example = aws.iot.get_registration_code()
     * verification = tls.PrivateKey("verification", algorithm="RSA")
     * verification_cert_request = tls.CertRequest("verification",
     *     key_algorithm="RSA",
     *     private_key_pem=verification.private_key_pem,
     *     subject={
     *         "common_name": example.registration_code,
     *     })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * using Tls = Pulumi.Tls;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Iot.GetRegistrationCode.Invoke();
     *     var verification = new Tls.PrivateKey("verification", new()
     *     {
     *         Algorithm = "RSA",
     *     });
     *     var verificationCertRequest = new Tls.CertRequest("verification", new()
     *     {
     *         KeyAlgorithm = "RSA",
     *         PrivateKeyPem = verification.PrivateKeyPem,
     *         Subject = new Tls.Inputs.CertRequestSubjectArgs
     *         {
     *             CommonName = example.Apply(getRegistrationCodeResult => getRegistrationCodeResult.RegistrationCode),
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
     * 	"github.com/pulumi/pulumi-tls/sdk/v4/go/tls"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := iot.GetRegistrationCode(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		verification, err := tls.NewPrivateKey(ctx, "verification", &tls.PrivateKeyArgs{
     * 			Algorithm: pulumi.String("RSA"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = tls.NewCertRequest(ctx, "verification", &tls.CertRequestArgs{
     * 			KeyAlgorithm:  pulumi.String("RSA"),
     * 			PrivateKeyPem: verification.PrivateKeyPem,
     * 			Subject: &tls.CertRequestSubjectArgs{
     * 				CommonName: pulumi.String(example.RegistrationCode),
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iot.IotFunctions;
     * import com.pulumi.tls.PrivateKey;
     * import com.pulumi.tls.PrivateKeyArgs;
     * import com.pulumi.tls.CertRequest;
     * import com.pulumi.tls.CertRequestArgs;
     * import com.pulumi.tls.inputs.CertRequestSubjectArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IotFunctions.getRegistrationCode();
     *         var verification = new PrivateKey("verification", PrivateKeyArgs.builder()
     *             .algorithm("RSA")
     *             .build());
     *         var verificationCertRequest = new CertRequest("verificationCertRequest", CertRequestArgs.builder()
     *             .keyAlgorithm("RSA")
     *             .privateKeyPem(verification.privateKeyPem())
     *             .subject(CertRequestSubjectArgs.builder()
     *                 .commonName(example.applyValue(getRegistrationCodeResult -> getRegistrationCodeResult.registrationCode()))
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   verification:
     *     type: tls:PrivateKey
     *     properties:
     *       algorithm: RSA
     *   verificationCertRequest:
     *     type: tls:CertRequest
     *     name: verification
     *     properties:
     *       keyAlgorithm: RSA
     *       privateKeyPem: ${verification.privateKeyPem}
     *       subject:
     *         commonName: ${example.registrationCode}
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:iot:getRegistrationCode
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @return A collection of values returned by getRegistrationCode.
     */
    public suspend fun getRegistrationCode(): GetRegistrationCodeResult =
        getRegistrationCodeResultToKotlin(getRegistrationCodePlain().await())
}
