@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LoggingOptions].
 */
@PulumiTagMarker
public class LoggingOptionsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LoggingOptionsArgs = LoggingOptionsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LoggingOptionsArgsBuilder.() -> Unit) {
        val builder = LoggingOptionsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LoggingOptions {
        val builtJavaResource = com.pulumi.aws.iot.LoggingOptions(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LoggingOptions(builtJavaResource)
    }
}

/**
 * Provides a resource to manage [default logging options](https://docs.aws.amazon.com/iot/latest/developerguide/configure-logging.html#configure-logging-console).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.iot.LoggingOptions("example", {
 *     defaultLogLevel: "WARN",
 *     roleArn: exampleAwsIamRole.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.iot.LoggingOptions("example",
 *     default_log_level="WARN",
 *     role_arn=example_aws_iam_role["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Iot.LoggingOptions("example", new()
 *     {
 *         DefaultLogLevel = "WARN",
 *         RoleArn = exampleAwsIamRole.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iot.NewLoggingOptions(ctx, "example", &iot.LoggingOptionsArgs{
 * 			DefaultLogLevel: pulumi.String("WARN"),
 * 			RoleArn:         pulumi.Any(exampleAwsIamRole.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.LoggingOptions;
 * import com.pulumi.aws.iot.LoggingOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LoggingOptions("example", LoggingOptionsArgs.builder()
 *             .defaultLogLevel("WARN")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iot:LoggingOptions
 *     properties:
 *       defaultLogLevel: WARN
 *       roleArn: ${exampleAwsIamRole.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class LoggingOptions internal constructor(
    override val javaResource: com.pulumi.aws.iot.LoggingOptions,
) : KotlinCustomResource(javaResource, LoggingOptionsMapper) {
    /**
     * The default logging level. Valid Values: `"DEBUG"`, `"INFO"`, `"ERROR"`, `"WARN"`, `"DISABLED"`.
     */
    public val defaultLogLevel: Output<String>
        get() = javaResource.defaultLogLevel().applyValue({ args0 -> args0 })

    /**
     * If `true` all logs are disabled. The default is `false`.
     */
    public val disableAllLogs: Output<Boolean>?
        get() = javaResource.disableAllLogs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the role that allows IoT to write to Cloudwatch logs.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })
}

public object LoggingOptionsMapper : ResourceMapper<LoggingOptions> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iot.LoggingOptions::class == javaResource::class

    override fun map(javaResource: Resource): LoggingOptions = LoggingOptions(
        javaResource as
            com.pulumi.aws.iot.LoggingOptions,
    )
}

/**
 * @see [LoggingOptions].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LoggingOptions].
 */
public suspend fun loggingOptions(
    name: String,
    block: suspend LoggingOptionsResourceBuilder.() -> Unit,
): LoggingOptions {
    val builder = LoggingOptionsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LoggingOptions].
 * @param name The _unique_ name of the resulting resource.
 */
public fun loggingOptions(name: String): LoggingOptions {
    val builder = LoggingOptionsResourceBuilder()
    builder.name(name)
    return builder.build()
}
