@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.LoggingOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage [default logging options](https://docs.aws.amazon.com/iot/latest/developerguide/configure-logging.html#configure-logging-console).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.iot.LoggingOptions("example", {
 *     defaultLogLevel: "WARN",
 *     roleArn: exampleAwsIamRole.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.iot.LoggingOptions("example",
 *     default_log_level="WARN",
 *     role_arn=example_aws_iam_role["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Iot.LoggingOptions("example", new()
 *     {
 *         DefaultLogLevel = "WARN",
 *         RoleArn = exampleAwsIamRole.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iot.NewLoggingOptions(ctx, "example", &iot.LoggingOptionsArgs{
 * 			DefaultLogLevel: pulumi.String("WARN"),
 * 			RoleArn:         pulumi.Any(exampleAwsIamRole.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.LoggingOptions;
 * import com.pulumi.aws.iot.LoggingOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LoggingOptions("example", LoggingOptionsArgs.builder()
 *             .defaultLogLevel("WARN")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iot:LoggingOptions
 *     properties:
 *       defaultLogLevel: WARN
 *       roleArn: ${exampleAwsIamRole.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * @property defaultLogLevel The default logging level. Valid Values: `"DEBUG"`, `"INFO"`, `"ERROR"`, `"WARN"`, `"DISABLED"`.
 * @property disableAllLogs If `true` all logs are disabled. The default is `false`.
 * @property roleArn The ARN of the role that allows IoT to write to Cloudwatch logs.
 */
public data class LoggingOptionsArgs(
    public val defaultLogLevel: Output<String>? = null,
    public val disableAllLogs: Output<Boolean>? = null,
    public val roleArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.LoggingOptionsArgs> {
    override fun toJava(): com.pulumi.aws.iot.LoggingOptionsArgs =
        com.pulumi.aws.iot.LoggingOptionsArgs.builder()
            .defaultLogLevel(defaultLogLevel?.applyValue({ args0 -> args0 }))
            .disableAllLogs(disableAllLogs?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoggingOptionsArgs].
 */
@PulumiTagMarker
public class LoggingOptionsArgsBuilder internal constructor() {
    private var defaultLogLevel: Output<String>? = null

    private var disableAllLogs: Output<Boolean>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value The default logging level. Valid Values: `"DEBUG"`, `"INFO"`, `"ERROR"`, `"WARN"`, `"DISABLED"`.
     */
    @JvmName("rwmsbrlcxcinglbv")
    public suspend fun defaultLogLevel(`value`: Output<String>) {
        this.defaultLogLevel = value
    }

    /**
     * @param value If `true` all logs are disabled. The default is `false`.
     */
    @JvmName("bvlqssvndoasarto")
    public suspend fun disableAllLogs(`value`: Output<Boolean>) {
        this.disableAllLogs = value
    }

    /**
     * @param value The ARN of the role that allows IoT to write to Cloudwatch logs.
     */
    @JvmName("qijoipiqcsnhstdu")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The default logging level. Valid Values: `"DEBUG"`, `"INFO"`, `"ERROR"`, `"WARN"`, `"DISABLED"`.
     */
    @JvmName("unheatbyowbmdiwm")
    public suspend fun defaultLogLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultLogLevel = mapped
    }

    /**
     * @param value If `true` all logs are disabled. The default is `false`.
     */
    @JvmName("oeufcdtakrxmtspb")
    public suspend fun disableAllLogs(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableAllLogs = mapped
    }

    /**
     * @param value The ARN of the role that allows IoT to write to Cloudwatch logs.
     */
    @JvmName("wxkvxawktjidkguq")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): LoggingOptionsArgs = LoggingOptionsArgs(
        defaultLogLevel = defaultLogLevel,
        disableAllLogs = disableAllLogs,
        roleArn = roleArn,
    )
}
