@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PolicyAttachment].
 */
@PulumiTagMarker
public class PolicyAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyAttachmentArgs = PolicyAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyAttachmentArgsBuilder.() -> Unit) {
        val builder = PolicyAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PolicyAttachment {
        val builtJavaResource = com.pulumi.aws.iot.PolicyAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PolicyAttachment(builtJavaResource)
    }
}

/**
 * Provides an IoT policy attachment.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const pubsub = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         actions: ["iot:*"],
 *         resources: ["*"],
 *     }],
 * });
 * const pubsubPolicy = new aws.iot.Policy("pubsub", {
 *     name: "PubSubToAnyTopic",
 *     policy: pubsub.then(pubsub => pubsub.json),
 * });
 * const cert = new aws.iot.Certificate("cert", {
 *     csr: std.file({
 *         input: "csr.pem",
 *     }).then(invoke => invoke.result),
 *     active: true,
 * });
 * const att = new aws.iot.PolicyAttachment("att", {
 *     policy: pubsubPolicy.name,
 *     target: cert.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * pubsub = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "actions": ["iot:*"],
 *     "resources": ["*"],
 * }])
 * pubsub_policy = aws.iot.Policy("pubsub",
 *     name="PubSubToAnyTopic",
 *     policy=pubsub.json)
 * cert = aws.iot.Certificate("cert",
 *     csr=std.file(input="csr.pem").result,
 *     active=True)
 * att = aws.iot.PolicyAttachment("att",
 *     policy=pubsub_policy.name,
 *     target=cert.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pubsub = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "iot:*",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *         },
 *     });
 *     var pubsubPolicy = new Aws.Iot.Policy("pubsub", new()
 *     {
 *         Name = "PubSubToAnyTopic",
 *         PolicyDocument = pubsub.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var cert = new Aws.Iot.Certificate("cert", new()
 *     {
 *         Csr = Std.File.Invoke(new()
 *         {
 *             Input = "csr.pem",
 *         }).Apply(invoke => invoke.Result),
 *         Active = true,
 *     });
 *     var att = new Aws.Iot.PolicyAttachment("att", new()
 *     {
 *         Policy = pubsubPolicy.Name,
 *         Target = cert.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		pubsub, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Actions: []string{
 * 						"iot:*",
 * 					},
 * 					Resources: []string{
 * 						"*",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		pubsubPolicy, err := iot.NewPolicy(ctx, "pubsub", &iot.PolicyArgs{
 * 			Name:   pulumi.String("PubSubToAnyTopic"),
 * 			Policy: pulumi.String(pubsub.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "csr.pem",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		cert, err := iot.NewCertificate(ctx, "cert", &iot.CertificateArgs{
 * 			Csr:    pulumi.String(invokeFile.Result),
 * 			Active: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iot.NewPolicyAttachment(ctx, "att", &iot.PolicyAttachmentArgs{
 * 			Policy: pubsubPolicy.Name,
 * 			Target: cert.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iot.Policy;
 * import com.pulumi.aws.iot.PolicyArgs;
 * import com.pulumi.aws.iot.Certificate;
 * import com.pulumi.aws.iot.CertificateArgs;
 * import com.pulumi.aws.iot.PolicyAttachment;
 * import com.pulumi.aws.iot.PolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var pubsub = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("iot:*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var pubsubPolicy = new Policy("pubsubPolicy", PolicyArgs.builder()
 *             .name("PubSubToAnyTopic")
 *             .policy(pubsub.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var cert = new Certificate("cert", CertificateArgs.builder()
 *             .csr(StdFunctions.file(FileArgs.builder()
 *                 .input("csr.pem")
 *                 .build()).result())
 *             .active(true)
 *             .build());
 *         var att = new PolicyAttachment("att", PolicyAttachmentArgs.builder()
 *             .policy(pubsubPolicy.name())
 *             .target(cert.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   pubsubPolicy:
 *     type: aws:iot:Policy
 *     name: pubsub
 *     properties:
 *       name: PubSubToAnyTopic
 *       policy: ${pubsub.json}
 *   cert:
 *     type: aws:iot:Certificate
 *     properties:
 *       csr:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: csr.pem
 *           Return: result
 *       active: true
 *   att:
 *     type: aws:iot:PolicyAttachment
 *     properties:
 *       policy: ${pubsubPolicy.name}
 *       target: ${cert.arn}
 * variables:
 *   pubsub:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             actions:
 *               - iot:*
 *             resources:
 *               - '*'
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class PolicyAttachment internal constructor(
    override val javaResource: com.pulumi.aws.iot.PolicyAttachment,
) : KotlinCustomResource(javaResource, PolicyAttachmentMapper) {
    /**
     * The name of the policy to attach.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * The identity to which the policy is attached.
     */
    public val target: Output<String>
        get() = javaResource.target().applyValue({ args0 -> args0 })
}

public object PolicyAttachmentMapper : ResourceMapper<PolicyAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iot.PolicyAttachment::class == javaResource::class

    override fun map(javaResource: Resource): PolicyAttachment = PolicyAttachment(
        javaResource as
            com.pulumi.aws.iot.PolicyAttachment,
    )
}

/**
 * @see [PolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PolicyAttachment].
 */
public suspend fun policyAttachment(
    name: String,
    block: suspend PolicyAttachmentResourceBuilder.() -> Unit,
): PolicyAttachment {
    val builder = PolicyAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policyAttachment(name: String): PolicyAttachment {
    val builder = PolicyAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
