@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.PolicyAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an IoT policy attachment.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const pubsub = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         actions: ["iot:*"],
 *         resources: ["*"],
 *     }],
 * });
 * const pubsubPolicy = new aws.iot.Policy("pubsub", {
 *     name: "PubSubToAnyTopic",
 *     policy: pubsub.then(pubsub => pubsub.json),
 * });
 * const cert = new aws.iot.Certificate("cert", {
 *     csr: std.file({
 *         input: "csr.pem",
 *     }).then(invoke => invoke.result),
 *     active: true,
 * });
 * const att = new aws.iot.PolicyAttachment("att", {
 *     policy: pubsubPolicy.name,
 *     target: cert.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * pubsub = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "actions": ["iot:*"],
 *     "resources": ["*"],
 * }])
 * pubsub_policy = aws.iot.Policy("pubsub",
 *     name="PubSubToAnyTopic",
 *     policy=pubsub.json)
 * cert = aws.iot.Certificate("cert",
 *     csr=std.file(input="csr.pem").result,
 *     active=True)
 * att = aws.iot.PolicyAttachment("att",
 *     policy=pubsub_policy.name,
 *     target=cert.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pubsub = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "iot:*",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *         },
 *     });
 *     var pubsubPolicy = new Aws.Iot.Policy("pubsub", new()
 *     {
 *         Name = "PubSubToAnyTopic",
 *         PolicyDocument = pubsub.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var cert = new Aws.Iot.Certificate("cert", new()
 *     {
 *         Csr = Std.File.Invoke(new()
 *         {
 *             Input = "csr.pem",
 *         }).Apply(invoke => invoke.Result),
 *         Active = true,
 *     });
 *     var att = new Aws.Iot.PolicyAttachment("att", new()
 *     {
 *         Policy = pubsubPolicy.Name,
 *         Target = cert.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		pubsub, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Actions: []string{
 * 						"iot:*",
 * 					},
 * 					Resources: []string{
 * 						"*",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		pubsubPolicy, err := iot.NewPolicy(ctx, "pubsub", &iot.PolicyArgs{
 * 			Name:   pulumi.String("PubSubToAnyTopic"),
 * 			Policy: pulumi.String(pubsub.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "csr.pem",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		cert, err := iot.NewCertificate(ctx, "cert", &iot.CertificateArgs{
 * 			Csr:    pulumi.String(invokeFile.Result),
 * 			Active: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iot.NewPolicyAttachment(ctx, "att", &iot.PolicyAttachmentArgs{
 * 			Policy: pubsubPolicy.Name,
 * 			Target: cert.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iot.Policy;
 * import com.pulumi.aws.iot.PolicyArgs;
 * import com.pulumi.aws.iot.Certificate;
 * import com.pulumi.aws.iot.CertificateArgs;
 * import com.pulumi.aws.iot.PolicyAttachment;
 * import com.pulumi.aws.iot.PolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var pubsub = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("iot:*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var pubsubPolicy = new Policy("pubsubPolicy", PolicyArgs.builder()
 *             .name("PubSubToAnyTopic")
 *             .policy(pubsub.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var cert = new Certificate("cert", CertificateArgs.builder()
 *             .csr(StdFunctions.file(FileArgs.builder()
 *                 .input("csr.pem")
 *                 .build()).result())
 *             .active(true)
 *             .build());
 *         var att = new PolicyAttachment("att", PolicyAttachmentArgs.builder()
 *             .policy(pubsubPolicy.name())
 *             .target(cert.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   pubsubPolicy:
 *     type: aws:iot:Policy
 *     name: pubsub
 *     properties:
 *       name: PubSubToAnyTopic
 *       policy: ${pubsub.json}
 *   cert:
 *     type: aws:iot:Certificate
 *     properties:
 *       csr:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: csr.pem
 *           Return: result
 *       active: true
 *   att:
 *     type: aws:iot:PolicyAttachment
 *     properties:
 *       policy: ${pubsubPolicy.name}
 *       target: ${cert.arn}
 * variables:
 *   pubsub:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             actions:
 *               - iot:*
 *             resources:
 *               - '*'
 * ```
 * <!--End PulumiCodeChooser -->
 * @property policy The name of the policy to attach.
 * @property target The identity to which the policy is attached.
 */
public data class PolicyAttachmentArgs(
    public val policy: Output<String>? = null,
    public val target: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.PolicyAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.iot.PolicyAttachmentArgs =
        com.pulumi.aws.iot.PolicyAttachmentArgs.builder()
            .policy(policy?.applyValue({ args0 -> args0 }))
            .target(target?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyAttachmentArgs].
 */
@PulumiTagMarker
public class PolicyAttachmentArgsBuilder internal constructor() {
    private var policy: Output<String>? = null

    private var target: Output<String>? = null

    /**
     * @param value The name of the policy to attach.
     */
    @JvmName("sxhrffwuvyeryobx")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The identity to which the policy is attached.
     */
    @JvmName("djablwhnbnujwfrp")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value The name of the policy to attach.
     */
    @JvmName("racffwlatxmuwntu")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The identity to which the policy is attached.
     */
    @JvmName("ygpyqmaemvnemkum")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    internal fun build(): PolicyAttachmentArgs = PolicyAttachmentArgs(
        policy = policy,
        target = target,
    )
}
