@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.kotlin.outputs.ProvisioningTemplatePreProvisioningHook
import com.pulumi.aws.iot.kotlin.outputs.ProvisioningTemplatePreProvisioningHook.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ProvisioningTemplate].
 */
@PulumiTagMarker
public class ProvisioningTemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProvisioningTemplateArgs = ProvisioningTemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProvisioningTemplateArgsBuilder.() -> Unit) {
        val builder = ProvisioningTemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProvisioningTemplate {
        val builtJavaResource = com.pulumi.aws.iot.ProvisioningTemplate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProvisioningTemplate(builtJavaResource)
    }
}

/**
 * Manages an IoT fleet provisioning template. For more info, see the AWS documentation on [fleet provisioning](https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const iotAssumeRolePolicy = aws.iam.getPolicyDocument({
 *     statements: [{
 *         actions: ["sts:AssumeRole"],
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["iot&#46;amazonaws&#46;com"],
 *         }],
 *     }],
 * });
 * const iotFleetProvisioning = new aws.iam.Role("iot_fleet_provisioning", {
 *     name: "IoTProvisioningServiceRole",
 *     path: "/service-role/",
 *     assumeRolePolicy: iotAssumeRolePolicy.then(iotAssumeRolePolicy => iotAssumeRolePolicy.json),
 * });
 * const iotFleetProvisioningRegistration = new aws.iam.RolePolicyAttachment("iot_fleet_provisioning_registration", {
 *     role: iotFleetProvisioning.name,
 *     policyArn: "arn:aws:iam::aws:policy/service-role/AWSIoTThingsRegistration",
 * });
 * const devicePolicy = aws.iam.getPolicyDocument({
 *     statements: [{
 *         actions: ["iot:Subscribe"],
 *         resources: ["*"],
 *     }],
 * });
 * const devicePolicyPolicy = new aws.iot.Policy("device_policy", {
 *     name: "DevicePolicy",
 *     policy: devicePolicy.then(devicePolicy => devicePolicy.json),
 * });
 * const fleet = new aws.iot.ProvisioningTemplate("fleet", {
 *     name: "FleetTemplate",
 *     description: "My provisioning template",
 *     provisioningRoleArn: iotFleetProvisioning.arn,
 *     enabled: true,
 *     templateBody: pulumi.jsonStringify({
 *         Parameters: {
 *             SerialNumber: {
 *                 Type: "String",
 *             },
 *         },
 *         Resources: {
 *             certificate: {
 *                 Properties: {
 *                     CertificateId: {
 *                         Ref: "AWS::IoT::Certificate::Id",
 *                     },
 *                     Status: "Active",
 *                 },
 *                 Type: "AWS::IoT::Certificate",
 *             },
 *             policy: {
 *                 Properties: {
 *                     PolicyName: devicePolicyPolicy.name,
 *                 },
 *                 Type: "AWS::IoT::Policy",
 *             },
 *         },
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * iot_assume_role_policy = aws.iam.get_policy_document(statements=[{
 *     "actions": ["sts:AssumeRole"],
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["iot&#46;amazonaws&#46;com"],
 *     }],
 * }])
 * iot_fleet_provisioning = aws.iam.Role("iot_fleet_provisioning",
 *     name="IoTProvisioningServiceRole",
 *     path="/service-role/",
 *     assume_role_policy=iot_assume_role_policy.json)
 * iot_fleet_provisioning_registration = aws.iam.RolePolicyAttachment("iot_fleet_provisioning_registration",
 *     role=iot_fleet_provisioning.name,
 *     policy_arn="arn:aws:iam::aws:policy/service-role/AWSIoTThingsRegistration")
 * device_policy = aws.iam.get_policy_document(statements=[{
 *     "actions": ["iot:Subscribe"],
 *     "resources": ["*"],
 * }])
 * device_policy_policy = aws.iot.Policy("device_policy",
 *     name="DevicePolicy",
 *     policy=device_policy.json)
 * fleet = aws.iot.ProvisioningTemplate("fleet",
 *     name="FleetTemplate",
 *     description="My provisioning template",
 *     provisioning_role_arn=iot_fleet_provisioning.arn,
 *     enabled=True,
 *     template_body=pulumi.Output.json_dumps({
 *         "Parameters": {
 *             "SerialNumber": {
 *                 "Type": "String",
 *             },
 *         },
 *         "Resources": {
 *             "certificate": {
 *                 "Properties": {
 *                     "CertificateId": {
 *                         "Ref": "AWS::IoT::Certificate::Id",
 *                     },
 *                     "Status": "Active",
 *                 },
 *                 "Type": "AWS::IoT::Certificate",
 *             },
 *             "policy": {
 *                 "Properties": {
 *                     "PolicyName": device_policy_policy.name,
 *                 },
 *                 "Type": "AWS::IoT::Policy",
 *             },
 *         },
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iotAssumeRolePolicy = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "iot.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var iotFleetProvisioning = new Aws.Iam.Role("iot_fleet_provisioning", new()
 *     {
 *         Name = "IoTProvisioningServiceRole",
 *         Path = "/service-role/",
 *         AssumeRolePolicy = iotAssumeRolePolicy.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var iotFleetProvisioningRegistration = new Aws.Iam.RolePolicyAttachment("iot_fleet_provisioning_registration", new()
 *     {
 *         Role = iotFleetProvisioning.Name,
 *         PolicyArn = "arn:aws:iam::aws:policy/service-role/AWSIoTThingsRegistration",
 *     });
 *     var devicePolicy = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "iot:Subscribe",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *         },
 *     });
 *     var devicePolicyPolicy = new Aws.Iot.Policy("device_policy", new()
 *     {
 *         Name = "DevicePolicy",
 *         PolicyDocument = devicePolicy.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var fleet = new Aws.Iot.ProvisioningTemplate("fleet", new()
 *     {
 *         Name = "FleetTemplate",
 *         Description = "My provisioning template",
 *         ProvisioningRoleArn = iotFleetProvisioning.Arn,
 *         Enabled = true,
 *         TemplateBody = Output.JsonSerialize(Output.Create(new Dictionary<string, object?>
 *         {
 *             ["Parameters"] = new Dictionary<string, object?>
 *             {
 *                 ["SerialNumber"] = new Dictionary<string, object?>
 *                 {
 *                     ["Type"] = "String",
 *                 },
 *             },
 *             ["Resources"] = new Dictionary<string, object?>
 *             {
 *                 ["certificate"] = new Dictionary<string, object?>
 *                 {
 *                     ["Properties"] = new Dictionary<string, object?>
 *                     {
 *                         ["CertificateId"] = new Dictionary<string, object?>
 *                         {
 *                             ["Ref"] = "AWS::IoT::Certificate::Id",
 *                         },
 *                         ["Status"] = "Active",
 *                     },
 *                     ["Type"] = "AWS::IoT::Certificate",
 *                 },
 *                 ["policy"] = new Dictionary<string, object?>
 *                 {
 *                     ["Properties"] = new Dictionary<string, object?>
 *                     {
 *                         ["PolicyName"] = devicePolicyPolicy.Name,
 *                     },
 *                     ["Type"] = "AWS::IoT::Policy",
 *                 },
 *             },
 *         })),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		iotAssumeRolePolicy, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"iot.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		iotFleetProvisioning, err := iam.NewRole(ctx, "iot_fleet_provisioning", &iam.RoleArgs{
 * 			Name:             pulumi.String("IoTProvisioningServiceRole"),
 * 			Path:             pulumi.String("/service-role/"),
 * 			AssumeRolePolicy: pulumi.String(iotAssumeRolePolicy.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRolePolicyAttachment(ctx, "iot_fleet_provisioning_registration", &iam.RolePolicyAttachmentArgs{
 * 			Role:      iotFleetProvisioning.Name,
 * 			PolicyArn: pulumi.String("arn:aws:iam::aws:policy/service-role/AWSIoTThingsRegistration"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		devicePolicy, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Actions: []string{
 * 						"iot:Subscribe",
 * 					},
 * 					Resources: []string{
 * 						"*",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		devicePolicyPolicy, err := iot.NewPolicy(ctx, "device_policy", &iot.PolicyArgs{
 * 			Name:   pulumi.String("DevicePolicy"),
 * 			Policy: pulumi.String(devicePolicy.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iot.NewProvisioningTemplate(ctx, "fleet", &iot.ProvisioningTemplateArgs{
 * 			Name:                pulumi.String("FleetTemplate"),
 * 			Description:         pulumi.String("My provisioning template"),
 * 			ProvisioningRoleArn: iotFleetProvisioning.Arn,
 * 			Enabled:             pulumi.Bool(true),
 * 			TemplateBody: devicePolicyPolicy.Name.ApplyT(func(name string) (pulumi.String, error) {
 * 				var _zero pulumi.String
 * 				tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 					"Parameters": map[string]interface{}{
 * 						"SerialNumber": map[string]interface{}{
 * 							"Type": "String",
 * 						},
 * 					},
 * 					"Resources": map[string]interface{}{
 * 						"certificate": map[string]interface{}{
 * 							"Properties": map[string]interface{}{
 * 								"CertificateId": map[string]interface{}{
 * 									"Ref": "AWS::IoT::Certificate::Id",
 * 								},
 * 								"Status": "Active",
 * 							},
 * 							"Type": "AWS::IoT::Certificate",
 * 						},
 * 						"policy": map[string]interface{}{
 * 							"Properties": map[string]interface{}{
 * 								"PolicyName": name,
 * 							},
 * 							"Type": "AWS::IoT::Policy",
 * 						},
 * 					},
 * 				})
 * 				if err != nil {
 * 					return _zero, err
 * 				}
 * 				json0 := string(tmpJSON0)
 * 				return pulumi.String(json0), nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.iot.Policy;
 * import com.pulumi.aws.iot.PolicyArgs;
 * import com.pulumi.aws.iot.ProvisioningTemplate;
 * import com.pulumi.aws.iot.ProvisioningTemplateArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var iotAssumeRolePolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("iot.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var iotFleetProvisioning = new Role("iotFleetProvisioning", RoleArgs.builder()
 *             .name("IoTProvisioningServiceRole")
 *             .path("/service-role/")
 *             .assumeRolePolicy(iotAssumeRolePolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var iotFleetProvisioningRegistration = new RolePolicyAttachment("iotFleetProvisioningRegistration", RolePolicyAttachmentArgs.builder()
 *             .role(iotFleetProvisioning.name())
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AWSIoTThingsRegistration")
 *             .build());
 *         final var devicePolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("iot:Subscribe")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var devicePolicyPolicy = new Policy("devicePolicyPolicy", PolicyArgs.builder()
 *             .name("DevicePolicy")
 *             .policy(devicePolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var fleet = new ProvisioningTemplate("fleet", ProvisioningTemplateArgs.builder()
 *             .name("FleetTemplate")
 *             .description("My provisioning template")
 *             .provisioningRoleArn(iotFleetProvisioning.arn())
 *             .enabled(true)
 *             .templateBody(devicePolicyPolicy.name().applyValue(name -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Parameters", jsonObject(
 *                         jsonProperty("SerialNumber", jsonObject(
 *                             jsonProperty("Type", "String")
 *                         ))
 *                     )),
 *                     jsonProperty("Resources", jsonObject(
 *                         jsonProperty("certificate", jsonObject(
 *                             jsonProperty("Properties", jsonObject(
 *                                 jsonProperty("CertificateId", jsonObject(
 *                                     jsonProperty("Ref", "AWS::IoT::Certificate::Id")
 *                                 )),
 *                                 jsonProperty("Status", "Active")
 *                             )),
 *                             jsonProperty("Type", "AWS::IoT::Certificate")
 *                         )),
 *                         jsonProperty("policy", jsonObject(
 *                             jsonProperty("Properties", jsonObject(
 *                                 jsonProperty("PolicyName", name)
 *                             )),
 *                             jsonProperty("Type", "AWS::IoT::Policy")
 *                         ))
 *                     ))
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   iotFleetProvisioning:
 *     type: aws:iam:Role
 *     name: iot_fleet_provisioning
 *     properties:
 *       name: IoTProvisioningServiceRole
 *       path: /service-role/
 *       assumeRolePolicy: ${iotAssumeRolePolicy.json}
 *   iotFleetProvisioningRegistration:
 *     type: aws:iam:RolePolicyAttachment
 *     name: iot_fleet_provisioning_registration
 *     properties:
 *       role: ${iotFleetProvisioning.name}
 *       policyArn: arn:aws:iam::aws:policy/service-role/AWSIoTThingsRegistration
 *   devicePolicyPolicy:
 *     type: aws:iot:Policy
 *     name: device_policy
 *     properties:
 *       name: DevicePolicy
 *       policy: ${devicePolicy.json}
 *   fleet:
 *     type: aws:iot:ProvisioningTemplate
 *     properties:
 *       name: FleetTemplate
 *       description: My provisioning template
 *       provisioningRoleArn: ${iotFleetProvisioning.arn}
 *       enabled: true
 *       templateBody:
 *         fn::toJSON:
 *           Parameters:
 *             SerialNumber:
 *               Type: String
 *           Resources:
 *             certificate:
 *               Properties:
 *                 CertificateId:
 *                   Ref: AWS::IoT::Certificate::Id
 *                 Status: Active
 *               Type: AWS::IoT::Certificate
 *             policy:
 *               Properties:
 *                 PolicyName: ${devicePolicyPolicy.name}
 *               Type: AWS::IoT::Policy
 * variables:
 *   iotAssumeRolePolicy:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - sts:AssumeRole
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - iot.amazonaws.com
 *   devicePolicy:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - iot:Subscribe
 *             resources:
 *               - '*'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IoT fleet provisioning templates using the `name`. For example:
 * ```sh
 * $ pulumi import aws:iot/provisioningTemplate:ProvisioningTemplate fleet FleetProvisioningTemplate
 * ```
 */
public class ProvisioningTemplate internal constructor(
    override val javaResource: com.pulumi.aws.iot.ProvisioningTemplate,
) : KotlinCustomResource(javaResource, ProvisioningTemplateMapper) {
    /**
     * The ARN that identifies the provisioning template.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The default version of the fleet provisioning template.
     */
    public val defaultVersionId: Output<Int>
        get() = javaResource.defaultVersionId().applyValue({ args0 -> args0 })

    /**
     * The description of the fleet provisioning template.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * True to enable the fleet provisioning template, otherwise false.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the fleet provisioning template.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a pre-provisioning hook template. Details below.
     */
    public val preProvisioningHook: Output<ProvisioningTemplatePreProvisioningHook>?
        get() = javaResource.preProvisioningHook().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The role ARN for the role associated with the fleet provisioning template. This IoT role grants permission to provision a device.
     */
    public val provisioningRoleArn: Output<String>
        get() = javaResource.provisioningRoleArn().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The JSON formatted contents of the fleet provisioning template.
     */
    public val templateBody: Output<String>
        get() = javaResource.templateBody().applyValue({ args0 -> args0 })

    /**
     * The type you define in a provisioning template.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ProvisioningTemplateMapper : ResourceMapper<ProvisioningTemplate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iot.ProvisioningTemplate::class == javaResource::class

    override fun map(javaResource: Resource): ProvisioningTemplate = ProvisioningTemplate(
        javaResource
            as com.pulumi.aws.iot.ProvisioningTemplate,
    )
}

/**
 * @see [ProvisioningTemplate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProvisioningTemplate].
 */
public suspend fun provisioningTemplate(
    name: String,
    block: suspend ProvisioningTemplateResourceBuilder.() -> Unit,
): ProvisioningTemplate {
    val builder = ProvisioningTemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProvisioningTemplate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun provisioningTemplate(name: String): ProvisioningTemplate {
    val builder = ProvisioningTemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
