@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.ProvisioningTemplateArgs.builder
import com.pulumi.aws.iot.kotlin.inputs.ProvisioningTemplatePreProvisioningHookArgs
import com.pulumi.aws.iot.kotlin.inputs.ProvisioningTemplatePreProvisioningHookArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an IoT fleet provisioning template. For more info, see the AWS documentation on [fleet provisioning](https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const iotAssumeRolePolicy = aws.iam.getPolicyDocument({
 *     statements: [{
 *         actions: ["sts:AssumeRole"],
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["iot&#46;amazonaws&#46;com"],
 *         }],
 *     }],
 * });
 * const iotFleetProvisioning = new aws.iam.Role("iot_fleet_provisioning", {
 *     name: "IoTProvisioningServiceRole",
 *     path: "/service-role/",
 *     assumeRolePolicy: iotAssumeRolePolicy.then(iotAssumeRolePolicy => iotAssumeRolePolicy.json),
 * });
 * const iotFleetProvisioningRegistration = new aws.iam.RolePolicyAttachment("iot_fleet_provisioning_registration", {
 *     role: iotFleetProvisioning.name,
 *     policyArn: "arn:aws:iam::aws:policy/service-role/AWSIoTThingsRegistration",
 * });
 * const devicePolicy = aws.iam.getPolicyDocument({
 *     statements: [{
 *         actions: ["iot:Subscribe"],
 *         resources: ["*"],
 *     }],
 * });
 * const devicePolicyPolicy = new aws.iot.Policy("device_policy", {
 *     name: "DevicePolicy",
 *     policy: devicePolicy.then(devicePolicy => devicePolicy.json),
 * });
 * const fleet = new aws.iot.ProvisioningTemplate("fleet", {
 *     name: "FleetTemplate",
 *     description: "My provisioning template",
 *     provisioningRoleArn: iotFleetProvisioning.arn,
 *     enabled: true,
 *     templateBody: pulumi.jsonStringify({
 *         Parameters: {
 *             SerialNumber: {
 *                 Type: "String",
 *             },
 *         },
 *         Resources: {
 *             certificate: {
 *                 Properties: {
 *                     CertificateId: {
 *                         Ref: "AWS::IoT::Certificate::Id",
 *                     },
 *                     Status: "Active",
 *                 },
 *                 Type: "AWS::IoT::Certificate",
 *             },
 *             policy: {
 *                 Properties: {
 *                     PolicyName: devicePolicyPolicy.name,
 *                 },
 *                 Type: "AWS::IoT::Policy",
 *             },
 *         },
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * iot_assume_role_policy = aws.iam.get_policy_document(statements=[{
 *     "actions": ["sts:AssumeRole"],
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["iot&#46;amazonaws&#46;com"],
 *     }],
 * }])
 * iot_fleet_provisioning = aws.iam.Role("iot_fleet_provisioning",
 *     name="IoTProvisioningServiceRole",
 *     path="/service-role/",
 *     assume_role_policy=iot_assume_role_policy.json)
 * iot_fleet_provisioning_registration = aws.iam.RolePolicyAttachment("iot_fleet_provisioning_registration",
 *     role=iot_fleet_provisioning.name,
 *     policy_arn="arn:aws:iam::aws:policy/service-role/AWSIoTThingsRegistration")
 * device_policy = aws.iam.get_policy_document(statements=[{
 *     "actions": ["iot:Subscribe"],
 *     "resources": ["*"],
 * }])
 * device_policy_policy = aws.iot.Policy("device_policy",
 *     name="DevicePolicy",
 *     policy=device_policy.json)
 * fleet = aws.iot.ProvisioningTemplate("fleet",
 *     name="FleetTemplate",
 *     description="My provisioning template",
 *     provisioning_role_arn=iot_fleet_provisioning.arn,
 *     enabled=True,
 *     template_body=pulumi.Output.json_dumps({
 *         "Parameters": {
 *             "SerialNumber": {
 *                 "Type": "String",
 *             },
 *         },
 *         "Resources": {
 *             "certificate": {
 *                 "Properties": {
 *                     "CertificateId": {
 *                         "Ref": "AWS::IoT::Certificate::Id",
 *                     },
 *                     "Status": "Active",
 *                 },
 *                 "Type": "AWS::IoT::Certificate",
 *             },
 *             "policy": {
 *                 "Properties": {
 *                     "PolicyName": device_policy_policy.name,
 *                 },
 *                 "Type": "AWS::IoT::Policy",
 *             },
 *         },
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iotAssumeRolePolicy = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "iot.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var iotFleetProvisioning = new Aws.Iam.Role("iot_fleet_provisioning", new()
 *     {
 *         Name = "IoTProvisioningServiceRole",
 *         Path = "/service-role/",
 *         AssumeRolePolicy = iotAssumeRolePolicy.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var iotFleetProvisioningRegistration = new Aws.Iam.RolePolicyAttachment("iot_fleet_provisioning_registration", new()
 *     {
 *         Role = iotFleetProvisioning.Name,
 *         PolicyArn = "arn:aws:iam::aws:policy/service-role/AWSIoTThingsRegistration",
 *     });
 *     var devicePolicy = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "iot:Subscribe",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *         },
 *     });
 *     var devicePolicyPolicy = new Aws.Iot.Policy("device_policy", new()
 *     {
 *         Name = "DevicePolicy",
 *         PolicyDocument = devicePolicy.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var fleet = new Aws.Iot.ProvisioningTemplate("fleet", new()
 *     {
 *         Name = "FleetTemplate",
 *         Description = "My provisioning template",
 *         ProvisioningRoleArn = iotFleetProvisioning.Arn,
 *         Enabled = true,
 *         TemplateBody = Output.JsonSerialize(Output.Create(new Dictionary<string, object?>
 *         {
 *             ["Parameters"] = new Dictionary<string, object?>
 *             {
 *                 ["SerialNumber"] = new Dictionary<string, object?>
 *                 {
 *                     ["Type"] = "String",
 *                 },
 *             },
 *             ["Resources"] = new Dictionary<string, object?>
 *             {
 *                 ["certificate"] = new Dictionary<string, object?>
 *                 {
 *                     ["Properties"] = new Dictionary<string, object?>
 *                     {
 *                         ["CertificateId"] = new Dictionary<string, object?>
 *                         {
 *                             ["Ref"] = "AWS::IoT::Certificate::Id",
 *                         },
 *                         ["Status"] = "Active",
 *                     },
 *                     ["Type"] = "AWS::IoT::Certificate",
 *                 },
 *                 ["policy"] = new Dictionary<string, object?>
 *                 {
 *                     ["Properties"] = new Dictionary<string, object?>
 *                     {
 *                         ["PolicyName"] = devicePolicyPolicy.Name,
 *                     },
 *                     ["Type"] = "AWS::IoT::Policy",
 *                 },
 *             },
 *         })),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		iotAssumeRolePolicy, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"iot.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		iotFleetProvisioning, err := iam.NewRole(ctx, "iot_fleet_provisioning", &iam.RoleArgs{
 * 			Name:             pulumi.String("IoTProvisioningServiceRole"),
 * 			Path:             pulumi.String("/service-role/"),
 * 			AssumeRolePolicy: pulumi.String(iotAssumeRolePolicy.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRolePolicyAttachment(ctx, "iot_fleet_provisioning_registration", &iam.RolePolicyAttachmentArgs{
 * 			Role:      iotFleetProvisioning.Name,
 * 			PolicyArn: pulumi.String("arn:aws:iam::aws:policy/service-role/AWSIoTThingsRegistration"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		devicePolicy, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Actions: []string{
 * 						"iot:Subscribe",
 * 					},
 * 					Resources: []string{
 * 						"*",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		devicePolicyPolicy, err := iot.NewPolicy(ctx, "device_policy", &iot.PolicyArgs{
 * 			Name:   pulumi.String("DevicePolicy"),
 * 			Policy: pulumi.String(devicePolicy.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iot.NewProvisioningTemplate(ctx, "fleet", &iot.ProvisioningTemplateArgs{
 * 			Name:                pulumi.String("FleetTemplate"),
 * 			Description:         pulumi.String("My provisioning template"),
 * 			ProvisioningRoleArn: iotFleetProvisioning.Arn,
 * 			Enabled:             pulumi.Bool(true),
 * 			TemplateBody: devicePolicyPolicy.Name.ApplyT(func(name string) (pulumi.String, error) {
 * 				var _zero pulumi.String
 * 				tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 					"Parameters": map[string]interface{}{
 * 						"SerialNumber": map[string]interface{}{
 * 							"Type": "String",
 * 						},
 * 					},
 * 					"Resources": map[string]interface{}{
 * 						"certificate": map[string]interface{}{
 * 							"Properties": map[string]interface{}{
 * 								"CertificateId": map[string]interface{}{
 * 									"Ref": "AWS::IoT::Certificate::Id",
 * 								},
 * 								"Status": "Active",
 * 							},
 * 							"Type": "AWS::IoT::Certificate",
 * 						},
 * 						"policy": map[string]interface{}{
 * 							"Properties": map[string]interface{}{
 * 								"PolicyName": name,
 * 							},
 * 							"Type": "AWS::IoT::Policy",
 * 						},
 * 					},
 * 				})
 * 				if err != nil {
 * 					return _zero, err
 * 				}
 * 				json0 := string(tmpJSON0)
 * 				return pulumi.String(json0), nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.iot.Policy;
 * import com.pulumi.aws.iot.PolicyArgs;
 * import com.pulumi.aws.iot.ProvisioningTemplate;
 * import com.pulumi.aws.iot.ProvisioningTemplateArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var iotAssumeRolePolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("iot.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var iotFleetProvisioning = new Role("iotFleetProvisioning", RoleArgs.builder()
 *             .name("IoTProvisioningServiceRole")
 *             .path("/service-role/")
 *             .assumeRolePolicy(iotAssumeRolePolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var iotFleetProvisioningRegistration = new RolePolicyAttachment("iotFleetProvisioningRegistration", RolePolicyAttachmentArgs.builder()
 *             .role(iotFleetProvisioning.name())
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AWSIoTThingsRegistration")
 *             .build());
 *         final var devicePolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("iot:Subscribe")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var devicePolicyPolicy = new Policy("devicePolicyPolicy", PolicyArgs.builder()
 *             .name("DevicePolicy")
 *             .policy(devicePolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var fleet = new ProvisioningTemplate("fleet", ProvisioningTemplateArgs.builder()
 *             .name("FleetTemplate")
 *             .description("My provisioning template")
 *             .provisioningRoleArn(iotFleetProvisioning.arn())
 *             .enabled(true)
 *             .templateBody(devicePolicyPolicy.name().applyValue(name -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Parameters", jsonObject(
 *                         jsonProperty("SerialNumber", jsonObject(
 *                             jsonProperty("Type", "String")
 *                         ))
 *                     )),
 *                     jsonProperty("Resources", jsonObject(
 *                         jsonProperty("certificate", jsonObject(
 *                             jsonProperty("Properties", jsonObject(
 *                                 jsonProperty("CertificateId", jsonObject(
 *                                     jsonProperty("Ref", "AWS::IoT::Certificate::Id")
 *                                 )),
 *                                 jsonProperty("Status", "Active")
 *                             )),
 *                             jsonProperty("Type", "AWS::IoT::Certificate")
 *                         )),
 *                         jsonProperty("policy", jsonObject(
 *                             jsonProperty("Properties", jsonObject(
 *                                 jsonProperty("PolicyName", name)
 *                             )),
 *                             jsonProperty("Type", "AWS::IoT::Policy")
 *                         ))
 *                     ))
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   iotFleetProvisioning:
 *     type: aws:iam:Role
 *     name: iot_fleet_provisioning
 *     properties:
 *       name: IoTProvisioningServiceRole
 *       path: /service-role/
 *       assumeRolePolicy: ${iotAssumeRolePolicy.json}
 *   iotFleetProvisioningRegistration:
 *     type: aws:iam:RolePolicyAttachment
 *     name: iot_fleet_provisioning_registration
 *     properties:
 *       role: ${iotFleetProvisioning.name}
 *       policyArn: arn:aws:iam::aws:policy/service-role/AWSIoTThingsRegistration
 *   devicePolicyPolicy:
 *     type: aws:iot:Policy
 *     name: device_policy
 *     properties:
 *       name: DevicePolicy
 *       policy: ${devicePolicy.json}
 *   fleet:
 *     type: aws:iot:ProvisioningTemplate
 *     properties:
 *       name: FleetTemplate
 *       description: My provisioning template
 *       provisioningRoleArn: ${iotFleetProvisioning.arn}
 *       enabled: true
 *       templateBody:
 *         fn::toJSON:
 *           Parameters:
 *             SerialNumber:
 *               Type: String
 *           Resources:
 *             certificate:
 *               Properties:
 *                 CertificateId:
 *                   Ref: AWS::IoT::Certificate::Id
 *                 Status: Active
 *               Type: AWS::IoT::Certificate
 *             policy:
 *               Properties:
 *                 PolicyName: ${devicePolicyPolicy.name}
 *               Type: AWS::IoT::Policy
 * variables:
 *   iotAssumeRolePolicy:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - sts:AssumeRole
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - iot.amazonaws.com
 *   devicePolicy:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - iot:Subscribe
 *             resources:
 *               - '*'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IoT fleet provisioning templates using the `name`. For example:
 * ```sh
 * $ pulumi import aws:iot/provisioningTemplate:ProvisioningTemplate fleet FleetProvisioningTemplate
 * ```
 * @property description The description of the fleet provisioning template.
 * @property enabled True to enable the fleet provisioning template, otherwise false.
 * @property name The name of the fleet provisioning template.
 * @property preProvisioningHook Creates a pre-provisioning hook template. Details below.
 * @property provisioningRoleArn The role ARN for the role associated with the fleet provisioning template. This IoT role grants permission to provision a device.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property templateBody The JSON formatted contents of the fleet provisioning template.
 * @property type The type you define in a provisioning template.
 */
public data class ProvisioningTemplateArgs(
    public val description: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val preProvisioningHook: Output<ProvisioningTemplatePreProvisioningHookArgs>? = null,
    public val provisioningRoleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val templateBody: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.ProvisioningTemplateArgs> {
    override fun toJava(): com.pulumi.aws.iot.ProvisioningTemplateArgs =
        com.pulumi.aws.iot.ProvisioningTemplateArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .preProvisioningHook(
                preProvisioningHook?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .provisioningRoleArn(provisioningRoleArn?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .templateBody(templateBody?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProvisioningTemplateArgs].
 */
@PulumiTagMarker
public class ProvisioningTemplateArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var preProvisioningHook: Output<ProvisioningTemplatePreProvisioningHookArgs>? = null

    private var provisioningRoleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var templateBody: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The description of the fleet provisioning template.
     */
    @JvmName("bfiuuyxvgssdhumu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value True to enable the fleet provisioning template, otherwise false.
     */
    @JvmName("nutfpbbynjupvnaq")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The name of the fleet provisioning template.
     */
    @JvmName("srivforlapwvsoln")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a pre-provisioning hook template. Details below.
     */
    @JvmName("ttapqnkqacyymxor")
    public suspend fun preProvisioningHook(`value`: Output<ProvisioningTemplatePreProvisioningHookArgs>) {
        this.preProvisioningHook = value
    }

    /**
     * @param value The role ARN for the role associated with the fleet provisioning template. This IoT role grants permission to provision a device.
     */
    @JvmName("qvqyciufvdolhbhx")
    public suspend fun provisioningRoleArn(`value`: Output<String>) {
        this.provisioningRoleArn = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qvranbweddrqjhxj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The JSON formatted contents of the fleet provisioning template.
     */
    @JvmName("wlatpdjitvyhyiog")
    public suspend fun templateBody(`value`: Output<String>) {
        this.templateBody = value
    }

    /**
     * @param value The type you define in a provisioning template.
     */
    @JvmName("bytwpkwadwaxtyxo")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The description of the fleet provisioning template.
     */
    @JvmName("faplyjkioybkqnwx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value True to enable the fleet provisioning template, otherwise false.
     */
    @JvmName("vgaoryqwfdwhokvr")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The name of the fleet provisioning template.
     */
    @JvmName("jbutqdygjlwbhbnn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a pre-provisioning hook template. Details below.
     */
    @JvmName("auadnfdmqqwkdafx")
    public suspend fun preProvisioningHook(`value`: ProvisioningTemplatePreProvisioningHookArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preProvisioningHook = mapped
    }

    /**
     * @param argument Creates a pre-provisioning hook template. Details below.
     */
    @JvmName("tnnvrkekhpgrsbjj")
    public suspend fun preProvisioningHook(argument: suspend ProvisioningTemplatePreProvisioningHookArgsBuilder.() -> Unit) {
        val toBeMapped = ProvisioningTemplatePreProvisioningHookArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.preProvisioningHook = mapped
    }

    /**
     * @param value The role ARN for the role associated with the fleet provisioning template. This IoT role grants permission to provision a device.
     */
    @JvmName("bgmwovgyqsbkftra")
    public suspend fun provisioningRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningRoleArn = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ralvobsrbvilqaee")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eykpbhnjviwfcdbi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The JSON formatted contents of the fleet provisioning template.
     */
    @JvmName("wcgagbugjaoapmjk")
    public suspend fun templateBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateBody = mapped
    }

    /**
     * @param value The type you define in a provisioning template.
     */
    @JvmName("ekrhkxpikxdpbakj")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ProvisioningTemplateArgs = ProvisioningTemplateArgs(
        description = description,
        enabled = enabled,
        name = name,
        preProvisioningHook = preProvisioningHook,
        provisioningRoleArn = provisioningRoleArn,
        tags = tags,
        templateBody = templateBody,
        type = type,
    )
}
