@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [RoleAlias].
 */
@PulumiTagMarker
public class RoleAliasResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RoleAliasArgs = RoleAliasArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RoleAliasArgsBuilder.() -> Unit) {
        val builder = RoleAliasArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RoleAlias {
        val builtJavaResource = com.pulumi.aws.iot.RoleAlias(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RoleAlias(builtJavaResource)
    }
}

/**
 * Provides an IoT role alias.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iot.RoleAlias;
 * import com.pulumi.aws.iot.RoleAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .effect("Allow")
 *             .principals(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *             .actions("sts:AssumeRole")
 *             .build());
 *         var role = new Role("role", RoleArgs.builder()
 *             .name("dynamodb-access-role")
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var alias = new RoleAlias("alias", RoleAliasArgs.builder()
 *             .alias("Thermostat-dynamodb-access-role-alias")
 *             .roleArn(role.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   role:
 *     type: aws:iam:Role
 *     properties:
 *       name: dynamodb-access-role
 *       assumeRolePolicy: ${assumeRole.json}
 *   alias:
 *     type: aws:iot:RoleAlias
 *     properties:
 *       alias: Thermostat-dynamodb-access-role-alias
 *       roleArn: ${role.arn}
 * variables:
 *   assumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         effect: Allow
 *         principals:
 *           - type: Service
 *             identifiers:
 *               - credentials.iot.amazonaws.com
 *         actions:
 *           - sts:AssumeRole
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IOT Role Alias using the alias. For example:
 * ```sh
 * $ pulumi import aws:iot/roleAlias:RoleAlias example myalias
 * ```
 */
public class RoleAlias internal constructor(
    override val javaResource: com.pulumi.aws.iot.RoleAlias,
) : KotlinCustomResource(javaResource, RoleAliasMapper) {
    /**
     * The name of the role alias.
     */
    public val alias: Output<String>
        get() = javaResource.alias().applyValue({ args0 -> args0 })

    /**
     * The ARN assigned by AWS to this role alias.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The duration of the credential, in seconds. If you do not specify a value for this setting, the default maximum of one hour is applied. This setting can have a value from 900 seconds (15 minutes) to 43200 seconds (12 hours).
     */
    public val credentialDuration: Output<Int>?
        get() = javaResource.credentialDuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The identity of the role to which the alias refers.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object RoleAliasMapper : ResourceMapper<RoleAlias> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iot.RoleAlias::class == javaResource::class

    override fun map(javaResource: Resource): RoleAlias = RoleAlias(
        javaResource as
            com.pulumi.aws.iot.RoleAlias,
    )
}

/**
 * @see [RoleAlias].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RoleAlias].
 */
public suspend fun roleAlias(name: String, block: suspend RoleAliasResourceBuilder.() -> Unit): RoleAlias {
    val builder = RoleAliasResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RoleAlias].
 * @param name The _unique_ name of the resulting resource.
 */
public fun roleAlias(name: String): RoleAlias {
    val builder = RoleAliasResourceBuilder()
    builder.name(name)
    return builder.build()
}
