@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.RoleAliasArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an IoT role alias.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iot.RoleAlias;
 * import com.pulumi.aws.iot.RoleAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .effect("Allow")
 *             .principals(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *             .actions("sts:AssumeRole")
 *             .build());
 *         var role = new Role("role", RoleArgs.builder()
 *             .name("dynamodb-access-role")
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var alias = new RoleAlias("alias", RoleAliasArgs.builder()
 *             .alias("Thermostat-dynamodb-access-role-alias")
 *             .roleArn(role.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   role:
 *     type: aws:iam:Role
 *     properties:
 *       name: dynamodb-access-role
 *       assumeRolePolicy: ${assumeRole.json}
 *   alias:
 *     type: aws:iot:RoleAlias
 *     properties:
 *       alias: Thermostat-dynamodb-access-role-alias
 *       roleArn: ${role.arn}
 * variables:
 *   assumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         effect: Allow
 *         principals:
 *           - type: Service
 *             identifiers:
 *               - credentials.iot.amazonaws.com
 *         actions:
 *           - sts:AssumeRole
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IOT Role Alias using the alias. For example:
 * ```sh
 * $ pulumi import aws:iot/roleAlias:RoleAlias example myalias
 * ```
 * @property alias The name of the role alias.
 * @property credentialDuration The duration of the credential, in seconds. If you do not specify a value for this setting, the default maximum of one hour is applied. This setting can have a value from 900 seconds (15 minutes) to 43200 seconds (12 hours).
 * @property roleArn The identity of the role to which the alias refers.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class RoleAliasArgs(
    public val alias: Output<String>? = null,
    public val credentialDuration: Output<Int>? = null,
    public val roleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.RoleAliasArgs> {
    override fun toJava(): com.pulumi.aws.iot.RoleAliasArgs =
        com.pulumi.aws.iot.RoleAliasArgs.builder()
            .alias(alias?.applyValue({ args0 -> args0 }))
            .credentialDuration(credentialDuration?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RoleAliasArgs].
 */
@PulumiTagMarker
public class RoleAliasArgsBuilder internal constructor() {
    private var alias: Output<String>? = null

    private var credentialDuration: Output<Int>? = null

    private var roleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the role alias.
     */
    @JvmName("qctrmvbjunboqrqv")
    public suspend fun alias(`value`: Output<String>) {
        this.alias = value
    }

    /**
     * @param value The duration of the credential, in seconds. If you do not specify a value for this setting, the default maximum of one hour is applied. This setting can have a value from 900 seconds (15 minutes) to 43200 seconds (12 hours).
     */
    @JvmName("cxarttlagveppihx")
    public suspend fun credentialDuration(`value`: Output<Int>) {
        this.credentialDuration = value
    }

    /**
     * @param value The identity of the role to which the alias refers.
     */
    @JvmName("pivmuviimuixheph")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ewqlnfhswpuyjusk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the role alias.
     */
    @JvmName("nrfvwxnfprjxsaic")
    public suspend fun alias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alias = mapped
    }

    /**
     * @param value The duration of the credential, in seconds. If you do not specify a value for this setting, the default maximum of one hour is applied. This setting can have a value from 900 seconds (15 minutes) to 43200 seconds (12 hours).
     */
    @JvmName("nlmiactamcrofbjn")
    public suspend fun credentialDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentialDuration = mapped
    }

    /**
     * @param value The identity of the role to which the alias refers.
     */
    @JvmName("deoenjclxfftaueq")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yuceumrcwhuowexh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sruxlfonvyoonktp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RoleAliasArgs = RoleAliasArgs(
        alias = alias,
        credentialDuration = credentialDuration,
        roleArn = roleArn,
        tags = tags,
    )
}
