@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Thing].
 */
@PulumiTagMarker
public class ThingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ThingArgs = ThingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ThingArgsBuilder.() -> Unit) {
        val builder = ThingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Thing {
        val builtJavaResource = com.pulumi.aws.iot.Thing(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Thing(builtJavaResource)
    }
}

/**
 * Creates and manages an AWS IoT Thing.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.iot.Thing("example", {
 *     name: "example",
 *     attributes: {
 *         First: "examplevalue",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.iot.Thing("example",
 *     name="example",
 *     attributes={
 *         "First": "examplevalue",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Iot.Thing("example", new()
 *     {
 *         Name = "example",
 *         Attributes =
 *         {
 *             { "First", "examplevalue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iot.NewThing(ctx, "example", &iot.ThingArgs{
 * 			Name: pulumi.String("example"),
 * 			Attributes: pulumi.StringMap{
 * 				"First": pulumi.String("examplevalue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.Thing;
 * import com.pulumi.aws.iot.ThingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Thing("example", ThingArgs.builder()
 *             .name("example")
 *             .attributes(Map.of("First", "examplevalue"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iot:Thing
 *     properties:
 *       name: example
 *       attributes:
 *         First: examplevalue
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IOT Things using the name. For example:
 * ```sh
 * $ pulumi import aws:iot/thing:Thing example example
 * ```
 */
public class Thing internal constructor(
    override val javaResource: com.pulumi.aws.iot.Thing,
) : KotlinCustomResource(javaResource, ThingMapper) {
    /**
     * The ARN of the thing.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Map of attributes of the thing.
     */
    public val attributes: Output<Map<String, String>>?
        get() = javaResource.attributes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The default client ID.
     */
    public val defaultClientId: Output<String>
        get() = javaResource.defaultClientId().applyValue({ args0 -> args0 })

    /**
     * The name of the thing.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The thing type name.
     */
    public val thingTypeName: Output<String>?
        get() = javaResource.thingTypeName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The current version of the thing record in the registry.
     */
    public val version: Output<Int>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object ThingMapper : ResourceMapper<Thing> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iot.Thing::class == javaResource::class

    override fun map(javaResource: Resource): Thing = Thing(javaResource as com.pulumi.aws.iot.Thing)
}

/**
 * @see [Thing].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Thing].
 */
public suspend fun thing(name: String, block: suspend ThingResourceBuilder.() -> Unit): Thing {
    val builder = ThingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Thing].
 * @param name The _unique_ name of the resulting resource.
 */
public fun thing(name: String): Thing {
    val builder = ThingResourceBuilder()
    builder.name(name)
    return builder.build()
}
