@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.ThingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates and manages an AWS IoT Thing.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.iot.Thing("example", {
 *     name: "example",
 *     attributes: {
 *         First: "examplevalue",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.iot.Thing("example",
 *     name="example",
 *     attributes={
 *         "First": "examplevalue",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Iot.Thing("example", new()
 *     {
 *         Name = "example",
 *         Attributes =
 *         {
 *             { "First", "examplevalue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iot.NewThing(ctx, "example", &iot.ThingArgs{
 * 			Name: pulumi.String("example"),
 * 			Attributes: pulumi.StringMap{
 * 				"First": pulumi.String("examplevalue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.Thing;
 * import com.pulumi.aws.iot.ThingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Thing("example", ThingArgs.builder()
 *             .name("example")
 *             .attributes(Map.of("First", "examplevalue"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iot:Thing
 *     properties:
 *       name: example
 *       attributes:
 *         First: examplevalue
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IOT Things using the name. For example:
 * ```sh
 * $ pulumi import aws:iot/thing:Thing example example
 * ```
 * @property attributes Map of attributes of the thing.
 * @property name The name of the thing.
 * @property thingTypeName The thing type name.
 */
public data class ThingArgs(
    public val attributes: Output<Map<String, String>>? = null,
    public val name: Output<String>? = null,
    public val thingTypeName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.ThingArgs> {
    override fun toJava(): com.pulumi.aws.iot.ThingArgs = com.pulumi.aws.iot.ThingArgs.builder()
        .attributes(
            attributes?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        )
        .name(name?.applyValue({ args0 -> args0 }))
        .thingTypeName(thingTypeName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ThingArgs].
 */
@PulumiTagMarker
public class ThingArgsBuilder internal constructor() {
    private var attributes: Output<Map<String, String>>? = null

    private var name: Output<String>? = null

    private var thingTypeName: Output<String>? = null

    /**
     * @param value Map of attributes of the thing.
     */
    @JvmName("wwnfefvhjciggygb")
    public suspend fun attributes(`value`: Output<Map<String, String>>) {
        this.attributes = value
    }

    /**
     * @param value The name of the thing.
     */
    @JvmName("uoyuaxjyyrxoreyp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The thing type name.
     */
    @JvmName("damtvmaedboplixk")
    public suspend fun thingTypeName(`value`: Output<String>) {
        this.thingTypeName = value
    }

    /**
     * @param value Map of attributes of the thing.
     */
    @JvmName("ncnbrgiuhgcgiuqy")
    public suspend fun attributes(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param values Map of attributes of the thing.
     */
    @JvmName("ldohccyovhhsnwdh")
    public fun attributes(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param value The name of the thing.
     */
    @JvmName("dwtpuroirdbufker")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The thing type name.
     */
    @JvmName("wjwrlamxubtassqg")
    public suspend fun thingTypeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thingTypeName = mapped
    }

    internal fun build(): ThingArgs = ThingArgs(
        attributes = attributes,
        name = name,
        thingTypeName = thingTypeName,
    )
}
