@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.ThingGroupArgs.builder
import com.pulumi.aws.iot.kotlin.inputs.ThingGroupPropertiesArgs
import com.pulumi.aws.iot.kotlin.inputs.ThingGroupPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an AWS IoT Thing Group.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const parent = new aws.iot.ThingGroup("parent", {name: "parent"});
 * const example = new aws.iot.ThingGroup("example", {
 *     name: "example",
 *     parentGroupName: parent.name,
 *     properties: {
 *         attributePayload: {
 *             attributes: {
 *                 One: "11111",
 *                 Two: "TwoTwo",
 *             },
 *         },
 *         description: "This is my thing group",
 *     },
 *     tags: {
 *         managed: "true",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * parent = aws.iot.ThingGroup("parent", name="parent")
 * example = aws.iot.ThingGroup("example",
 *     name="example",
 *     parent_group_name=parent.name,
 *     properties={
 *         "attribute_payload": {
 *             "attributes": {
 *                 "one": "11111",
 *                 "two": "TwoTwo",
 *             },
 *         },
 *         "description": "This is my thing group",
 *     },
 *     tags={
 *         "managed": "true",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var parent = new Aws.Iot.ThingGroup("parent", new()
 *     {
 *         Name = "parent",
 *     });
 *     var example = new Aws.Iot.ThingGroup("example", new()
 *     {
 *         Name = "example",
 *         ParentGroupName = parent.Name,
 *         Properties = new Aws.Iot.Inputs.ThingGroupPropertiesArgs
 *         {
 *             AttributePayload = new Aws.Iot.Inputs.ThingGroupPropertiesAttributePayloadArgs
 *             {
 *                 Attributes =
 *                 {
 *                     { "One", "11111" },
 *                     { "Two", "TwoTwo" },
 *                 },
 *             },
 *             Description = "This is my thing group",
 *         },
 *         Tags =
 *         {
 *             { "managed", "true" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		parent, err := iot.NewThingGroup(ctx, "parent", &iot.ThingGroupArgs{
 * 			Name: pulumi.String("parent"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iot.NewThingGroup(ctx, "example", &iot.ThingGroupArgs{
 * 			Name:            pulumi.String("example"),
 * 			ParentGroupName: parent.Name,
 * 			Properties: &iot.ThingGroupPropertiesArgs{
 * 				AttributePayload: &iot.ThingGroupPropertiesAttributePayloadArgs{
 * 					Attributes: pulumi.StringMap{
 * 						"One": pulumi.String("11111"),
 * 						"Two": pulumi.String("TwoTwo"),
 * 					},
 * 				},
 * 				Description: pulumi.String("This is my thing group"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"managed": pulumi.String("true"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.ThingGroup;
 * import com.pulumi.aws.iot.ThingGroupArgs;
 * import com.pulumi.aws.iot.inputs.ThingGroupPropertiesArgs;
 * import com.pulumi.aws.iot.inputs.ThingGroupPropertiesAttributePayloadArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var parent = new ThingGroup("parent", ThingGroupArgs.builder()
 *             .name("parent")
 *             .build());
 *         var example = new ThingGroup("example", ThingGroupArgs.builder()
 *             .name("example")
 *             .parentGroupName(parent.name())
 *             .properties(ThingGroupPropertiesArgs.builder()
 *                 .attributePayload(ThingGroupPropertiesAttributePayloadArgs.builder()
 *                     .attributes(Map.ofEntries(
 *                         Map.entry("One", "11111"),
 *                         Map.entry("Two", "TwoTwo")
 *                     ))
 *                     .build())
 *                 .description("This is my thing group")
 *                 .build())
 *             .tags(Map.of("managed", "true"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   parent:
 *     type: aws:iot:ThingGroup
 *     properties:
 *       name: parent
 *   example:
 *     type: aws:iot:ThingGroup
 *     properties:
 *       name: example
 *       parentGroupName: ${parent.name}
 *       properties:
 *         attributePayload:
 *           attributes:
 *             One: '11111'
 *             Two: TwoTwo
 *         description: This is my thing group
 *       tags:
 *         managed: 'true'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IoT Things Groups using the name. For example:
 * ```sh
 * $ pulumi import aws:iot/thingGroup:ThingGroup example example
 * ```
 * @property name The name of the Thing Group.
 * @property parentGroupName The name of the parent Thing Group.
 * @property properties The Thing Group properties. Defined below.
 * @property tags Key-value mapping of resource tags
 */
public data class ThingGroupArgs(
    public val name: Output<String>? = null,
    public val parentGroupName: Output<String>? = null,
    public val properties: Output<ThingGroupPropertiesArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.ThingGroupArgs> {
    override fun toJava(): com.pulumi.aws.iot.ThingGroupArgs =
        com.pulumi.aws.iot.ThingGroupArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .parentGroupName(parentGroupName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ThingGroupArgs].
 */
@PulumiTagMarker
public class ThingGroupArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parentGroupName: Output<String>? = null

    private var properties: Output<ThingGroupPropertiesArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the Thing Group.
     */
    @JvmName("mdvuaonjcnoibnrb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the parent Thing Group.
     */
    @JvmName("iwlkaerwwxoxhpmp")
    public suspend fun parentGroupName(`value`: Output<String>) {
        this.parentGroupName = value
    }

    /**
     * @param value The Thing Group properties. Defined below.
     */
    @JvmName("xdtupyjksqyynwcc")
    public suspend fun properties(`value`: Output<ThingGroupPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Key-value mapping of resource tags
     */
    @JvmName("ikbnqooojldhbggb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the Thing Group.
     */
    @JvmName("ojftkrnfqaiyybau")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the parent Thing Group.
     */
    @JvmName("trvorvimbtmgirqf")
    public suspend fun parentGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentGroupName = mapped
    }

    /**
     * @param value The Thing Group properties. Defined below.
     */
    @JvmName("yqfuwuvyuhvwnejp")
    public suspend fun properties(`value`: ThingGroupPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The Thing Group properties. Defined below.
     */
    @JvmName("lvxipuueqmqjmpta")
    public suspend fun properties(argument: suspend ThingGroupPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ThingGroupPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Key-value mapping of resource tags
     */
    @JvmName("bcusdxqfxhqpvhiq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags
     */
    @JvmName("sxusqcuaboqftpss")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ThingGroupArgs = ThingGroupArgs(
        name = name,
        parentGroupName = parentGroupName,
        properties = properties,
        tags = tags,
    )
}
