@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ThingGroupMembership].
 */
@PulumiTagMarker
public class ThingGroupMembershipResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ThingGroupMembershipArgs = ThingGroupMembershipArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ThingGroupMembershipArgsBuilder.() -> Unit) {
        val builder = ThingGroupMembershipArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ThingGroupMembership {
        val builtJavaResource = com.pulumi.aws.iot.ThingGroupMembership(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ThingGroupMembership(builtJavaResource)
    }
}

/**
 * Adds an IoT Thing to an IoT Thing Group.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.iot.ThingGroupMembership("example", {
 *     thingName: "example-thing",
 *     thingGroupName: "example-group",
 *     overrideDynamicGroup: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.iot.ThingGroupMembership("example",
 *     thing_name="example-thing",
 *     thing_group_name="example-group",
 *     override_dynamic_group=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Iot.ThingGroupMembership("example", new()
 *     {
 *         ThingName = "example-thing",
 *         ThingGroupName = "example-group",
 *         OverrideDynamicGroup = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iot.NewThingGroupMembership(ctx, "example", &iot.ThingGroupMembershipArgs{
 * 			ThingName:            pulumi.String("example-thing"),
 * 			ThingGroupName:       pulumi.String("example-group"),
 * 			OverrideDynamicGroup: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.ThingGroupMembership;
 * import com.pulumi.aws.iot.ThingGroupMembershipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ThingGroupMembership("example", ThingGroupMembershipArgs.builder()
 *             .thingName("example-thing")
 *             .thingGroupName("example-group")
 *             .overrideDynamicGroup(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iot:ThingGroupMembership
 *     properties:
 *       thingName: example-thing
 *       thingGroupName: example-group
 *       overrideDynamicGroup: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IoT Thing Group Membership using the thing group name and thing name. For example:
 * ```sh
 * $ pulumi import aws:iot/thingGroupMembership:ThingGroupMembership example thing_group_name/thing_name
 * ```
 */
public class ThingGroupMembership internal constructor(
    override val javaResource: com.pulumi.aws.iot.ThingGroupMembership,
) : KotlinCustomResource(javaResource, ThingGroupMembershipMapper) {
    /**
     * Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group removes the thing from the last dynamic group.
     */
    public val overrideDynamicGroup: Output<Boolean>?
        get() = javaResource.overrideDynamicGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the group to which you are adding a thing.
     */
    public val thingGroupName: Output<String>
        get() = javaResource.thingGroupName().applyValue({ args0 -> args0 })

    /**
     * The name of the thing to add to a group.
     */
    public val thingName: Output<String>
        get() = javaResource.thingName().applyValue({ args0 -> args0 })
}

public object ThingGroupMembershipMapper : ResourceMapper<ThingGroupMembership> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iot.ThingGroupMembership::class == javaResource::class

    override fun map(javaResource: Resource): ThingGroupMembership = ThingGroupMembership(
        javaResource
            as com.pulumi.aws.iot.ThingGroupMembership,
    )
}

/**
 * @see [ThingGroupMembership].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ThingGroupMembership].
 */
public suspend fun thingGroupMembership(
    name: String,
    block: suspend ThingGroupMembershipResourceBuilder.() -> Unit,
): ThingGroupMembership {
    val builder = ThingGroupMembershipResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ThingGroupMembership].
 * @param name The _unique_ name of the resulting resource.
 */
public fun thingGroupMembership(name: String): ThingGroupMembership {
    val builder = ThingGroupMembershipResourceBuilder()
    builder.name(name)
    return builder.build()
}
