@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.ThingGroupMembershipArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Adds an IoT Thing to an IoT Thing Group.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.iot.ThingGroupMembership("example", {
 *     thingName: "example-thing",
 *     thingGroupName: "example-group",
 *     overrideDynamicGroup: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.iot.ThingGroupMembership("example",
 *     thing_name="example-thing",
 *     thing_group_name="example-group",
 *     override_dynamic_group=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Iot.ThingGroupMembership("example", new()
 *     {
 *         ThingName = "example-thing",
 *         ThingGroupName = "example-group",
 *         OverrideDynamicGroup = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iot.NewThingGroupMembership(ctx, "example", &iot.ThingGroupMembershipArgs{
 * 			ThingName:            pulumi.String("example-thing"),
 * 			ThingGroupName:       pulumi.String("example-group"),
 * 			OverrideDynamicGroup: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.ThingGroupMembership;
 * import com.pulumi.aws.iot.ThingGroupMembershipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ThingGroupMembership("example", ThingGroupMembershipArgs.builder()
 *             .thingName("example-thing")
 *             .thingGroupName("example-group")
 *             .overrideDynamicGroup(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iot:ThingGroupMembership
 *     properties:
 *       thingName: example-thing
 *       thingGroupName: example-group
 *       overrideDynamicGroup: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IoT Thing Group Membership using the thing group name and thing name. For example:
 * ```sh
 * $ pulumi import aws:iot/thingGroupMembership:ThingGroupMembership example thing_group_name/thing_name
 * ```
 * @property overrideDynamicGroup Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group removes the thing from the last dynamic group.
 * @property thingGroupName The name of the group to which you are adding a thing.
 * @property thingName The name of the thing to add to a group.
 */
public data class ThingGroupMembershipArgs(
    public val overrideDynamicGroup: Output<Boolean>? = null,
    public val thingGroupName: Output<String>? = null,
    public val thingName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.ThingGroupMembershipArgs> {
    override fun toJava(): com.pulumi.aws.iot.ThingGroupMembershipArgs =
        com.pulumi.aws.iot.ThingGroupMembershipArgs.builder()
            .overrideDynamicGroup(overrideDynamicGroup?.applyValue({ args0 -> args0 }))
            .thingGroupName(thingGroupName?.applyValue({ args0 -> args0 }))
            .thingName(thingName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ThingGroupMembershipArgs].
 */
@PulumiTagMarker
public class ThingGroupMembershipArgsBuilder internal constructor() {
    private var overrideDynamicGroup: Output<Boolean>? = null

    private var thingGroupName: Output<String>? = null

    private var thingName: Output<String>? = null

    /**
     * @param value Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group removes the thing from the last dynamic group.
     */
    @JvmName("dknkpspvgqbfjnyi")
    public suspend fun overrideDynamicGroup(`value`: Output<Boolean>) {
        this.overrideDynamicGroup = value
    }

    /**
     * @param value The name of the group to which you are adding a thing.
     */
    @JvmName("ywnlidrfdqvgrahn")
    public suspend fun thingGroupName(`value`: Output<String>) {
        this.thingGroupName = value
    }

    /**
     * @param value The name of the thing to add to a group.
     */
    @JvmName("juqprpsfedjfoskx")
    public suspend fun thingName(`value`: Output<String>) {
        this.thingName = value
    }

    /**
     * @param value Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group removes the thing from the last dynamic group.
     */
    @JvmName("nsgwcygnvwppqxih")
    public suspend fun overrideDynamicGroup(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overrideDynamicGroup = mapped
    }

    /**
     * @param value The name of the group to which you are adding a thing.
     */
    @JvmName("ewgwvwwgjhgoueem")
    public suspend fun thingGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thingGroupName = mapped
    }

    /**
     * @param value The name of the thing to add to a group.
     */
    @JvmName("hrqkctbsjvehneuo")
    public suspend fun thingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thingName = mapped
    }

    internal fun build(): ThingGroupMembershipArgs = ThingGroupMembershipArgs(
        overrideDynamicGroup = overrideDynamicGroup,
        thingGroupName = thingGroupName,
        thingName = thingName,
    )
}
