@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ThingPrincipalAttachment].
 */
@PulumiTagMarker
public class ThingPrincipalAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ThingPrincipalAttachmentArgs = ThingPrincipalAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ThingPrincipalAttachmentArgsBuilder.() -> Unit) {
        val builder = ThingPrincipalAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ThingPrincipalAttachment {
        val builtJavaResource = com.pulumi.aws.iot.ThingPrincipalAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ThingPrincipalAttachment(builtJavaResource)
    }
}

/**
 * Attaches Principal to AWS IoT Thing.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = new aws.iot.Thing("example", {name: "example"});
 * const cert = new aws.iot.Certificate("cert", {
 *     csr: std.file({
 *         input: "csr.pem",
 *     }).then(invoke => invoke.result),
 *     active: true,
 * });
 * const att = new aws.iot.ThingPrincipalAttachment("att", {
 *     principal: cert.arn,
 *     thing: example.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.iot.Thing("example", name="example")
 * cert = aws.iot.Certificate("cert",
 *     csr=std.file(input="csr.pem").result,
 *     active=True)
 * att = aws.iot.ThingPrincipalAttachment("att",
 *     principal=cert.arn,
 *     thing=example.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Iot.Thing("example", new()
 *     {
 *         Name = "example",
 *     });
 *     var cert = new Aws.Iot.Certificate("cert", new()
 *     {
 *         Csr = Std.File.Invoke(new()
 *         {
 *             Input = "csr.pem",
 *         }).Apply(invoke => invoke.Result),
 *         Active = true,
 *     });
 *     var att = new Aws.Iot.ThingPrincipalAttachment("att", new()
 *     {
 *         Principal = cert.Arn,
 *         Thing = example.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := iot.NewThing(ctx, "example", &iot.ThingArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "csr.pem",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		cert, err := iot.NewCertificate(ctx, "cert", &iot.CertificateArgs{
 * 			Csr:    pulumi.String(invokeFile.Result),
 * 			Active: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iot.NewThingPrincipalAttachment(ctx, "att", &iot.ThingPrincipalAttachmentArgs{
 * 			Principal: cert.Arn,
 * 			Thing:     example.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.Thing;
 * import com.pulumi.aws.iot.ThingArgs;
 * import com.pulumi.aws.iot.Certificate;
 * import com.pulumi.aws.iot.CertificateArgs;
 * import com.pulumi.aws.iot.ThingPrincipalAttachment;
 * import com.pulumi.aws.iot.ThingPrincipalAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Thing("example", ThingArgs.builder()
 *             .name("example")
 *             .build());
 *         var cert = new Certificate("cert", CertificateArgs.builder()
 *             .csr(StdFunctions.file(FileArgs.builder()
 *                 .input("csr.pem")
 *                 .build()).result())
 *             .active(true)
 *             .build());
 *         var att = new ThingPrincipalAttachment("att", ThingPrincipalAttachmentArgs.builder()
 *             .principal(cert.arn())
 *             .thing(example.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iot:Thing
 *     properties:
 *       name: example
 *   cert:
 *     type: aws:iot:Certificate
 *     properties:
 *       csr:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: csr.pem
 *           Return: result
 *       active: true
 *   att:
 *     type: aws:iot:ThingPrincipalAttachment
 *     properties:
 *       principal: ${cert.arn}
 *       thing: ${example.name}
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class ThingPrincipalAttachment internal constructor(
    override val javaResource: com.pulumi.aws.iot.ThingPrincipalAttachment,
) : KotlinCustomResource(javaResource, ThingPrincipalAttachmentMapper) {
    /**
     * The AWS IoT Certificate ARN or Amazon Cognito Identity ID.
     */
    public val principal: Output<String>
        get() = javaResource.principal().applyValue({ args0 -> args0 })

    /**
     * The name of the thing.
     */
    public val thing: Output<String>
        get() = javaResource.thing().applyValue({ args0 -> args0 })
}

public object ThingPrincipalAttachmentMapper : ResourceMapper<ThingPrincipalAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iot.ThingPrincipalAttachment::class == javaResource::class

    override fun map(javaResource: Resource): ThingPrincipalAttachment =
        ThingPrincipalAttachment(javaResource as com.pulumi.aws.iot.ThingPrincipalAttachment)
}

/**
 * @see [ThingPrincipalAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ThingPrincipalAttachment].
 */
public suspend fun thingPrincipalAttachment(
    name: String,
    block: suspend ThingPrincipalAttachmentResourceBuilder.() -> Unit,
): ThingPrincipalAttachment {
    val builder = ThingPrincipalAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ThingPrincipalAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun thingPrincipalAttachment(name: String): ThingPrincipalAttachment {
    val builder = ThingPrincipalAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
