@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.ThingPrincipalAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Attaches Principal to AWS IoT Thing.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = new aws.iot.Thing("example", {name: "example"});
 * const cert = new aws.iot.Certificate("cert", {
 *     csr: std.file({
 *         input: "csr.pem",
 *     }).then(invoke => invoke.result),
 *     active: true,
 * });
 * const att = new aws.iot.ThingPrincipalAttachment("att", {
 *     principal: cert.arn,
 *     thing: example.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.iot.Thing("example", name="example")
 * cert = aws.iot.Certificate("cert",
 *     csr=std.file(input="csr.pem").result,
 *     active=True)
 * att = aws.iot.ThingPrincipalAttachment("att",
 *     principal=cert.arn,
 *     thing=example.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Iot.Thing("example", new()
 *     {
 *         Name = "example",
 *     });
 *     var cert = new Aws.Iot.Certificate("cert", new()
 *     {
 *         Csr = Std.File.Invoke(new()
 *         {
 *             Input = "csr.pem",
 *         }).Apply(invoke => invoke.Result),
 *         Active = true,
 *     });
 *     var att = new Aws.Iot.ThingPrincipalAttachment("att", new()
 *     {
 *         Principal = cert.Arn,
 *         Thing = example.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := iot.NewThing(ctx, "example", &iot.ThingArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "csr.pem",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		cert, err := iot.NewCertificate(ctx, "cert", &iot.CertificateArgs{
 * 			Csr:    pulumi.String(invokeFile.Result),
 * 			Active: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iot.NewThingPrincipalAttachment(ctx, "att", &iot.ThingPrincipalAttachmentArgs{
 * 			Principal: cert.Arn,
 * 			Thing:     example.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.Thing;
 * import com.pulumi.aws.iot.ThingArgs;
 * import com.pulumi.aws.iot.Certificate;
 * import com.pulumi.aws.iot.CertificateArgs;
 * import com.pulumi.aws.iot.ThingPrincipalAttachment;
 * import com.pulumi.aws.iot.ThingPrincipalAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Thing("example", ThingArgs.builder()
 *             .name("example")
 *             .build());
 *         var cert = new Certificate("cert", CertificateArgs.builder()
 *             .csr(StdFunctions.file(FileArgs.builder()
 *                 .input("csr.pem")
 *                 .build()).result())
 *             .active(true)
 *             .build());
 *         var att = new ThingPrincipalAttachment("att", ThingPrincipalAttachmentArgs.builder()
 *             .principal(cert.arn())
 *             .thing(example.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iot:Thing
 *     properties:
 *       name: example
 *   cert:
 *     type: aws:iot:Certificate
 *     properties:
 *       csr:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: csr.pem
 *           Return: result
 *       active: true
 *   att:
 *     type: aws:iot:ThingPrincipalAttachment
 *     properties:
 *       principal: ${cert.arn}
 *       thing: ${example.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * @property principal The AWS IoT Certificate ARN or Amazon Cognito Identity ID.
 * @property thing The name of the thing.
 */
public data class ThingPrincipalAttachmentArgs(
    public val principal: Output<String>? = null,
    public val thing: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.ThingPrincipalAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.iot.ThingPrincipalAttachmentArgs =
        com.pulumi.aws.iot.ThingPrincipalAttachmentArgs.builder()
            .principal(principal?.applyValue({ args0 -> args0 }))
            .thing(thing?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ThingPrincipalAttachmentArgs].
 */
@PulumiTagMarker
public class ThingPrincipalAttachmentArgsBuilder internal constructor() {
    private var principal: Output<String>? = null

    private var thing: Output<String>? = null

    /**
     * @param value The AWS IoT Certificate ARN or Amazon Cognito Identity ID.
     */
    @JvmName("erbiqqnckchttcif")
    public suspend fun principal(`value`: Output<String>) {
        this.principal = value
    }

    /**
     * @param value The name of the thing.
     */
    @JvmName("pxbfoowewdmqojbp")
    public suspend fun thing(`value`: Output<String>) {
        this.thing = value
    }

    /**
     * @param value The AWS IoT Certificate ARN or Amazon Cognito Identity ID.
     */
    @JvmName("dupfnbnnvssumwdu")
    public suspend fun principal(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principal = mapped
    }

    /**
     * @param value The name of the thing.
     */
    @JvmName("jmyeuyuoxgrksjgs")
    public suspend fun thing(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thing = mapped
    }

    internal fun build(): ThingPrincipalAttachmentArgs = ThingPrincipalAttachmentArgs(
        principal = principal,
        thing = thing,
    )
}
