@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.ThingTypeArgs.builder
import com.pulumi.aws.iot.kotlin.inputs.ThingTypePropertiesArgs
import com.pulumi.aws.iot.kotlin.inputs.ThingTypePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates and manages an AWS IoT Thing Type.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const foo = new aws.iot.ThingType("foo", {name: "my_iot_thing"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * foo = aws.iot.ThingType("foo", name="my_iot_thing")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new Aws.Iot.ThingType("foo", new()
 *     {
 *         Name = "my_iot_thing",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iot.NewThingType(ctx, "foo", &iot.ThingTypeArgs{
 * 			Name: pulumi.String("my_iot_thing"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.ThingType;
 * import com.pulumi.aws.iot.ThingTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new ThingType("foo", ThingTypeArgs.builder()
 *             .name("my_iot_thing")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: aws:iot:ThingType
 *     properties:
 *       name: my_iot_thing
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IOT Thing Types using the name. For example:
 * ```sh
 * $ pulumi import aws:iot/thingType:ThingType example example
 * ```
 * @property deprecated Whether the thing type is deprecated. If true, no new things could be associated with this type.
 * @property name The name of the thing type.
 * @property properties , Configuration block that can contain the following properties of the thing type:
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
 */
public data class ThingTypeArgs(
    public val deprecated: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val properties: Output<ThingTypePropertiesArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.ThingTypeArgs> {
    override fun toJava(): com.pulumi.aws.iot.ThingTypeArgs =
        com.pulumi.aws.iot.ThingTypeArgs.builder()
            .deprecated(deprecated?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ThingTypeArgs].
 */
@PulumiTagMarker
public class ThingTypeArgsBuilder internal constructor() {
    private var deprecated: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var properties: Output<ThingTypePropertiesArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Whether the thing type is deprecated. If true, no new things could be associated with this type.
     */
    @JvmName("jykhcpefggvqftas")
    public suspend fun deprecated(`value`: Output<Boolean>) {
        this.deprecated = value
    }

    /**
     * @param value The name of the thing type.
     */
    @JvmName("qxvglxlpttckimro")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value , Configuration block that can contain the following properties of the thing type:
     */
    @JvmName("actuwmqpnheisaeq")
    public suspend fun properties(`value`: Output<ThingTypePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("ykwybmyvasomiwpt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Whether the thing type is deprecated. If true, no new things could be associated with this type.
     */
    @JvmName("axbfycqysbwclgsb")
    public suspend fun deprecated(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deprecated = mapped
    }

    /**
     * @param value The name of the thing type.
     */
    @JvmName("amgjcdfatllyajpf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value , Configuration block that can contain the following properties of the thing type:
     */
    @JvmName("epxvmnyeyqnqdojf")
    public suspend fun properties(`value`: ThingTypePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument , Configuration block that can contain the following properties of the thing type:
     */
    @JvmName("kgvwnjatxtlmokfu")
    public suspend fun properties(argument: suspend ThingTypePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ThingTypePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("jvdlegjjetcwgntv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("gplcigiaqslmqwgi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ThingTypeArgs = ThingTypeArgs(
        deprecated = deprecated,
        name = name,
        properties = properties,
        tags = tags,
    )
}
