@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.TopicRuleArgs.builder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleCloudwatchAlarmArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleCloudwatchAlarmArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleCloudwatchLogArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleCloudwatchLogArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleCloudwatchMetricArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleCloudwatchMetricArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleDynamodbArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleDynamodbArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleDynamodbv2Args
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleDynamodbv2ArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleElasticsearchArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleElasticsearchArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleErrorActionArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleErrorActionArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleFirehoseArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleFirehoseArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleHttpArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleHttpArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleIotAnalyticArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleIotAnalyticArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleIotEventArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleIotEventArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleKafkaArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleKafkaArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleKinesisArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleKinesisArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleLambdaArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleLambdaArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleRepublishArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleRepublishArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleS3Args
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleS3ArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleSnsArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleSnsArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleSqsArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleSqsArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleStepFunctionArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleStepFunctionArgsBuilder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleTimestreamArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleTimestreamArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates and manages an AWS IoT topic rule.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const mytopic = new aws.sns.Topic("mytopic", {name: "mytopic"});
 * const myerrortopic = new aws.sns.Topic("myerrortopic", {name: "myerrortopic"});
 * const rule = new aws.iot.TopicRule("rule", {
 *     name: "MyRule",
 *     description: "Example rule",
 *     enabled: true,
 *     sql: "SELECT * FROM 'topic/test'",
 *     sqlVersion: "2016-03-23",
 *     sns: [{
 *         messageFormat: "RAW",
 *         roleArn: role.arn,
 *         targetArn: mytopic.arn,
 *     }],
 *     errorAction: {
 *         sns: {
 *             messageFormat: "RAW",
 *             roleArn: role.arn,
 *             targetArn: myerrortopic.arn,
 *         },
 *     },
 * });
 * const assumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["iot&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["sts:AssumeRole"],
 *     }],
 * });
 * const myrole = new aws.iam.Role("myrole", {
 *     name: "myrole",
 *     assumeRolePolicy: assumeRole.then(assumeRole => assumeRole.json),
 * });
 * const mypolicy = mytopic.arn.apply(arn => aws.iam.getPolicyDocumentOutput({
 *     statements: [{
 *         effect: "Allow",
 *         actions: ["sns:Publish"],
 *         resources: [arn],
 *     }],
 * }));
 * const mypolicyRolePolicy = new aws.iam.RolePolicy("mypolicy", {
 *     name: "mypolicy",
 *     role: myrole.id,
 *     policy: mypolicy.apply(mypolicy => mypolicy.json),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * mytopic = aws.sns.Topic("mytopic", name="mytopic")
 * myerrortopic = aws.sns.Topic("myerrortopic", name="myerrortopic")
 * rule = aws.iot.TopicRule("rule",
 *     name="MyRule",
 *     description="Example rule",
 *     enabled=True,
 *     sql="SELECT * FROM 'topic/test'",
 *     sql_version="2016-03-23",
 *     sns=[{
 *         "message_format": "RAW",
 *         "role_arn": role["arn"],
 *         "target_arn": mytopic.arn,
 *     }],
 *     error_action={
 *         "sns": {
 *             "message_format": "RAW",
 *             "role_arn": role["arn"],
 *             "target_arn": myerrortopic.arn,
 *         },
 *     })
 * assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["iot&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["sts:AssumeRole"],
 * }])
 * myrole = aws.iam.Role("myrole",
 *     name="myrole",
 *     assume_role_policy=assume_role.json)
 * mypolicy = mytopic.arn.apply(lambda arn: aws.iam.get_policy_document_output(statements=[{
 *     "effect": "Allow",
 *     "actions": ["sns:Publish"],
 *     "resources": [arn],
 * }]))
 * mypolicy_role_policy = aws.iam.RolePolicy("mypolicy",
 *     name="mypolicy",
 *     role=myrole.id,
 *     policy=mypolicy.json)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mytopic = new Aws.Sns.Topic("mytopic", new()
 *     {
 *         Name = "mytopic",
 *     });
 *     var myerrortopic = new Aws.Sns.Topic("myerrortopic", new()
 *     {
 *         Name = "myerrortopic",
 *     });
 *     var rule = new Aws.Iot.TopicRule("rule", new()
 *     {
 *         Name = "MyRule",
 *         Description = "Example rule",
 *         Enabled = true,
 *         Sql = "SELECT * FROM 'topic/test'",
 *         SqlVersion = "2016-03-23",
 *         Sns = new[]
 *         {
 *             new Aws.Iot.Inputs.TopicRuleSnsArgs
 *             {
 *                 MessageFormat = "RAW",
 *                 RoleArn = role.Arn,
 *                 TargetArn = mytopic.Arn,
 *             },
 *         },
 *         ErrorAction = new Aws.Iot.Inputs.TopicRuleErrorActionArgs
 *         {
 *             Sns = new Aws.Iot.Inputs.TopicRuleErrorActionSnsArgs
 *             {
 *                 MessageFormat = "RAW",
 *                 RoleArn = role.Arn,
 *                 TargetArn = myerrortopic.Arn,
 *             },
 *         },
 *     });
 *     var assumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "iot.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *             },
 *         },
 *     });
 *     var myrole = new Aws.Iam.Role("myrole", new()
 *     {
 *         Name = "myrole",
 *         AssumeRolePolicy = assumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var mypolicy = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "sns:Publish",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     mytopic.Arn,
 *                 },
 *             },
 *         },
 *     });
 *     var mypolicyRolePolicy = new Aws.Iam.RolePolicy("mypolicy", new()
 *     {
 *         Name = "mypolicy",
 *         Role = myrole.Id,
 *         Policy = mypolicy.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * mytopic, err := sns.NewTopic(ctx, "mytopic", &sns.TopicArgs{
 * Name: pulumi.String("mytopic"),
 * })
 * if err != nil {
 * return err
 * }
 * myerrortopic, err := sns.NewTopic(ctx, "myerrortopic", &sns.TopicArgs{
 * Name: pulumi.String("myerrortopic"),
 * })
 * if err != nil {
 * return err
 * }
 * _, err = iot.NewTopicRule(ctx, "rule", &iot.TopicRuleArgs{
 * Name: pulumi.String("MyRule"),
 * Description: pulumi.String("Example rule"),
 * Enabled: pulumi.Bool(true),
 * Sql: pulumi.String("SELECT * FROM 'topic/test'"),
 * SqlVersion: pulumi.String("2016-03-23"),
 * Sns: iot.TopicRuleSnsArray{
 * &iot.TopicRuleSnsArgs{
 * MessageFormat: pulumi.String("RAW"),
 * RoleArn: pulumi.Any(role.Arn),
 * TargetArn: mytopic.Arn,
 * },
 * },
 * ErrorAction: &iot.TopicRuleErrorActionArgs{
 * Sns: &iot.TopicRuleErrorActionSnsArgs{
 * MessageFormat: pulumi.String("RAW"),
 * RoleArn: pulumi.Any(role.Arn),
 * TargetArn: myerrortopic.Arn,
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * assumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * Statements: []iam.GetPolicyDocumentStatement{
 * {
 * Effect: pulumi.StringRef("Allow"),
 * Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * {
 * Type: "Service",
 * Identifiers: []string{
 * "iot.amazonaws.com",
 * },
 * },
 * },
 * Actions: []string{
 * "sts:AssumeRole",
 * },
 * },
 * },
 * }, nil);
 * if err != nil {
 * return err
 * }
 * myrole, err := iam.NewRole(ctx, "myrole", &iam.RoleArgs{
 * Name: pulumi.String("myrole"),
 * AssumeRolePolicy: pulumi.String(assumeRole.Json),
 * })
 * if err != nil {
 * return err
 * }
 * mypolicy := mytopic.Arn.ApplyT(func(arn string) (iam.GetPolicyDocumentResult, error) {
 * return iam.GetPolicyDocumentResult(interface{}(iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * Statements: []iam.GetPolicyDocumentStatement{
 * {
 * Effect: "Allow",
 * Actions: []string{
 * "sns:Publish",
 * },
 * Resources: interface{}{
 * arn,
 * },
 * },
 * },
 * }, nil))), nil
 * }).(iam.GetPolicyDocumentResultOutput)
 * _, err = iam.NewRolePolicy(ctx, "mypolicy", &iam.RolePolicyArgs{
 * Name: pulumi.String("mypolicy"),
 * Role: myrole.ID(),
 * Policy: pulumi.String(mypolicy.ApplyT(func(mypolicy iam.GetPolicyDocumentResult) (*string, error) {
 * return &mypolicy.Json, nil
 * }).(pulumi.StringPtrOutput)),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import com.pulumi.aws.iot.TopicRule;
 * import com.pulumi.aws.iot.TopicRuleArgs;
 * import com.pulumi.aws.iot.inputs.TopicRuleSnsArgs;
 * import com.pulumi.aws.iot.inputs.TopicRuleErrorActionArgs;
 * import com.pulumi.aws.iot.inputs.TopicRuleErrorActionSnsArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mytopic = new Topic("mytopic", TopicArgs.builder()
 *             .name("mytopic")
 *             .build());
 *         var myerrortopic = new Topic("myerrortopic", TopicArgs.builder()
 *             .name("myerrortopic")
 *             .build());
 *         var rule = new TopicRule("rule", TopicRuleArgs.builder()
 *             .name("MyRule")
 *             .description("Example rule")
 *             .enabled(true)
 *             .sql("SELECT * FROM 'topic/test'")
 *             .sqlVersion("2016-03-23")
 *             .sns(TopicRuleSnsArgs.builder()
 *                 .messageFormat("RAW")
 *                 .roleArn(role.arn())
 *                 .targetArn(mytopic.arn())
 *                 .build())
 *             .errorAction(TopicRuleErrorActionArgs.builder()
 *                 .sns(TopicRuleErrorActionSnsArgs.builder()
 *                     .messageFormat("RAW")
 *                     .roleArn(role.arn())
 *                     .targetArn(myerrortopic.arn())
 *                     .build())
 *                 .build())
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("iot.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var myrole = new Role("myrole", RoleArgs.builder()
 *             .name("myrole")
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var mypolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("sns:Publish")
 *                 .resources(mytopic.arn())
 *                 .build())
 *             .build());
 *         var mypolicyRolePolicy = new RolePolicy("mypolicyRolePolicy", RolePolicyArgs.builder()
 *             .name("mypolicy")
 *             .role(myrole.id())
 *             .policy(mypolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(mypolicy -> mypolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   rule:
 *     type: aws:iot:TopicRule
 *     properties:
 *       name: MyRule
 *       description: Example rule
 *       enabled: true
 *       sql: SELECT * FROM 'topic/test'
 *       sqlVersion: 2016-03-23
 *       sns:
 *         - messageFormat: RAW
 *           roleArn: ${role.arn}
 *           targetArn: ${mytopic.arn}
 *       errorAction:
 *         sns:
 *           messageFormat: RAW
 *           roleArn: ${role.arn}
 *           targetArn: ${myerrortopic.arn}
 *   mytopic:
 *     type: aws:sns:Topic
 *     properties:
 *       name: mytopic
 *   myerrortopic:
 *     type: aws:sns:Topic
 *     properties:
 *       name: myerrortopic
 *   myrole:
 *     type: aws:iam:Role
 *     properties:
 *       name: myrole
 *       assumeRolePolicy: ${assumeRole.json}
 *   mypolicyRolePolicy:
 *     type: aws:iam:RolePolicy
 *     name: mypolicy
 *     properties:
 *       name: mypolicy
 *       role: ${myrole.id}
 *       policy: ${mypolicy.json}
 * variables:
 *   assumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - iot.amazonaws.com
 *             actions:
 *               - sts:AssumeRole
 *   mypolicy:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             actions:
 *               - sns:Publish
 *             resources:
 *               - ${mytopic.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IoT Topic Rules using the `name`. For example:
 * ```sh
 * $ pulumi import aws:iot/topicRule:TopicRule rule <name>
 * ```
 * @property cloudwatchAlarms
 * @property cloudwatchLogs
 * @property cloudwatchMetrics
 * @property description The description of the rule.
 * @property dynamodbs
 * @property dynamodbv2s
 * @property elasticsearch
 * @property enabled Specifies whether the rule is enabled.
 * @property errorAction Configuration block with error action to be associated with the rule. See the documentation for `cloudwatch_alarm`, `cloudwatch_logs`, `cloudwatch_metric`, `dynamodb`, `dynamodbv2`, `elasticsearch`, `firehose`, `http`, `iot_analytics`, `iot_events`, `kafka`, `kinesis`, `lambda`, `republish`, `s3`, `sns`, `sqs`, `step_functions`, `timestream` configuration blocks for further configuration details.
 * @property firehoses
 * @property https
 * @property iotAnalytics
 * @property iotEvents
 * @property kafkas
 * @property kineses
 * @property lambdas
 * @property name The name of the rule.
 * @property republishes
 * @property s3
 * @property sns
 * @property sql The SQL statement used to query the topic. For more information, see AWS IoT SQL Reference (http://docs.aws.amazon.com/iot/latest/developerguide/iot-rules.html#aws-iot-sql-reference) in the AWS IoT Developer Guide.
 * @property sqlVersion The version of the SQL rules engine to use when evaluating the rule.
 * @property sqs
 * @property stepFunctions
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timestreams
 */
public data class TopicRuleArgs(
    public val cloudwatchAlarms: Output<List<TopicRuleCloudwatchAlarmArgs>>? = null,
    public val cloudwatchLogs: Output<List<TopicRuleCloudwatchLogArgs>>? = null,
    public val cloudwatchMetrics: Output<List<TopicRuleCloudwatchMetricArgs>>? = null,
    public val description: Output<String>? = null,
    public val dynamodbs: Output<List<TopicRuleDynamodbArgs>>? = null,
    public val dynamodbv2s: Output<List<TopicRuleDynamodbv2Args>>? = null,
    public val elasticsearch: Output<List<TopicRuleElasticsearchArgs>>? = null,
    public val enabled: Output<Boolean>? = null,
    public val errorAction: Output<TopicRuleErrorActionArgs>? = null,
    public val firehoses: Output<List<TopicRuleFirehoseArgs>>? = null,
    public val https: Output<List<TopicRuleHttpArgs>>? = null,
    public val iotAnalytics: Output<List<TopicRuleIotAnalyticArgs>>? = null,
    public val iotEvents: Output<List<TopicRuleIotEventArgs>>? = null,
    public val kafkas: Output<List<TopicRuleKafkaArgs>>? = null,
    public val kineses: Output<List<TopicRuleKinesisArgs>>? = null,
    public val lambdas: Output<List<TopicRuleLambdaArgs>>? = null,
    public val name: Output<String>? = null,
    public val republishes: Output<List<TopicRuleRepublishArgs>>? = null,
    public val s3: Output<List<TopicRuleS3Args>>? = null,
    public val sns: Output<List<TopicRuleSnsArgs>>? = null,
    public val sql: Output<String>? = null,
    public val sqlVersion: Output<String>? = null,
    public val sqs: Output<List<TopicRuleSqsArgs>>? = null,
    public val stepFunctions: Output<List<TopicRuleStepFunctionArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timestreams: Output<List<TopicRuleTimestreamArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.TopicRuleArgs> {
    override fun toJava(): com.pulumi.aws.iot.TopicRuleArgs =
        com.pulumi.aws.iot.TopicRuleArgs.builder()
            .cloudwatchAlarms(
                cloudwatchAlarms?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .cloudwatchLogs(
                cloudwatchLogs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .cloudwatchMetrics(
                cloudwatchMetrics?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .dynamodbs(
                dynamodbs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .dynamodbv2s(
                dynamodbv2s?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .elasticsearch(
                elasticsearch?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .errorAction(errorAction?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .firehoses(
                firehoses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .https(https?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .iotAnalytics(
                iotAnalytics?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .iotEvents(
                iotEvents?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .kafkas(kafkas?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .kineses(
                kineses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .lambdas(
                lambdas?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .republishes(
                republishes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .s3(s3?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .sns(sns?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .sql(sql?.applyValue({ args0 -> args0 }))
            .sqlVersion(sqlVersion?.applyValue({ args0 -> args0 }))
            .sqs(sqs?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .stepFunctions(
                stepFunctions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timestreams(
                timestreams?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TopicRuleArgs].
 */
@PulumiTagMarker
public class TopicRuleArgsBuilder internal constructor() {
    private var cloudwatchAlarms: Output<List<TopicRuleCloudwatchAlarmArgs>>? = null

    private var cloudwatchLogs: Output<List<TopicRuleCloudwatchLogArgs>>? = null

    private var cloudwatchMetrics: Output<List<TopicRuleCloudwatchMetricArgs>>? = null

    private var description: Output<String>? = null

    private var dynamodbs: Output<List<TopicRuleDynamodbArgs>>? = null

    private var dynamodbv2s: Output<List<TopicRuleDynamodbv2Args>>? = null

    private var elasticsearch: Output<List<TopicRuleElasticsearchArgs>>? = null

    private var enabled: Output<Boolean>? = null

    private var errorAction: Output<TopicRuleErrorActionArgs>? = null

    private var firehoses: Output<List<TopicRuleFirehoseArgs>>? = null

    private var https: Output<List<TopicRuleHttpArgs>>? = null

    private var iotAnalytics: Output<List<TopicRuleIotAnalyticArgs>>? = null

    private var iotEvents: Output<List<TopicRuleIotEventArgs>>? = null

    private var kafkas: Output<List<TopicRuleKafkaArgs>>? = null

    private var kineses: Output<List<TopicRuleKinesisArgs>>? = null

    private var lambdas: Output<List<TopicRuleLambdaArgs>>? = null

    private var name: Output<String>? = null

    private var republishes: Output<List<TopicRuleRepublishArgs>>? = null

    private var s3: Output<List<TopicRuleS3Args>>? = null

    private var sns: Output<List<TopicRuleSnsArgs>>? = null

    private var sql: Output<String>? = null

    private var sqlVersion: Output<String>? = null

    private var sqs: Output<List<TopicRuleSqsArgs>>? = null

    private var stepFunctions: Output<List<TopicRuleStepFunctionArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timestreams: Output<List<TopicRuleTimestreamArgs>>? = null

    /**
     * @param value
     */
    @JvmName("nlswyyriwspwywwe")
    public suspend fun cloudwatchAlarms(`value`: Output<List<TopicRuleCloudwatchAlarmArgs>>) {
        this.cloudwatchAlarms = value
    }

    @JvmName("owurjldpnknmwrfk")
    public suspend fun cloudwatchAlarms(vararg values: Output<TopicRuleCloudwatchAlarmArgs>) {
        this.cloudwatchAlarms = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("mubhiqkupbrrlcup")
    public suspend fun cloudwatchAlarms(values: List<Output<TopicRuleCloudwatchAlarmArgs>>) {
        this.cloudwatchAlarms = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("kspjxdgsvsutkuvf")
    public suspend fun cloudwatchLogs(`value`: Output<List<TopicRuleCloudwatchLogArgs>>) {
        this.cloudwatchLogs = value
    }

    @JvmName("mymlpdkdwaloqpkj")
    public suspend fun cloudwatchLogs(vararg values: Output<TopicRuleCloudwatchLogArgs>) {
        this.cloudwatchLogs = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("edrbkdllvjoeihjq")
    public suspend fun cloudwatchLogs(values: List<Output<TopicRuleCloudwatchLogArgs>>) {
        this.cloudwatchLogs = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("xtknlkuqhriaselk")
    public suspend fun cloudwatchMetrics(`value`: Output<List<TopicRuleCloudwatchMetricArgs>>) {
        this.cloudwatchMetrics = value
    }

    @JvmName("tisdvuifvqwuswym")
    public suspend fun cloudwatchMetrics(vararg values: Output<TopicRuleCloudwatchMetricArgs>) {
        this.cloudwatchMetrics = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("irupmfghubbrqgos")
    public suspend fun cloudwatchMetrics(values: List<Output<TopicRuleCloudwatchMetricArgs>>) {
        this.cloudwatchMetrics = Output.all(values)
    }

    /**
     * @param value The description of the rule.
     */
    @JvmName("fybxoehthplihefv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value
     */
    @JvmName("btxcdpfvuqvafebn")
    public suspend fun dynamodbs(`value`: Output<List<TopicRuleDynamodbArgs>>) {
        this.dynamodbs = value
    }

    @JvmName("bwdmgxkiehycxcsa")
    public suspend fun dynamodbs(vararg values: Output<TopicRuleDynamodbArgs>) {
        this.dynamodbs = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("wvjddeaiwsflpvoi")
    public suspend fun dynamodbs(values: List<Output<TopicRuleDynamodbArgs>>) {
        this.dynamodbs = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("kkbajvhfowuqjkol")
    public suspend fun dynamodbv2s(`value`: Output<List<TopicRuleDynamodbv2Args>>) {
        this.dynamodbv2s = value
    }

    @JvmName("chrdnxgishsbxsur")
    public suspend fun dynamodbv2s(vararg values: Output<TopicRuleDynamodbv2Args>) {
        this.dynamodbv2s = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("wulvcgenkcdjhiwe")
    public suspend fun dynamodbv2s(values: List<Output<TopicRuleDynamodbv2Args>>) {
        this.dynamodbv2s = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("eoihenocfflxhaoo")
    public suspend fun elasticsearch(`value`: Output<List<TopicRuleElasticsearchArgs>>) {
        this.elasticsearch = value
    }

    @JvmName("iljchainlencnrdt")
    public suspend fun elasticsearch(vararg values: Output<TopicRuleElasticsearchArgs>) {
        this.elasticsearch = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("xkgcbchkhgpashqg")
    public suspend fun elasticsearch(values: List<Output<TopicRuleElasticsearchArgs>>) {
        this.elasticsearch = Output.all(values)
    }

    /**
     * @param value Specifies whether the rule is enabled.
     */
    @JvmName("xvbvmlqopmwnsqnd")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Configuration block with error action to be associated with the rule. See the documentation for `cloudwatch_alarm`, `cloudwatch_logs`, `cloudwatch_metric`, `dynamodb`, `dynamodbv2`, `elasticsearch`, `firehose`, `http`, `iot_analytics`, `iot_events`, `kafka`, `kinesis`, `lambda`, `republish`, `s3`, `sns`, `sqs`, `step_functions`, `timestream` configuration blocks for further configuration details.
     */
    @JvmName("mitbekkpcqlpcske")
    public suspend fun errorAction(`value`: Output<TopicRuleErrorActionArgs>) {
        this.errorAction = value
    }

    /**
     * @param value
     */
    @JvmName("myykdeijvlnbxjhp")
    public suspend fun firehoses(`value`: Output<List<TopicRuleFirehoseArgs>>) {
        this.firehoses = value
    }

    @JvmName("vpdbstxqvhclktaj")
    public suspend fun firehoses(vararg values: Output<TopicRuleFirehoseArgs>) {
        this.firehoses = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("sdhwvlnmsresavvp")
    public suspend fun firehoses(values: List<Output<TopicRuleFirehoseArgs>>) {
        this.firehoses = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("jhktbvmujoiktwvx")
    public suspend fun https(`value`: Output<List<TopicRuleHttpArgs>>) {
        this.https = value
    }

    @JvmName("kyykypqcixfhpmdc")
    public suspend fun https(vararg values: Output<TopicRuleHttpArgs>) {
        this.https = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("fhsicdeyvovwxgye")
    public suspend fun https(values: List<Output<TopicRuleHttpArgs>>) {
        this.https = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("imgortrjverrabqx")
    public suspend fun iotAnalytics(`value`: Output<List<TopicRuleIotAnalyticArgs>>) {
        this.iotAnalytics = value
    }

    @JvmName("pqicvqfgaxybdmuw")
    public suspend fun iotAnalytics(vararg values: Output<TopicRuleIotAnalyticArgs>) {
        this.iotAnalytics = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("jbourmxojqwflerk")
    public suspend fun iotAnalytics(values: List<Output<TopicRuleIotAnalyticArgs>>) {
        this.iotAnalytics = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("botbruslwclncdom")
    public suspend fun iotEvents(`value`: Output<List<TopicRuleIotEventArgs>>) {
        this.iotEvents = value
    }

    @JvmName("npgnaxlisqjrljrm")
    public suspend fun iotEvents(vararg values: Output<TopicRuleIotEventArgs>) {
        this.iotEvents = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("kggaxhqheogprccy")
    public suspend fun iotEvents(values: List<Output<TopicRuleIotEventArgs>>) {
        this.iotEvents = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("escfhlihvxcidysf")
    public suspend fun kafkas(`value`: Output<List<TopicRuleKafkaArgs>>) {
        this.kafkas = value
    }

    @JvmName("ykjnpvoklrimpmxo")
    public suspend fun kafkas(vararg values: Output<TopicRuleKafkaArgs>) {
        this.kafkas = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("smerdxyhfnxveihe")
    public suspend fun kafkas(values: List<Output<TopicRuleKafkaArgs>>) {
        this.kafkas = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("tvpfrxlrwpwbqxve")
    public suspend fun kineses(`value`: Output<List<TopicRuleKinesisArgs>>) {
        this.kineses = value
    }

    @JvmName("natfejogjurkwufg")
    public suspend fun kineses(vararg values: Output<TopicRuleKinesisArgs>) {
        this.kineses = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("awqnhboeulaahxng")
    public suspend fun kineses(values: List<Output<TopicRuleKinesisArgs>>) {
        this.kineses = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("dpkaqsvpnqvtwmhb")
    public suspend fun lambdas(`value`: Output<List<TopicRuleLambdaArgs>>) {
        this.lambdas = value
    }

    @JvmName("pxxtulpfquoxyqxf")
    public suspend fun lambdas(vararg values: Output<TopicRuleLambdaArgs>) {
        this.lambdas = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("fgsbwaoetdxggcsy")
    public suspend fun lambdas(values: List<Output<TopicRuleLambdaArgs>>) {
        this.lambdas = Output.all(values)
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("oqevstojmjrmwffl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("eagjelnwuqnqlfqm")
    public suspend fun republishes(`value`: Output<List<TopicRuleRepublishArgs>>) {
        this.republishes = value
    }

    @JvmName("ijgquvgutdaaiybm")
    public suspend fun republishes(vararg values: Output<TopicRuleRepublishArgs>) {
        this.republishes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ktkahdgbthblyjre")
    public suspend fun republishes(values: List<Output<TopicRuleRepublishArgs>>) {
        this.republishes = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("xwnclhhscfddkwym")
    public suspend fun s3(`value`: Output<List<TopicRuleS3Args>>) {
        this.s3 = value
    }

    @JvmName("aafudcruwmltekrm")
    public suspend fun s3(vararg values: Output<TopicRuleS3Args>) {
        this.s3 = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("vjhmdgbjifdjgmnk")
    public suspend fun s3(values: List<Output<TopicRuleS3Args>>) {
        this.s3 = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("hvlwuybtlfsyrhsb")
    public suspend fun sns(`value`: Output<List<TopicRuleSnsArgs>>) {
        this.sns = value
    }

    @JvmName("oaebdlehlnpqnddk")
    public suspend fun sns(vararg values: Output<TopicRuleSnsArgs>) {
        this.sns = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("rjyejvdcilnhccmm")
    public suspend fun sns(values: List<Output<TopicRuleSnsArgs>>) {
        this.sns = Output.all(values)
    }

    /**
     * @param value The SQL statement used to query the topic. For more information, see AWS IoT SQL Reference (http://docs.aws.amazon.com/iot/latest/developerguide/iot-rules.html#aws-iot-sql-reference) in the AWS IoT Developer Guide.
     */
    @JvmName("hkrovxqfjlxpuomu")
    public suspend fun sql(`value`: Output<String>) {
        this.sql = value
    }

    /**
     * @param value The version of the SQL rules engine to use when evaluating the rule.
     */
    @JvmName("lshemxniqfcwnpmq")
    public suspend fun sqlVersion(`value`: Output<String>) {
        this.sqlVersion = value
    }

    /**
     * @param value
     */
    @JvmName("eperqndagpsltoqd")
    public suspend fun sqs(`value`: Output<List<TopicRuleSqsArgs>>) {
        this.sqs = value
    }

    @JvmName("jktdmbgevgpiaddx")
    public suspend fun sqs(vararg values: Output<TopicRuleSqsArgs>) {
        this.sqs = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("aaoppucbufefkqki")
    public suspend fun sqs(values: List<Output<TopicRuleSqsArgs>>) {
        this.sqs = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("gptvqypqfkqxjimo")
    public suspend fun stepFunctions(`value`: Output<List<TopicRuleStepFunctionArgs>>) {
        this.stepFunctions = value
    }

    @JvmName("sbdbvflqafkhfyuy")
    public suspend fun stepFunctions(vararg values: Output<TopicRuleStepFunctionArgs>) {
        this.stepFunctions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("fwyifsibajeeohwd")
    public suspend fun stepFunctions(values: List<Output<TopicRuleStepFunctionArgs>>) {
        this.stepFunctions = Output.all(values)
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("alkowkvdqedrmaoq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("xfortngjrgholqby")
    public suspend fun timestreams(`value`: Output<List<TopicRuleTimestreamArgs>>) {
        this.timestreams = value
    }

    @JvmName("rnnlbhnyprsqitjj")
    public suspend fun timestreams(vararg values: Output<TopicRuleTimestreamArgs>) {
        this.timestreams = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("audufvcboeodswul")
    public suspend fun timestreams(values: List<Output<TopicRuleTimestreamArgs>>) {
        this.timestreams = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("mdcadescorwggofl")
    public suspend fun cloudwatchAlarms(`value`: List<TopicRuleCloudwatchAlarmArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchAlarms = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mrvaywnwxiamuytx")
    public suspend fun cloudwatchAlarms(argument: List<suspend TopicRuleCloudwatchAlarmArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleCloudwatchAlarmArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.cloudwatchAlarms = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qktotyxgkyaqqnje")
    public suspend fun cloudwatchAlarms(vararg argument: suspend TopicRuleCloudwatchAlarmArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleCloudwatchAlarmArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.cloudwatchAlarms = mapped
    }

    /**
     * @param argument
     */
    @JvmName("jphmrxkugnisqphr")
    public suspend fun cloudwatchAlarms(argument: suspend TopicRuleCloudwatchAlarmArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TopicRuleCloudwatchAlarmArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.cloudwatchAlarms = mapped
    }

    /**
     * @param values
     */
    @JvmName("vmiifebgakkblpxa")
    public suspend fun cloudwatchAlarms(vararg values: TopicRuleCloudwatchAlarmArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cloudwatchAlarms = mapped
    }

    /**
     * @param value
     */
    @JvmName("qlaeltydhehtqfge")
    public suspend fun cloudwatchLogs(`value`: List<TopicRuleCloudwatchLogArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLogs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("kjsbovoepwfvakbx")
    public suspend fun cloudwatchLogs(argument: List<suspend TopicRuleCloudwatchLogArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleCloudwatchLogArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.cloudwatchLogs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("kwqrffjotoqmuxki")
    public suspend fun cloudwatchLogs(vararg argument: suspend TopicRuleCloudwatchLogArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleCloudwatchLogArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.cloudwatchLogs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("pwanxqlinkmbrdoj")
    public suspend fun cloudwatchLogs(argument: suspend TopicRuleCloudwatchLogArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleCloudwatchLogArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.cloudwatchLogs = mapped
    }

    /**
     * @param values
     */
    @JvmName("yieevhexmcbumrdc")
    public suspend fun cloudwatchLogs(vararg values: TopicRuleCloudwatchLogArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cloudwatchLogs = mapped
    }

    /**
     * @param value
     */
    @JvmName("recfqagomuajixpu")
    public suspend fun cloudwatchMetrics(`value`: List<TopicRuleCloudwatchMetricArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchMetrics = mapped
    }

    /**
     * @param argument
     */
    @JvmName("uoiiymfdnavttvdx")
    public suspend fun cloudwatchMetrics(argument: List<suspend TopicRuleCloudwatchMetricArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleCloudwatchMetricArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.cloudwatchMetrics = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wpbcbmcctmunvgks")
    public suspend fun cloudwatchMetrics(vararg argument: suspend TopicRuleCloudwatchMetricArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleCloudwatchMetricArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.cloudwatchMetrics = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bdubolehyedqswns")
    public suspend fun cloudwatchMetrics(argument: suspend TopicRuleCloudwatchMetricArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TopicRuleCloudwatchMetricArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.cloudwatchMetrics = mapped
    }

    /**
     * @param values
     */
    @JvmName("orqmgyrsrvqjsjiv")
    public suspend fun cloudwatchMetrics(vararg values: TopicRuleCloudwatchMetricArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cloudwatchMetrics = mapped
    }

    /**
     * @param value The description of the rule.
     */
    @JvmName("bhtktjhixcpfjjug")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value
     */
    @JvmName("ytlffoptxqvoqphw")
    public suspend fun dynamodbs(`value`: List<TopicRuleDynamodbArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamodbs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("baqtfueaantohhkg")
    public suspend fun dynamodbs(argument: List<suspend TopicRuleDynamodbArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleDynamodbArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dynamodbs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qibpkfhkuuqjmeqd")
    public suspend fun dynamodbs(vararg argument: suspend TopicRuleDynamodbArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleDynamodbArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dynamodbs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gwgbiabmqwiycdmh")
    public suspend fun dynamodbs(argument: suspend TopicRuleDynamodbArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleDynamodbArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dynamodbs = mapped
    }

    /**
     * @param values
     */
    @JvmName("fxfmbkkjuxvphggo")
    public suspend fun dynamodbs(vararg values: TopicRuleDynamodbArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dynamodbs = mapped
    }

    /**
     * @param value
     */
    @JvmName("jynueuyqngchbarm")
    public suspend fun dynamodbv2s(`value`: List<TopicRuleDynamodbv2Args>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamodbv2s = mapped
    }

    /**
     * @param argument
     */
    @JvmName("fsplcaspintmiais")
    public suspend fun dynamodbv2s(argument: List<suspend TopicRuleDynamodbv2ArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleDynamodbv2ArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dynamodbv2s = mapped
    }

    /**
     * @param argument
     */
    @JvmName("sbkopdeiapuokmkl")
    public suspend fun dynamodbv2s(vararg argument: suspend TopicRuleDynamodbv2ArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleDynamodbv2ArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dynamodbv2s = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xkrajlsgkhnsvlpa")
    public suspend fun dynamodbv2s(argument: suspend TopicRuleDynamodbv2ArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleDynamodbv2ArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dynamodbv2s = mapped
    }

    /**
     * @param values
     */
    @JvmName("xmosfrdiawttxknf")
    public suspend fun dynamodbv2s(vararg values: TopicRuleDynamodbv2Args) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dynamodbv2s = mapped
    }

    /**
     * @param value
     */
    @JvmName("gativfneroqgmhjs")
    public suspend fun elasticsearch(`value`: List<TopicRuleElasticsearchArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearch = mapped
    }

    /**
     * @param argument
     */
    @JvmName("oumfthicysuxrjor")
    public suspend fun elasticsearch(argument: List<suspend TopicRuleElasticsearchArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleElasticsearchArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.elasticsearch = mapped
    }

    /**
     * @param argument
     */
    @JvmName("uqesnaxpxlefrmcb")
    public suspend fun elasticsearch(vararg argument: suspend TopicRuleElasticsearchArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleElasticsearchArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.elasticsearch = mapped
    }

    /**
     * @param argument
     */
    @JvmName("vlasaenkndmtgwlp")
    public suspend fun elasticsearch(argument: suspend TopicRuleElasticsearchArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleElasticsearchArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.elasticsearch = mapped
    }

    /**
     * @param values
     */
    @JvmName("ryvxjrbvifrwehbr")
    public suspend fun elasticsearch(vararg values: TopicRuleElasticsearchArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.elasticsearch = mapped
    }

    /**
     * @param value Specifies whether the rule is enabled.
     */
    @JvmName("dhgcqgjdfxfeqawv")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Configuration block with error action to be associated with the rule. See the documentation for `cloudwatch_alarm`, `cloudwatch_logs`, `cloudwatch_metric`, `dynamodb`, `dynamodbv2`, `elasticsearch`, `firehose`, `http`, `iot_analytics`, `iot_events`, `kafka`, `kinesis`, `lambda`, `republish`, `s3`, `sns`, `sqs`, `step_functions`, `timestream` configuration blocks for further configuration details.
     */
    @JvmName("jhouhbwxaqeenycm")
    public suspend fun errorAction(`value`: TopicRuleErrorActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorAction = mapped
    }

    /**
     * @param argument Configuration block with error action to be associated with the rule. See the documentation for `cloudwatch_alarm`, `cloudwatch_logs`, `cloudwatch_metric`, `dynamodb`, `dynamodbv2`, `elasticsearch`, `firehose`, `http`, `iot_analytics`, `iot_events`, `kafka`, `kinesis`, `lambda`, `republish`, `s3`, `sns`, `sqs`, `step_functions`, `timestream` configuration blocks for further configuration details.
     */
    @JvmName("xpxkjaofpaxctsfr")
    public suspend fun errorAction(argument: suspend TopicRuleErrorActionArgsBuilder.() -> Unit) {
        val toBeMapped = TopicRuleErrorActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.errorAction = mapped
    }

    /**
     * @param value
     */
    @JvmName("yhmotptoxsjfdkwu")
    public suspend fun firehoses(`value`: List<TopicRuleFirehoseArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firehoses = mapped
    }

    /**
     * @param argument
     */
    @JvmName("sglqhckjmqoefaaw")
    public suspend fun firehoses(argument: List<suspend TopicRuleFirehoseArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleFirehoseArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.firehoses = mapped
    }

    /**
     * @param argument
     */
    @JvmName("vlfxgokpfmvnlavp")
    public suspend fun firehoses(vararg argument: suspend TopicRuleFirehoseArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleFirehoseArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.firehoses = mapped
    }

    /**
     * @param argument
     */
    @JvmName("yousmvdhcllyjllg")
    public suspend fun firehoses(argument: suspend TopicRuleFirehoseArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleFirehoseArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.firehoses = mapped
    }

    /**
     * @param values
     */
    @JvmName("aqckysticvntjjhl")
    public suspend fun firehoses(vararg values: TopicRuleFirehoseArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.firehoses = mapped
    }

    /**
     * @param value
     */
    @JvmName("adghbgowitekeaag")
    public suspend fun https(`value`: List<TopicRuleHttpArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.https = mapped
    }

    /**
     * @param argument
     */
    @JvmName("scajrehuenkguaef")
    public suspend fun https(argument: List<suspend TopicRuleHttpArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleHttpArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.https = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rfhsxxjejviubiur")
    public suspend fun https(vararg argument: suspend TopicRuleHttpArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleHttpArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.https = mapped
    }

    /**
     * @param argument
     */
    @JvmName("adrqnoreylvqnwwx")
    public suspend fun https(argument: suspend TopicRuleHttpArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleHttpArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.https = mapped
    }

    /**
     * @param values
     */
    @JvmName("krcmafyjxlssytfw")
    public suspend fun https(vararg values: TopicRuleHttpArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.https = mapped
    }

    /**
     * @param value
     */
    @JvmName("shghmjulcmwuwqwo")
    public suspend fun iotAnalytics(`value`: List<TopicRuleIotAnalyticArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iotAnalytics = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gpmuthgvpyltmvpe")
    public suspend fun iotAnalytics(argument: List<suspend TopicRuleIotAnalyticArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleIotAnalyticArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.iotAnalytics = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xhftcojwvkeafaeo")
    public suspend fun iotAnalytics(vararg argument: suspend TopicRuleIotAnalyticArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleIotAnalyticArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.iotAnalytics = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mqrkoljdimbcpvfs")
    public suspend fun iotAnalytics(argument: suspend TopicRuleIotAnalyticArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleIotAnalyticArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.iotAnalytics = mapped
    }

    /**
     * @param values
     */
    @JvmName("ipoalllqycmefmgi")
    public suspend fun iotAnalytics(vararg values: TopicRuleIotAnalyticArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.iotAnalytics = mapped
    }

    /**
     * @param value
     */
    @JvmName("ssctjfaqhboqfunq")
    public suspend fun iotEvents(`value`: List<TopicRuleIotEventArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iotEvents = mapped
    }

    /**
     * @param argument
     */
    @JvmName("vfptnkiblgsuoifo")
    public suspend fun iotEvents(argument: List<suspend TopicRuleIotEventArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleIotEventArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.iotEvents = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bmmciwovcmqcsxat")
    public suspend fun iotEvents(vararg argument: suspend TopicRuleIotEventArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleIotEventArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.iotEvents = mapped
    }

    /**
     * @param argument
     */
    @JvmName("aeqogifepfjwspsb")
    public suspend fun iotEvents(argument: suspend TopicRuleIotEventArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleIotEventArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.iotEvents = mapped
    }

    /**
     * @param values
     */
    @JvmName("taugkiovwnmkpbdc")
    public suspend fun iotEvents(vararg values: TopicRuleIotEventArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.iotEvents = mapped
    }

    /**
     * @param value
     */
    @JvmName("iytwkvyosmiuuhke")
    public suspend fun kafkas(`value`: List<TopicRuleKafkaArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkas = mapped
    }

    /**
     * @param argument
     */
    @JvmName("eopfjkpkohwjasjw")
    public suspend fun kafkas(argument: List<suspend TopicRuleKafkaArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleKafkaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.kafkas = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rxlrbyvpmcubepxi")
    public suspend fun kafkas(vararg argument: suspend TopicRuleKafkaArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleKafkaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.kafkas = mapped
    }

    /**
     * @param argument
     */
    @JvmName("kuqoefrqmvkpwttn")
    public suspend fun kafkas(argument: suspend TopicRuleKafkaArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleKafkaArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.kafkas = mapped
    }

    /**
     * @param values
     */
    @JvmName("ndcccsrksjsvfipv")
    public suspend fun kafkas(vararg values: TopicRuleKafkaArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kafkas = mapped
    }

    /**
     * @param value
     */
    @JvmName("ipjvsyfultqouyws")
    public suspend fun kineses(`value`: List<TopicRuleKinesisArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kineses = mapped
    }

    /**
     * @param argument
     */
    @JvmName("uedrktgidjtvhlij")
    public suspend fun kineses(argument: List<suspend TopicRuleKinesisArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleKinesisArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.kineses = mapped
    }

    /**
     * @param argument
     */
    @JvmName("riwxgwdyyrbtjtun")
    public suspend fun kineses(vararg argument: suspend TopicRuleKinesisArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleKinesisArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.kineses = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gejyyljnfdnsmrti")
    public suspend fun kineses(argument: suspend TopicRuleKinesisArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleKinesisArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.kineses = mapped
    }

    /**
     * @param values
     */
    @JvmName("vuwpqlolehpuopdg")
    public suspend fun kineses(vararg values: TopicRuleKinesisArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kineses = mapped
    }

    /**
     * @param value
     */
    @JvmName("kehjcgscclurnpdw")
    public suspend fun lambdas(`value`: List<TopicRuleLambdaArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdas = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mpawwehkyiukuifb")
    public suspend fun lambdas(argument: List<suspend TopicRuleLambdaArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleLambdaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lambdas = mapped
    }

    /**
     * @param argument
     */
    @JvmName("yksupdxgrtpljspv")
    public suspend fun lambdas(vararg argument: suspend TopicRuleLambdaArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleLambdaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lambdas = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qfmftedikqfnwlcc")
    public suspend fun lambdas(argument: suspend TopicRuleLambdaArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleLambdaArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.lambdas = mapped
    }

    /**
     * @param values
     */
    @JvmName("tvfjaypfnktxnbhg")
    public suspend fun lambdas(vararg values: TopicRuleLambdaArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lambdas = mapped
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("wmoccnptfmqabdfl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("gfbmercokuimckqq")
    public suspend fun republishes(`value`: List<TopicRuleRepublishArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.republishes = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qssprcbqvffqnkfv")
    public suspend fun republishes(argument: List<suspend TopicRuleRepublishArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleRepublishArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.republishes = mapped
    }

    /**
     * @param argument
     */
    @JvmName("csqgwbnnyupcpiql")
    public suspend fun republishes(vararg argument: suspend TopicRuleRepublishArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleRepublishArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.republishes = mapped
    }

    /**
     * @param argument
     */
    @JvmName("snoqpiymtihoxldk")
    public suspend fun republishes(argument: suspend TopicRuleRepublishArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleRepublishArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.republishes = mapped
    }

    /**
     * @param values
     */
    @JvmName("wklsmyljyvckcgqg")
    public suspend fun republishes(vararg values: TopicRuleRepublishArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.republishes = mapped
    }

    /**
     * @param value
     */
    @JvmName("bfuevrsoelpulcie")
    public suspend fun s3(`value`: List<TopicRuleS3Args>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3 = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bdjelxbdfapsdgah")
    public suspend fun s3(argument: List<suspend TopicRuleS3ArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { TopicRuleS3ArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.s3 = mapped
    }

    /**
     * @param argument
     */
    @JvmName("nfpmdxuixlvpnmpi")
    public suspend fun s3(vararg argument: suspend TopicRuleS3ArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { TopicRuleS3ArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.s3 = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mvebdkmmkrsbltfi")
    public suspend fun s3(argument: suspend TopicRuleS3ArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleS3ArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.s3 = mapped
    }

    /**
     * @param values
     */
    @JvmName("erasutwbvjkdtdke")
    public suspend fun s3(vararg values: TopicRuleS3Args) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3 = mapped
    }

    /**
     * @param value
     */
    @JvmName("nltteycijnejemrh")
    public suspend fun sns(`value`: List<TopicRuleSnsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sns = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mmyyhvrpuwpuemod")
    public suspend fun sns(argument: List<suspend TopicRuleSnsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleSnsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sns = mapped
    }

    /**
     * @param argument
     */
    @JvmName("cchneuftiqtxfdwn")
    public suspend fun sns(vararg argument: suspend TopicRuleSnsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleSnsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sns = mapped
    }

    /**
     * @param argument
     */
    @JvmName("pdulybvscakvwlqr")
    public suspend fun sns(argument: suspend TopicRuleSnsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleSnsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sns = mapped
    }

    /**
     * @param values
     */
    @JvmName("evsjuklacevthutm")
    public suspend fun sns(vararg values: TopicRuleSnsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sns = mapped
    }

    /**
     * @param value The SQL statement used to query the topic. For more information, see AWS IoT SQL Reference (http://docs.aws.amazon.com/iot/latest/developerguide/iot-rules.html#aws-iot-sql-reference) in the AWS IoT Developer Guide.
     */
    @JvmName("xenifbpcsatghdtv")
    public suspend fun sql(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sql = mapped
    }

    /**
     * @param value The version of the SQL rules engine to use when evaluating the rule.
     */
    @JvmName("mmkexxsdgpjbhecv")
    public suspend fun sqlVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlVersion = mapped
    }

    /**
     * @param value
     */
    @JvmName("sbqklgwxvxcdtksl")
    public suspend fun sqs(`value`: List<TopicRuleSqsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dsavuwblpgtoqdhm")
    public suspend fun sqs(argument: List<suspend TopicRuleSqsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleSqsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sqs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("oyxhvcrnhggdsbmr")
    public suspend fun sqs(vararg argument: suspend TopicRuleSqsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleSqsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sqs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("egqwfspmutljxeon")
    public suspend fun sqs(argument: suspend TopicRuleSqsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleSqsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sqs = mapped
    }

    /**
     * @param values
     */
    @JvmName("pdnclccncjvnwjgs")
    public suspend fun sqs(vararg values: TopicRuleSqsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqs = mapped
    }

    /**
     * @param value
     */
    @JvmName("spfhkcjqqidhowgk")
    public suspend fun stepFunctions(`value`: List<TopicRuleStepFunctionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stepFunctions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gwkkoarhdphvlcee")
    public suspend fun stepFunctions(argument: List<suspend TopicRuleStepFunctionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleStepFunctionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.stepFunctions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ncpqvubjneijttnu")
    public suspend fun stepFunctions(vararg argument: suspend TopicRuleStepFunctionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleStepFunctionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.stepFunctions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qggrirpwwwerpaoq")
    public suspend fun stepFunctions(argument: suspend TopicRuleStepFunctionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleStepFunctionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.stepFunctions = mapped
    }

    /**
     * @param values
     */
    @JvmName("lrygsveflthrxuep")
    public suspend fun stepFunctions(vararg values: TopicRuleStepFunctionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stepFunctions = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tdofqrlavsepxrqo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tenpnciomdsjdniq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("xuadflnsrglmtvnd")
    public suspend fun timestreams(`value`: List<TopicRuleTimestreamArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timestreams = mapped
    }

    /**
     * @param argument
     */
    @JvmName("fkgwpwfmgmkdtvat")
    public suspend fun timestreams(argument: List<suspend TopicRuleTimestreamArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleTimestreamArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.timestreams = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rxdbrhchkuwaewnc")
    public suspend fun timestreams(vararg argument: suspend TopicRuleTimestreamArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleTimestreamArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.timestreams = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xtnccbnyyotpxbeh")
    public suspend fun timestreams(argument: suspend TopicRuleTimestreamArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopicRuleTimestreamArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.timestreams = mapped
    }

    /**
     * @param values
     */
    @JvmName("avayrwqikjlohepj")
    public suspend fun timestreams(vararg values: TopicRuleTimestreamArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timestreams = mapped
    }

    internal fun build(): TopicRuleArgs = TopicRuleArgs(
        cloudwatchAlarms = cloudwatchAlarms,
        cloudwatchLogs = cloudwatchLogs,
        cloudwatchMetrics = cloudwatchMetrics,
        description = description,
        dynamodbs = dynamodbs,
        dynamodbv2s = dynamodbv2s,
        elasticsearch = elasticsearch,
        enabled = enabled,
        errorAction = errorAction,
        firehoses = firehoses,
        https = https,
        iotAnalytics = iotAnalytics,
        iotEvents = iotEvents,
        kafkas = kafkas,
        kineses = kineses,
        lambdas = lambdas,
        name = name,
        republishes = republishes,
        s3 = s3,
        sns = sns,
        sql = sql,
        sqlVersion = sqlVersion,
        sqs = sqs,
        stepFunctions = stepFunctions,
        tags = tags,
        timestreams = timestreams,
    )
}
