@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin

import com.pulumi.aws.iot.TopicRuleDestinationArgs.builder
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleDestinationVpcConfigurationArgs
import com.pulumi.aws.iot.kotlin.inputs.TopicRuleDestinationVpcConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.iot.TopicRuleDestination("example", {vpcConfiguration: {
 *     roleArn: exampleAwsIamRole.arn,
 *     securityGroups: [exampleAwsSecurityGroup&#46;id],
 *     subnetIds: exampleAwsSubnet.map(__item => __item.id),
 *     vpcId: exampleAwsVpc.id,
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.iot.TopicRuleDestination("example", vpc_configuration={
 *     "role_arn": example_aws_iam_role["arn"],
 *     "security_groups": [example_aws_security_group["id"]],
 *     "subnet_ids": [__item["id"] for __item in example_aws_subnet],
 *     "vpc_id": example_aws_vpc["id"],
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Iot.TopicRuleDestination("example", new()
 *     {
 *         VpcConfiguration = new Aws.Iot.Inputs.TopicRuleDestinationVpcConfigurationArgs
 *         {
 *             RoleArn = exampleAwsIamRole.Arn,
 *             SecurityGroups = new[]
 *             {
 *                 exampleAwsSecurityGroup.Id,
 *             },
 *             SubnetIds = exampleAwsSubnet.Select(__item => __item.Id).ToList(),
 *             VpcId = exampleAwsVpc.Id,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iot"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := iot.NewTopicRuleDestination(ctx, "example", &iot.TopicRuleDestinationArgs{
 * VpcConfiguration: &iot.TopicRuleDestinationVpcConfigurationArgs{
 * RoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * SecurityGroups: pulumi.StringArray{
 * exampleAwsSecurityGroup.Id,
 * },
 * SubnetIds: []pulumi.String(%!v(PANIC=Format method: fatal: A failure has occurred: unlowered splat expression @ example.pp:4,22-44)),
 * VpcId: pulumi.Any(exampleAwsVpc.Id),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iot.TopicRuleDestination;
 * import com.pulumi.aws.iot.TopicRuleDestinationArgs;
 * import com.pulumi.aws.iot.inputs.TopicRuleDestinationVpcConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TopicRuleDestination("example", TopicRuleDestinationArgs.builder()
 *             .vpcConfiguration(TopicRuleDestinationVpcConfigurationArgs.builder()
 *                 .roleArn(exampleAwsIamRole.arn())
 *                 .securityGroups(exampleAwsSecurityGroup.id())
 *                 .subnetIds(exampleAwsSubnet.stream().map(element -> element.id()).collect(toList()))
 *                 .vpcId(exampleAwsVpc.id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IoT topic rule destinations using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:iot/topicRuleDestination:TopicRuleDestination example arn:aws:iot:us-west-2:123456789012:ruledestination/vpc/2ce781c8-68a6-4c52-9c62-63fe489ecc60
 * ```
 * @property enabled Whether or not to enable the destination. Default: `true`.
 * @property vpcConfiguration Configuration of the virtual private cloud (VPC) connection. For more info, see the [AWS documentation](https://docs.aws.amazon.com/iot/latest/developerguide/vpc-rule-action.html).
 */
public data class TopicRuleDestinationArgs(
    public val enabled: Output<Boolean>? = null,
    public val vpcConfiguration: Output<TopicRuleDestinationVpcConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.TopicRuleDestinationArgs> {
    override fun toJava(): com.pulumi.aws.iot.TopicRuleDestinationArgs =
        com.pulumi.aws.iot.TopicRuleDestinationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .vpcConfiguration(
                vpcConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [TopicRuleDestinationArgs].
 */
@PulumiTagMarker
public class TopicRuleDestinationArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var vpcConfiguration: Output<TopicRuleDestinationVpcConfigurationArgs>? = null

    /**
     * @param value Whether or not to enable the destination. Default: `true`.
     */
    @JvmName("dvvrsohvwpdkweco")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Configuration of the virtual private cloud (VPC) connection. For more info, see the [AWS documentation](https://docs.aws.amazon.com/iot/latest/developerguide/vpc-rule-action.html).
     */
    @JvmName("sgqdgvonnqemiryd")
    public suspend fun vpcConfiguration(`value`: Output<TopicRuleDestinationVpcConfigurationArgs>) {
        this.vpcConfiguration = value
    }

    /**
     * @param value Whether or not to enable the destination. Default: `true`.
     */
    @JvmName("wjtlmbqxquemqdle")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Configuration of the virtual private cloud (VPC) connection. For more info, see the [AWS documentation](https://docs.aws.amazon.com/iot/latest/developerguide/vpc-rule-action.html).
     */
    @JvmName("actgkbkpwtauwcqk")
    public suspend fun vpcConfiguration(`value`: TopicRuleDestinationVpcConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfiguration = mapped
    }

    /**
     * @param argument Configuration of the virtual private cloud (VPC) connection. For more info, see the [AWS documentation](https://docs.aws.amazon.com/iot/latest/developerguide/vpc-rule-action.html).
     */
    @JvmName("oifbfnlgfbqxmnco")
    public suspend fun vpcConfiguration(argument: suspend TopicRuleDestinationVpcConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = TopicRuleDestinationVpcConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.vpcConfiguration = mapped
    }

    internal fun build(): TopicRuleDestinationArgs = TopicRuleDestinationArgs(
        enabled = enabled,
        vpcConfiguration = vpcConfiguration,
    )
}
