@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.BillingGroupPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description A description of the Billing Group.
 */
public data class BillingGroupPropertiesArgs(
    public val description: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.BillingGroupPropertiesArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.BillingGroupPropertiesArgs =
        com.pulumi.aws.iot.inputs.BillingGroupPropertiesArgs.builder()
            .description(description?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BillingGroupPropertiesArgs].
 */
@PulumiTagMarker
public class BillingGroupPropertiesArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    /**
     * @param value A description of the Billing Group.
     */
    @JvmName("herurjjhlfumdwsx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A description of the Billing Group.
     */
    @JvmName("wdfjvbvxaclsmfgi")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    internal fun build(): BillingGroupPropertiesArgs = BillingGroupPropertiesArgs(
        description = description,
    )
}
