@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.CaCertificateRegistrationConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property roleArn The ARN of the role.
 * @property templateBody The template body.
 * @property templateName The name of the provisioning template.
 */
public data class CaCertificateRegistrationConfigArgs(
    public val roleArn: Output<String>? = null,
    public val templateBody: Output<String>? = null,
    public val templateName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.CaCertificateRegistrationConfigArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.CaCertificateRegistrationConfigArgs =
        com.pulumi.aws.iot.inputs.CaCertificateRegistrationConfigArgs.builder()
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .templateBody(templateBody?.applyValue({ args0 -> args0 }))
            .templateName(templateName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CaCertificateRegistrationConfigArgs].
 */
@PulumiTagMarker
public class CaCertificateRegistrationConfigArgsBuilder internal constructor() {
    private var roleArn: Output<String>? = null

    private var templateBody: Output<String>? = null

    private var templateName: Output<String>? = null

    /**
     * @param value The ARN of the role.
     */
    @JvmName("kfforpykrsaamjkt")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The template body.
     */
    @JvmName("qtxlvwkvvpurlekm")
    public suspend fun templateBody(`value`: Output<String>) {
        this.templateBody = value
    }

    /**
     * @param value The name of the provisioning template.
     */
    @JvmName("xrujyrsxevaekwlt")
    public suspend fun templateName(`value`: Output<String>) {
        this.templateName = value
    }

    /**
     * @param value The ARN of the role.
     */
    @JvmName("nphckxjnjklxkutr")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The template body.
     */
    @JvmName("oqqhgujafstoxmnv")
    public suspend fun templateBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateBody = mapped
    }

    /**
     * @param value The name of the provisioning template.
     */
    @JvmName("yoxroysromcxxokj")
    public suspend fun templateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateName = mapped
    }

    internal fun build(): CaCertificateRegistrationConfigArgs = CaCertificateRegistrationConfigArgs(
        roleArn = roleArn,
        templateBody = templateBody,
        templateName = templateName,
    )
}
