@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.GetEndpointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEndpoint.
 * @property endpointType Endpoint type. Valid values: `iot:CredentialProvider`, `iot:Data`, `iot:Data-ATS`, `iot:Jobs`.
 */
public data class GetEndpointPlainArgs(
    public val endpointType: String? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.GetEndpointPlainArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.GetEndpointPlainArgs =
        com.pulumi.aws.iot.inputs.GetEndpointPlainArgs.builder()
            .endpointType(endpointType?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEndpointPlainArgs].
 */
@PulumiTagMarker
public class GetEndpointPlainArgsBuilder internal constructor() {
    private var endpointType: String? = null

    /**
     * @param value Endpoint type. Valid values: `iot:CredentialProvider`, `iot:Data`, `iot:Data-ATS`, `iot:Jobs`.
     */
    @JvmName("vomatylmpwdcgyeg")
    public suspend fun endpointType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endpointType = mapped
    }

    internal fun build(): GetEndpointPlainArgs = GetEndpointPlainArgs(
        endpointType = endpointType,
    )
}
