@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.IndexingConfigurationThingIndexingConfigurationCustomFieldArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the field.
 * @property type The data type of the field. Valid values: `Number`, `String`, `Boolean`.
 */
public data class IndexingConfigurationThingIndexingConfigurationCustomFieldArgs(
    public val name: Output<String>? = null,
    public val type: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.iot.inputs.IndexingConfigurationThingIndexingConfigurationCustomFieldArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.IndexingConfigurationThingIndexingConfigurationCustomFieldArgs =
        com.pulumi.aws.iot.inputs.IndexingConfigurationThingIndexingConfigurationCustomFieldArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IndexingConfigurationThingIndexingConfigurationCustomFieldArgs].
 */
@PulumiTagMarker
public class IndexingConfigurationThingIndexingConfigurationCustomFieldArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The name of the field.
     */
    @JvmName("swpixwhghpcrwcjw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The data type of the field. Valid values: `Number`, `String`, `Boolean`.
     */
    @JvmName("rdmmgkqujyfayela")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name of the field.
     */
    @JvmName("tallmocorvjxcutb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The data type of the field. Valid values: `Number`, `String`, `Boolean`.
     */
    @JvmName("osvloccdsuxobbbd")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): IndexingConfigurationThingIndexingConfigurationCustomFieldArgs =
        IndexingConfigurationThingIndexingConfigurationCustomFieldArgs(
            name = name,
            type = type,
        )
}
