@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.ProvisioningTemplatePreProvisioningHookArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property payloadVersion The version of the payload that was sent to the target function. The only valid (and the default) payload version is `"2020-04-01"`.
 * @property targetArn The ARN of the target function.
 */
public data class ProvisioningTemplatePreProvisioningHookArgs(
    public val payloadVersion: Output<String>? = null,
    public val targetArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.ProvisioningTemplatePreProvisioningHookArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.ProvisioningTemplatePreProvisioningHookArgs =
        com.pulumi.aws.iot.inputs.ProvisioningTemplatePreProvisioningHookArgs.builder()
            .payloadVersion(payloadVersion?.applyValue({ args0 -> args0 }))
            .targetArn(targetArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProvisioningTemplatePreProvisioningHookArgs].
 */
@PulumiTagMarker
public class ProvisioningTemplatePreProvisioningHookArgsBuilder internal constructor() {
    private var payloadVersion: Output<String>? = null

    private var targetArn: Output<String>? = null

    /**
     * @param value The version of the payload that was sent to the target function. The only valid (and the default) payload version is `"2020-04-01"`.
     */
    @JvmName("tgkcjxwmcirhmtdc")
    public suspend fun payloadVersion(`value`: Output<String>) {
        this.payloadVersion = value
    }

    /**
     * @param value The ARN of the target function.
     */
    @JvmName("wosdplaikhkrswuy")
    public suspend fun targetArn(`value`: Output<String>) {
        this.targetArn = value
    }

    /**
     * @param value The version of the payload that was sent to the target function. The only valid (and the default) payload version is `"2020-04-01"`.
     */
    @JvmName("lpqvlktocigobjhx")
    public suspend fun payloadVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payloadVersion = mapped
    }

    /**
     * @param value The ARN of the target function.
     */
    @JvmName("ygltxibihnntbaxb")
    public suspend fun targetArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetArn = mapped
    }

    internal fun build(): ProvisioningTemplatePreProvisioningHookArgs =
        ProvisioningTemplatePreProvisioningHookArgs(
            payloadVersion = payloadVersion,
            targetArn = targetArn ?: throw PulumiNullFieldException("targetArn"),
        )
}
