@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.ThingGroupPropertiesAttributePayloadArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property attributes Key-value map.
 */
public data class ThingGroupPropertiesAttributePayloadArgs(
    public val attributes: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.ThingGroupPropertiesAttributePayloadArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.ThingGroupPropertiesAttributePayloadArgs =
        com.pulumi.aws.iot.inputs.ThingGroupPropertiesAttributePayloadArgs.builder()
            .attributes(
                attributes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ThingGroupPropertiesAttributePayloadArgs].
 */
@PulumiTagMarker
public class ThingGroupPropertiesAttributePayloadArgsBuilder internal constructor() {
    private var attributes: Output<Map<String, String>>? = null

    /**
     * @param value Key-value map.
     */
    @JvmName("huvjfdqttpimlecs")
    public suspend fun attributes(`value`: Output<Map<String, String>>) {
        this.attributes = value
    }

    /**
     * @param value Key-value map.
     */
    @JvmName("mlwhvnwqsqtgcqun")
    public suspend fun attributes(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param values Key-value map.
     */
    @JvmName("gaimvgwkxtkgsnmi")
    public fun attributes(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    internal fun build(): ThingGroupPropertiesAttributePayloadArgs =
        ThingGroupPropertiesAttributePayloadArgs(
            attributes = attributes,
        )
}
