@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.ThingTypePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property description The description of the thing type.
 * @property searchableAttributes A list of searchable thing attribute names.
 */
public data class ThingTypePropertiesArgs(
    public val description: Output<String>? = null,
    public val searchableAttributes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.ThingTypePropertiesArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.ThingTypePropertiesArgs =
        com.pulumi.aws.iot.inputs.ThingTypePropertiesArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .searchableAttributes(
                searchableAttributes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [ThingTypePropertiesArgs].
 */
@PulumiTagMarker
public class ThingTypePropertiesArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var searchableAttributes: Output<List<String>>? = null

    /**
     * @param value The description of the thing type.
     */
    @JvmName("pjmivbshufkdmcer")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A list of searchable thing attribute names.
     */
    @JvmName("arnsspvsjlbofowd")
    public suspend fun searchableAttributes(`value`: Output<List<String>>) {
        this.searchableAttributes = value
    }

    @JvmName("tbddawcdinwkrvvw")
    public suspend fun searchableAttributes(vararg values: Output<String>) {
        this.searchableAttributes = Output.all(values.asList())
    }

    /**
     * @param values A list of searchable thing attribute names.
     */
    @JvmName("ooqvdboncphltjiv")
    public suspend fun searchableAttributes(values: List<Output<String>>) {
        this.searchableAttributes = Output.all(values)
    }

    /**
     * @param value The description of the thing type.
     */
    @JvmName("cdcsvnggnnkfepae")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A list of searchable thing attribute names.
     */
    @JvmName("tqgcfsxsuxpladgb")
    public suspend fun searchableAttributes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.searchableAttributes = mapped
    }

    /**
     * @param values A list of searchable thing attribute names.
     */
    @JvmName("dljvpqadqramfpud")
    public suspend fun searchableAttributes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.searchableAttributes = mapped
    }

    internal fun build(): ThingTypePropertiesArgs = ThingTypePropertiesArgs(
        description = description,
        searchableAttributes = searchableAttributes,
    )
}
