@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleCloudwatchLogArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property batchMode The payload that contains a JSON array of records will be sent to CloudWatch via a batch call.
 * @property logGroupName The CloudWatch log group name.
 * @property roleArn The IAM role ARN that allows access to the CloudWatch alarm.
 */
public data class TopicRuleCloudwatchLogArgs(
    public val batchMode: Output<Boolean>? = null,
    public val logGroupName: Output<String>,
    public val roleArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleCloudwatchLogArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleCloudwatchLogArgs =
        com.pulumi.aws.iot.inputs.TopicRuleCloudwatchLogArgs.builder()
            .batchMode(batchMode?.applyValue({ args0 -> args0 }))
            .logGroupName(logGroupName.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleCloudwatchLogArgs].
 */
@PulumiTagMarker
public class TopicRuleCloudwatchLogArgsBuilder internal constructor() {
    private var batchMode: Output<Boolean>? = null

    private var logGroupName: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value The payload that contains a JSON array of records will be sent to CloudWatch via a batch call.
     */
    @JvmName("xxelbtxyisbhnxlj")
    public suspend fun batchMode(`value`: Output<Boolean>) {
        this.batchMode = value
    }

    /**
     * @param value The CloudWatch log group name.
     */
    @JvmName("blcsaslxuiqqswwv")
    public suspend fun logGroupName(`value`: Output<String>) {
        this.logGroupName = value
    }

    /**
     * @param value The IAM role ARN that allows access to the CloudWatch alarm.
     */
    @JvmName("ulqfbvgajuyrluxp")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The payload that contains a JSON array of records will be sent to CloudWatch via a batch call.
     */
    @JvmName("hacnoorbquvpcewg")
    public suspend fun batchMode(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchMode = mapped
    }

    /**
     * @param value The CloudWatch log group name.
     */
    @JvmName("ihxjmilihlelwrlb")
    public suspend fun logGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logGroupName = mapped
    }

    /**
     * @param value The IAM role ARN that allows access to the CloudWatch alarm.
     */
    @JvmName("govvmvkgbmancfxw")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): TopicRuleCloudwatchLogArgs = TopicRuleCloudwatchLogArgs(
        batchMode = batchMode,
        logGroupName = logGroupName ?: throw PulumiNullFieldException("logGroupName"),
        roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
    )
}
